/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.utility;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AppCommon {
    public static List<String> getNames(Class<? extends Enum<?>> e) {
        String[] enumNames = Arrays.toString(e.getEnumConstants()).replaceAll("^.|.$", "").split(", ");
        return Arrays.asList(enumNames);
    }

    public static boolean isUrlValid(String url) {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 8L);
        return urlValidator.isValid(url);
    }

    public static boolean isValidEmailAddress(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public static boolean isGUIDValid(String guid) {
        try {
            if (guid == null) {
                return false;
            }
            UUID.fromString(guid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static URL getBaseURL(String url) throws MalformedURLException {
        return new URL(new URL(url), "/");
    }

    public static String mapToQueryString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            try {
                String key = entry.getKey();
                String value = entry.getValue();
                stringBuilder.append(key != null ? URLEncoder.encode(key, "UTF-8") : "");
                stringBuilder.append("=");
                stringBuilder.append(value != null ? URLEncoder.encode(value, "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This method requires UTF-8 encoding support", e);
            }
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> queryStringToMap(String input) {
        String[] nameValuePairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String nameValuePair : nameValuePairs = input.split("&")) {
            String[] nameValue = nameValuePair.split("=");
            try {
                map.put(URLDecoder.decode(nameValue[0], "UTF-8"), nameValue.length > 1 ? URLDecoder.decode(nameValue[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This method requires UTF-8 encoding support", e);
            }
        }
        return map;
    }

    public static Object parseJsonValue(String Data, String key) throws ParseException {
        Object value;
        JSONParser parser = new JSONParser();
        Object parsedData = parser.parse(Data);
        if (parsedData instanceof JSONArray) {
            JSONArray array = (JSONArray)parsedData;
            JSONObject object = (JSONObject)array.get(0);
            value = object.get((Object)key);
        } else {
            JSONObject obj = (JSONObject)parsedData;
            value = obj.get((Object)key);
        }
        return value;
    }

    public static String parseResponseToString(ClassicHttpResponse response) throws IOException {
        BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
        return handler.handleResponse(response);
    }

    public static StandardUsernamePasswordCredentials findCredentialsById(String credentialsId, String descriptorUrlOrJobUrl) throws UnsupportedEncodingException {
        Jenkins jenkins;
        Jenkins credentialsContext = jenkins = Jenkins.get();
        List folders = jenkins.getItems(Folder.class);
        if (folders != null && folders.size() > 0) {
            List<String> folderNames = AppCommon.getFolderNames(descriptorUrlOrJobUrl);
            folderNames.removeIf(item -> item == null || "".equals(item));
            folderNames.remove(folderNames.size() - 1);
            Folder deepestFolder = AppCommon.getDeepestFolder(folders, folderNames);
            if (folders.size() > 0 && deepestFolder != null && CredentialsProvider.hasStores((ModelObject)deepestFolder)) {
                credentialsContext = deepestFolder;
            }
        }
        List matches = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)credentialsContext, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null});
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialsId);
        StandardUsernamePasswordCredentials result = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)matches, (CredentialsMatcher)matcher);
        return result;
    }

    private static List<String> getFolderNames(String descriptorUrlOrJobUrl) throws UnsupportedEncodingException {
        String projectFullUrl = descriptorUrlOrJobUrl;
        if (descriptorUrlOrJobUrl.contains("/job/")) {
            projectFullUrl = URLDecoder.decode(descriptorUrlOrJobUrl, StandardCharsets.UTF_8.toString());
            if (!projectFullUrl.startsWith("/job")) {
                projectFullUrl = projectFullUrl.substring(projectFullUrl.indexOf("/job"));
            }
            projectFullUrl = projectFullUrl.replace("/job/", "/");
        }
        ArrayList<String> folderNames = new ArrayList<String>(Arrays.asList(projectFullUrl.split("/")));
        return folderNames;
    }

    private static Folder getDeepestFolder(List<Folder> folders, List<String> folderNames) {
        if (folders.size() == 0 || folderNames.size() == 0) {
            return null;
        }
        Folder deepestFolder = folders.get(0);
        Optional<Folder> f = folders.stream().filter(w -> w.getName().equals(folderNames.get(0))).findFirst();
        if (f.isPresent()) {
            Folder tempFolder = f.get();
            if (CredentialsProvider.hasStores((ModelObject)tempFolder)) {
                deepestFolder = tempFolder;
            }
            for (int i = 1; i < folderNames.size(); ++i) {
                if (tempFolder == null || (tempFolder = (Folder)tempFolder.getItem(folderNames.get(i))) == null || !CredentialsProvider.hasStores((ModelObject)tempFolder)) continue;
                deepestFolder = tempFolder;
            }
        }
        return deepestFolder;
    }

    public static List<StandardUsernamePasswordCredentials> findCredentials(Item own) {
        List matches = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)own, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null});
        return matches;
    }
}

