/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.model;

import com.acunetix.utility.AppCommon;
import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ScanReport {
    private final ClassicHttpResponse reportRequestResponse;
    private final boolean scanRequestHasError;
    private final String scanRequestErrorMessage;
    private final boolean reportRequestHasError;
    private final String reportRequestErrorMessage;
    private final String requestURI;
    private static String reportHtmlAsString = null;

    public ScanReport(ClassicHttpResponse reportRequestResponse, String requestURI) {
        this.reportRequestResponse = reportRequestResponse;
        this.scanRequestHasError = false;
        this.scanRequestErrorMessage = "";
        this.reportRequestHasError = false;
        this.reportRequestErrorMessage = "";
        this.requestURI = requestURI;
    }

    public ScanReport(boolean scanRequestHasError, String scanRequestErrorMessage, boolean reportRequestHasError, String reportRequestErrorMessage, String requestURI) {
        this.reportRequestResponse = null;
        this.scanRequestHasError = scanRequestHasError;
        this.scanRequestErrorMessage = scanRequestErrorMessage;
        this.reportRequestHasError = reportRequestHasError;
        this.reportRequestErrorMessage = reportRequestErrorMessage;
        this.requestURI = requestURI;
    }

    private String getContentType() {
        return this.reportRequestResponse.getHeaders("Content-Type")[0].getValue();
    }

    public boolean isReportGenerated() {
        try {
            return this.getContentType().equalsIgnoreCase("text/html");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setReportHtmlAsStringField(String reportHtml) {
        reportHtmlAsString = reportHtml;
    }

    public void setReportHtmlAsString(String reportHtml) {
        ScanReport.setReportHtmlAsStringField(reportHtml);
    }

    public String getContent() {
        String content;
        block9: {
            content = "";
            try {
                if (this.scanRequestHasError) {
                    content = this.ExceptionContent(content, this.scanRequestErrorMessage);
                    break block9;
                }
                if (this.reportRequestHasError) {
                    content = this.ExceptionContent(content, this.reportRequestErrorMessage);
                    break block9;
                }
                String contentData = null;
                try {
                    contentData = AppCommon.parseResponseToString(this.reportRequestResponse);
                    this.setReportHtmlAsString(contentData);
                }
                catch (IOException ex) {
                    contentData = reportHtmlAsString;
                }
                if (this.isReportGenerated()) {
                    content = contentData;
                } else {
                    JSONParser parser = new JSONParser();
                    JSONObject obj = (JSONObject)parser.parse(contentData);
                    content = (String)obj.get((Object)"Message");
                }
            }
            catch (ParseException ex) {
                content = this.ExceptionContent("Report result is not parsable.", ex.toString());
            }
            catch (Exception ex) {
                content = this.ExceptionContent(content, ex.toString());
            }
        }
        return content;
    }

    private String ExceptionContent(String content, String ExceptionMessage) {
        content = content != null && !((String)content).isEmpty() ? "<p>" + (String)content + "</p>" : "<p>Something went wrong.</p>";
        if (this.requestURI != null) {
            content = (String)content + "<p>Request URL: " + this.requestURI + "</p>";
        }
        if (this.reportRequestResponse != null) {
            content = (String)content + "<p>HttpStatusCode: " + this.reportRequestResponse.getCode() + "</p>";
        }
        if (ExceptionMessage != null) {
            content = (String)content + "<p>Exception Message:: " + ExceptionMessage + "</p>";
        }
        return content;
    }
}

