/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import hudson.ProxyConfiguration;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class HttpWorker
implements Runnable {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final PrintStream logger;
    private final String url;
    private final String data;
    private final int timeout;
    private static final int RETRIES = 3;

    public HttpWorker(String url, String data, int timeout, PrintStream logger) {
        this.url = url;
        this.data = data;
        this.timeout = timeout;
        this.logger = logger;
    }

    public void submit() {
        this.executorService.submit(this);
    }

    @Override
    public void run() {
        int tried = 0;
        boolean success = false;
        CloseableHttpClient client = this.getHttpClient();
        do {
            ++tried;
            HttpPost post = new HttpPost(this.url);
            post.setEntity((HttpEntity)new StringEntity(this.data, ContentType.APPLICATION_JSON));
            try (ClassicHttpResponse httpResponse = (ClassicHttpResponse)client.execute((ClassicHttpRequest)post, classicHttpResponse -> classicHttpResponse);){
                int responseCode = httpResponse.getCode();
                if (responseCode >= 400) {
                    this.log("Posting data to %s may have failed. Webhook responded with status code - %s", this.url, responseCode);
                    String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    this.log("Message from webhook - %s", response);
                } else {
                    success = true;
                }
            }
            catch (IOException | ParseException e) {
                this.log("Failed to post data to webhook - %s", this.url);
                e.printStackTrace(this.logger);
            }
        } while (tried < 3 && !success);
    }

    private CloseableHttpClient getHttpClient() {
        List noHostProxyPatterns;
        HttpClientBuilder builder = HttpClientBuilder.create();
        Jenkins jenkins = Jenkins.get();
        ProxyConfiguration proxy = jenkins.proxy;
        if (proxy != null && !HttpWorker.isNoProxyHost(this.url, noHostProxyPatterns = proxy.getNoProxyHostPatterns())) {
            builder.setProxy(new HttpHost(proxy.name, proxy.port));
            String username = proxy.getUserName();
            String password = proxy.getSecretPassword().getPlainText();
            if (StringUtils.isNotBlank((String)username)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy.name, proxy.port), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((long)this.timeout, TimeUnit.MILLISECONDS).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout((long)this.timeout, TimeUnit.MILLISECONDS).setSocketTimeout(this.timeout, TimeUnit.MILLISECONDS).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).build();
        builder.setDefaultRequestConfig(requestConfig);
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return builder.build();
    }

    private static boolean isNoProxyHost(String host, List<Pattern> noProxyHostPatterns) {
        if (host != null && noProxyHostPatterns != null) {
            for (Pattern p : noProxyHostPatterns) {
                if (!p.matcher(host).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private void log(String format, Object ... args) {
        this.logger.println("[Office365connector] " + String.format(format, args));
    }
}

