/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.office365connector.FactsBuilder;
import jenkins.plugins.office365connector.Messages;
import jenkins.plugins.office365connector.model.CardAction;
import jenkins.plugins.office365connector.model.adaptivecard.AdaptiveCardAction;
import jenkins.plugins.office365connector.model.messagecard.PotentialAction;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class ActionableBuilder {
    private final Run run;
    private final FactsBuilder factsBuilder;
    private final List<CardAction> potentialActions = new ArrayList<CardAction>();
    private final boolean isAdaptiveCards;

    public ActionableBuilder(Run run, FactsBuilder factsBuilder, boolean isAdaptiveCards) {
        this.run = run;
        this.factsBuilder = factsBuilder;
        this.isAdaptiveCards = isAdaptiveCards;
    }

    public List<CardAction> buildActionable() {
        this.pullRequestActionable();
        this.buildViewBuild();
        return this.potentialActions;
    }

    private void buildViewBuild() {
        String urlToJob = DisplayURLProvider.get().getRunURL(this.run);
        String build = Messages.Office365ConnectorWebhookNotifier_BuildPronoun();
        if (this.run.getResult() != Result.SUCCESS) {
            String viewHeader = Messages.Office365ConnectorWebhookNotifier_ViewHeader(build);
            this.potentialActions.add(this.isAdaptiveCards ? new AdaptiveCardAction(viewHeader, urlToJob) : new PotentialAction(viewHeader, urlToJob));
        }
    }

    private void pullRequestActionable() {
        Job job = this.run.getParent();
        SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
        if (head instanceof ChangeRequestSCMHead) {
            ContributorMetadataAction cma;
            String pronoun = StringUtils.defaultIfBlank((String)head.getPronoun(), (String)Messages.Office365ConnectorWebhookNotifier_ChangeRequestPronoun());
            String viewHeader = Messages.Office365ConnectorWebhookNotifier_ViewHeader(pronoun);
            String titleHeader = Messages.Office365ConnectorWebhookNotifier_TitleHeader(pronoun);
            String authorHeader = Messages.Office365ConnectorWebhookNotifier_AuthorHeader(pronoun);
            ObjectMetadataAction oma = (ObjectMetadataAction)job.getAction(ObjectMetadataAction.class);
            if (oma != null) {
                String urlString = oma.getObjectUrl();
                CardAction viewPRPotentialAction = this.isAdaptiveCards ? new AdaptiveCardAction(viewHeader, urlString) : new PotentialAction(viewHeader, urlString);
                this.potentialActions.add(viewPRPotentialAction);
                this.factsBuilder.addFact(titleHeader, oma.getObjectDisplayName());
            }
            if ((cma = (ContributorMetadataAction)job.getAction(ContributorMetadataAction.class)) != null) {
                String contributor = cma.getContributor();
                String contributorDisplayName = cma.getContributorDisplayName();
                if (StringUtils.isNotBlank((String)contributor) && StringUtils.isNotBlank((String)contributorDisplayName)) {
                    this.factsBuilder.addFact(authorHeader, String.format("%s (%s)", contributor, contributorDisplayName));
                } else {
                    this.factsBuilder.addFact(authorHeader, StringUtils.defaultIfBlank((String)contributor, (String)contributorDisplayName));
                }
            }
        }
    }
}

