/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import hudson.matrix.MatrixProject;
import hudson.model.Api;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import jakarta.servlet.ServletException;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.JiraTestResultReporter.TestToIssueMapping;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class TestToIssueMappingApi
extends Api {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public Api getApi() {
        return this;
    }

    public TestToIssueMappingApi() {
        super(null);
    }

    public void doJson(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        JsonElement result;
        String jobName = req.getParameter("job");
        if (jobName == null) {
            rsp.getWriter().write("You need to set the \"job\" parameter");
            return;
        }
        if (jobName.contains("/")) {
            String matrixJobName = jobName.split("/")[0];
            String matrixSubJobName = jobName.split("/")[1];
            TopLevelItem item = Jenkins.get().getItem(matrixJobName);
            if (item instanceof MatrixProject) {
                MatrixProject matrixProject = (MatrixProject)item;
                result = TestToIssueMapping.getInstance().getMap(matrixProject, matrixSubJobName);
            } else {
                Job job = (Job)Jenkins.get().getItemByFullName(jobName);
                if (job == null) {
                    rsp.sendError(404);
                    return;
                }
                result = TestToIssueMapping.getInstance().getMap(job);
            }
        } else {
            Job job = (Job)Jenkins.get().getItem(jobName);
            if (job == null) {
                rsp.sendError(404);
                return;
            }
            result = TestToIssueMapping.getInstance().getMap(job);
        }
        if (result != null) {
            rsp.setContentType("application/json");
            rsp.getWriter().write(GSON.toJson(result));
        } else {
            rsp.sendError(404);
        }
    }
}

