/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import hudson.EnvVars;
import hudson.Util;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;

public class VariableExpander {
    static Pattern varPattern = Pattern.compile("\\$\\{([\\w\\_]+)\\}");
    static HashMap<String, Delegate> expanders = new HashMap();

    public static String expandVariables(TestResult test, EnvVars envVars, String text) {
        if (test == null) {
            return text;
        }
        Matcher matcher = varPattern.matcher(text);
        ArrayList<String> varsFound = new ArrayList<String>();
        while (matcher.find()) {
            varsFound.add(matcher.group(1));
        }
        for (String varName : varsFound) {
            if (envVars.containsKey((Object)varName)) {
                text = text.replace("${" + varName + "}", (CharSequence)envVars.get((Object)varName));
                continue;
            }
            if (!expanders.containsKey(varName)) continue;
            text = text.replace("${" + varName + "}", Util.fixNull((String)expanders.get(varName).expand(test, envVars)));
        }
        return text;
    }

    static {
        expanders.put("CRLF", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return "\n";
            }
        });
        expanders.put("TEST_RESULT", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                if (test instanceof CaseResult && ((CaseResult)test).isSkipped()) {
                    return "SKIPPED";
                }
                return test.isPassed() ? "FAILED" : "PASSED";
            }
        });
        expanders.put("TEST_NAME", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getDisplayName();
            }
        });
        expanders.put("TEST_FULL_NAME", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getFullDisplayName();
            }
        });
        expanders.put("TEST_STACK_TRACE", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getErrorStackTrace();
            }
        });
        expanders.put("TEST_ERROR_DETAILS", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getErrorDetails();
            }
        });
        expanders.put("TEST_DURATION", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getDurationString();
            }
        });
        expanders.put("TEST_PACKAGE_NAME", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                if (test instanceof CaseResult) {
                    return ((CaseResult)test).getPackageName();
                }
                return "{TEST_PACKAGE_NAME}";
            }
        });
        expanders.put("TEST_STDERR", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getStderr();
            }
        });
        expanders.put("TEST_STDOUT", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getStdout();
            }
        });
        expanders.put("TEST_OVERVIEW", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.toPrettyString();
            }
        });
        expanders.put("TEST_AGE", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                if (test instanceof CaseResult) {
                    return String.valueOf(((CaseResult)test).getAge());
                }
                return "{TEST_AGE}";
            }
        });
        expanders.put("TEST_PASS_COUNT", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return String.valueOf(test.getPassCount());
            }
        });
        expanders.put("TEST_FAIL_COUNT", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return String.valueOf(test.getFailCount());
            }
        });
        expanders.put("TEST_SKIPPED_COUNT", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return String.valueOf(test.getSkipCount());
            }
        });
        expanders.put("TEST_FAIL_SINCE", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return String.valueOf(test.getFailedSince());
            }
        });
        expanders.put("TEST_IS_REGRESSION", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                if (test instanceof CaseResult) {
                    return String.valueOf(((CaseResult)test).getStatus().isRegression());
                }
                return "{TEST_IS_REGRESSION}";
            }
        });
        expanders.put("TEST_PACKAGE_CLASS_METHOD_NAME", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                if (test instanceof CaseResult) {
                    CaseResult t = (CaseResult)test;
                    return String.format("%s.%s", t.getClassName(), t.getName());
                }
                return "{TEST_PACKAGE_CLASS_METHOD_NAME}";
            }
        });
        expanders.put("BUILD_RESULT", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return test.getBuildResult().toString();
            }
        });
        expanders.put("DEFAULT_SUMMARY", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return VariableExpander.expandVariables(test, envVars, JiraUtils.getJiraDescriptor().getDefaultSummary());
            }
        });
        expanders.put("DEFAULT_DESCRIPTION", new Delegate(){

            @Override
            public String expand(TestResult test, EnvVars envVars) {
                return VariableExpander.expandVariables(test, envVars, JiraUtils.getJiraDescriptor().getDefaultDescription());
            }
        });
    }

    private static interface Delegate {
        public String expand(TestResult var1, EnvVars var2);
    }
}

