/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.exclusion;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jvnet.hudson.plugins.exclusion.Id;
import org.jvnet.hudson.plugins.exclusion.IdAllocationManager;
import org.jvnet.hudson.plugins.exclusion.IdType;
import org.jvnet.hudson.plugins.exclusion.IdTypeDescriptor;
import org.jvnet.hudson.plugins.exclusion.RessourcesMonitor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdAllocator
extends BuildWrapper {
    private IdType[] ids = null;
    public static List<RessourcesMonitor> listRessources = new ArrayList<RessourcesMonitor>();
    private static String jName = "unknow";
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public IdAllocator(IdType[] ids) {
        this.ids = ids;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final ArrayList<String> allocated = new ArrayList<String>();
        final ArrayList<Id> alloc = new ArrayList<Id>();
        final String buildName = build.getProject().getName();
        Computer cur = Executor.currentExecutor().getOwner();
        IdAllocationManager pam = IdAllocationManager.getManager(cur);
        for (IdType pt : this.ids) {
            allocated.add(pt.name);
            Id p = pt.allocate(false, build, pam, launcher, listener);
            alloc.add(p);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild abstractBuild, BuildListener buildListener) throws IOException, InterruptedException {
                for (Id p : alloc) {
                    AbstractBuild get = IdAllocationManager.ids.get(p.type.name);
                    if (get == null || !get.getProject().getName().equals(abstractBuild.getProject().getName())) continue;
                    p.cleanUp();
                }
                return true;
            }

            public void buildEnvVars(Map<String, String> env) {
                int i = 0;
                for (String p : allocated) {
                    env.put("variableEnv" + buildName + i, p);
                    env.put(p, p);
                    ++i;
                }
            }
        };
    }

    public IdType[] getIds() {
        return this.ids;
    }

    public void setIds(IdType[] ids) {
        this.ids = ids;
    }

    public static List<RessourcesMonitor> getListRessources() {
        return listRessources;
    }

    public static void setListRessources(List<RessourcesMonitor> list) {
        listRessources = list;
    }

    public static void updateList(String oldProjecName, String newProjectName) {
        for (int i = listRessources.size() - 1; i >= 0; --i) {
            if (!listRessources.get(i).getJobName().equals(oldProjecName)) continue;
            String ressource = listRessources.get(i).getRessource();
            listRessources.remove(i);
            listRessources.add(new RessourcesMonitor(newProjectName, ressource));
        }
    }

    public static void deleteList(String ProjectName) {
        for (int i = listRessources.size() - 1; i >= 0; --i) {
            if (!listRessources.get(i).getJobName().equals(ProjectName)) continue;
            listRessources.remove(i);
        }
    }

    public static void updateBuild(String ProjectName, String resourceName, boolean build) {
        for (int i = listRessources.size() - 1; i >= 0; --i) {
            if (!listRessources.get(i).getJobName().equals(ProjectName) || !listRessources.get(i).getRessource().equals(resourceName)) continue;
            RessourcesMonitor rmGet = listRessources.get(i);
            listRessources.remove(i);
            rmGet.setBuild(build);
            listRessources.add(rmGet);
        }
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        String projectName = "unknow";
        String[] threadName = Executor.currentThread().getName().split(" ");
        if (threadName[0].equals("Loading") && threadName[1].equals("job")) {
            projectName = "";
            for (int i = 2; i < threadName.length - 1; ++i) {
                projectName = projectName + threadName[i] + " ";
            }
            projectName = projectName + threadName[threadName.length - 1];
        } else {
            projectName = jName;
        }
        if (!projectName.equals("unknow")) {
            try {
                projectName = URLDecoder.decode(projectName, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            for (int i = listRessources.size() - 1; i >= 0; --i) {
                if (!listRessources.get(i).getJobName().equals(projectName)) continue;
                listRessources.remove(i);
            }
            for (IdType pt : this.getIds()) {
                listRessources.add(new RessourcesMonitor(projectName, pt.name));
            }
        }
        jName = "unknow";
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        DescriptorImpl() {
            super(IdAllocator.class);
            this.load();
        }

        public String getDisplayName() {
            return "Add resource to manage exclusion";
        }

        public String getHelpFile() {
            return "/plugin/exclusion/help.html";
        }

        public List<IdTypeDescriptor> getIdTypes() {
            return IdTypeDescriptor.LIST;
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List ids = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"ids", IdTypeDescriptor.LIST);
            String[] split = req.getReferer().split("/");
            for (int i = 0; i < split.length; ++i) {
                if (!split[i].equals("job")) continue;
                jName = split[i + 1];
            }
            IdAllocator portAlloc = new IdAllocator(ids.toArray(new IdType[ids.size()]));
            return portAlloc;
        }
    }
}

