/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.exclusion;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import org.jvnet.hudson.plugins.exclusion.DefaultIdType;
import org.jvnet.hudson.plugins.exclusion.Id;
import org.jvnet.hudson.plugins.exclusion.IdAllocationManager;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriticalBlockStart
extends Builder {
    public static IdAllocationManager pam = null;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CriticalBlockStart() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Computer cur = Executor.currentExecutor().getOwner();
        pam = IdAllocationManager.getManager(cur);
        PrintStream logger = listener.getLogger();
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        ArrayList<String> listId = new ArrayList<String>();
        Set cles = environment.keySet();
        for (String cle : cles) {
            String name;
            if (!cle.contains(name = "variableEnv" + build.getProject().getName())) continue;
            String valeur = (String)environment.get((Object)cle);
            listId.add(valeur);
        }
        if (listId != null) {
            for (String id : listId) {
                DefaultIdType p = new DefaultIdType(id);
                logger.println("[Exclusion] -> Allocating resource : " + id);
                Id resource = p.allocate(true, build, pam, launcher, listener);
                logger.println("[Exclusion] -> Assigned " + resource.get());
            }
            if (!listId.isEmpty()) {
                logger.println("[Exclusion] -> Resource allocation complete");
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Critical block start";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        DescriptorImpl() {
            super(CriticalBlockStart.class);
            this.load();
        }

        public String getDisplayName() {
            return "Critical block start";
        }

        public String getHelpFile() {
            return "/plugin/exclusion/helpCBS.html";
        }
    }
}

