/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.exclusion;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.RootAction;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jvnet.hudson.plugins.exclusion.CriticalBlockStart;
import org.jvnet.hudson.plugins.exclusion.DefaultIdType;
import org.jvnet.hudson.plugins.exclusion.Id;
import org.jvnet.hudson.plugins.exclusion.IdAllocationManager;
import org.jvnet.hudson.plugins.exclusion.IdAllocator;
import org.jvnet.hudson.plugins.exclusion.RessourcesMonitor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
@Extension
public class AdministrationPanel
implements RootAction {
    private List<RessourcesMonitor> listRessources = IdAllocator.getListRessources();
    private List<RessourcesMonitor> list;

    public List<RessourcesMonitor> getList() {
        return this.list;
    }

    public void load() {
        ArrayList<String> allJobsName = new ArrayList<String>();
        ArrayList<String> allExclusionJobs = new ArrayList<String>();
        for (Project p : Hudson.getInstance().getProjects()) {
            allJobsName.add(p.getName());
            Map buildWrappers = p.getBuildWrappers();
            for (Descriptor key : buildWrappers.keySet()) {
                if (!((BuildWrapper)buildWrappers.get(key)).getDescriptor().toString().split("@")[0].equals("org.jvnet.hudson.plugins.exclusion.IdAllocator$DescriptorImpl") || allExclusionJobs.contains(p.getName())) continue;
                allExclusionJobs.add(p.getName());
            }
        }
        for (String jobName : allJobsName) {
            if (allExclusionJobs.contains(jobName)) continue;
            IdAllocator.deleteList(jobName);
        }
        for (RessourcesMonitor rm : this.listRessources) {
            rm.setBuild(false);
        }
        for (String resource : IdAllocationManager.ids.keySet()) {
            IdAllocator.updateBuild(IdAllocationManager.ids.get(resource).getProject().getName(), resource, true);
        }
        this.list = new ArrayList<RessourcesMonitor>();
        for (RessourcesMonitor rm : this.listRessources) {
            this.list.add(new RessourcesMonitor(rm.getJobName(), rm.getRessource(), rm.getBuild()));
        }
    }

    public void doFreeResource(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="resourceName") String resourceName) throws IOException, InterruptedException {
        for (RessourcesMonitor rm : this.list) {
            if (!rm.getRessource().equals(resourceName) || !rm.getBuild()) continue;
            DefaultIdType p = new DefaultIdType(resourceName);
            Id i = p.allocate(false, null, CriticalBlockStart.pam, null, null);
            AbstractBuild get = IdAllocationManager.ids.get(resourceName);
            if (get == null || !get.getProject().getName().equals(rm.getJobName())) continue;
            i.cleanUp();
        }
        rsp.sendRedirect(res.getContextPath() + this.getUrlName());
    }

    public String getIconFileName() {
        return "/plugin/Exclusion/icons/exclusion.png";
    }

    public String getDisplayName() {
        return "Exclusion administration";
    }

    public String getUrlName() {
        return "/administrationpanel";
    }
}

