/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.cli.auth.ssh;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.userproperty.UserPropertyCategory;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.server.auth.pubkey.KeySetPublickeyAuthenticator;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UserPropertyImpl
extends UserProperty {
    public String authorizedKeys;

    @DataBoundConstructor
    public UserPropertyImpl(String authorizedKeys) {
        this.authorizedKeys = authorizedKeys;
    }

    public boolean has(PublicKey pk) {
        KeySetPublickeyAuthenticator keySetPublickeyAuthenticator = new KeySetPublickeyAuthenticator((Object)((Object)((Object)this)).getClass().getName(), UserPropertyImpl.getPublicKeys(this.authorizedKeys));
        return keySetPublickeyAuthenticator.authenticate(null, pk, null);
    }

    public boolean isAuthorizedKey(String sig) {
        List<PublicKey> keys = UserPropertyImpl.getPublicKeys(sig);
        if (keys.isEmpty()) {
            return false;
        }
        for (PublicKey key : keys) {
            boolean authz = this.has(key);
            if (!authz) continue;
            return true;
        }
        return false;
    }

    private static List<PublicKey> getPublicKeys(String keys) {
        return Arrays.stream(keys.split("\n")).map(s -> {
            try {
                return PublicKeyEntry.parsePublicKeyEntry((String)s).resolvePublicKey(null, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    public static User findUser(PublicKey identity) {
        for (User u : User.getAll()) {
            UserPropertyImpl p = (UserPropertyImpl)u.getProperty(UserPropertyImpl.class);
            if (p == null || !p.has(identity)) continue;
            return u;
        }
        return null;
    }

    @Extension
    @Symbol(value={"sshPublicKey"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "SSH Public Keys";
        }

        @NonNull
        public UserPropertyCategory getUserPropertyCategory() {
            return UserPropertyCategory.get(UserPropertyCategory.Security.class);
        }

        public UserProperty newInstance(User user) {
            return null;
        }

        public FormValidation doCheckAuthorizedKeys(@QueryParameter String value) throws IOException {
            String s;
            BufferedReader r = new BufferedReader(new StringReader(value));
            while ((s = r.readLine()) != null) {
                if (s.isEmpty()) continue;
                try {
                    UserPropertyImpl.getPublicKeys(s);
                }
                catch (Exception ex) {
                    return FormValidation.warning((String)ex.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

