/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.cli.auth.ssh;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.security.PublicKey;
import org.jenkinsci.Symbol;
import org.jenkinsci.main.modules.cli.auth.ssh.PublicKeySignatureWriter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UserPropertyImpl
extends UserProperty {
    private static final PublicKeySignatureWriter signature = new PublicKeySignatureWriter();
    public String authorizedKeys;

    @DataBoundConstructor
    public UserPropertyImpl(String authorizedKeys) {
        this.authorizedKeys = authorizedKeys;
    }

    public boolean has(PublicKey pk) {
        return this.isAuthorizedKey(signature.asString(pk));
    }

    public boolean isAuthorizedKey(String sig) {
        try {
            String s;
            BufferedReader r = new BufferedReader(new StringReader(this.authorizedKeys));
            while ((s = r.readLine()) != null) {
                String[] tokens = s.split("\\s+");
                if (tokens.length < 2 || !tokens[1].equals(sig)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static User findUser(PublicKey identity) {
        String sig = signature.asString(identity);
        for (User u : User.getAll()) {
            UserPropertyImpl p = (UserPropertyImpl)u.getProperty(UserPropertyImpl.class);
            if (p == null || !p.isAuthorizedKey(sig)) continue;
            return u;
        }
        return null;
    }

    @Extension
    @Symbol(value={"sshPublicKey"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "SSH Public Keys";
        }

        public UserProperty newInstance(User user) {
            return null;
        }

        public FormValidation doCheckAuthorizedKeys(@QueryParameter String value) throws IOException {
            String s;
            BufferedReader r = new BufferedReader(new StringReader(value));
            while ((s = r.readLine()) != null) {
                String[] tokens = s.split("\\s+");
                if (tokens.length < 2) {
                    if (s.trim().isEmpty()) continue;
                    return FormValidation.warning((String)("Unexpected line: \u2018" + s + "\u2019"));
                }
                if (!tokens[0].matches("ssh-[a-z]+")) {
                    return FormValidation.warning((String)("\u2018" + tokens[0] + "\u2019 does not look like a valid key type"));
                }
                if (tokens[1].matches("[a-zA-Z0-9/+]+=*")) continue;
                return FormValidation.error((String)("\u2018" + tokens[1] + "\u2019 does not look like a Base64-encoded public key"));
            }
            return FormValidation.ok();
        }
    }
}

