/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.dtkit.util.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.lib.dtkit.util.validator.ErrorType;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ValidationHandler
implements ErrorHandler,
Serializable {
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    @Override
    public void error(SAXParseException ex) {
        this.errors.add(new ValidationError(ErrorType.ERROR, ex.getLineNumber(), ex.getSystemId(), ex.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException ex) {
        System.err.println("At line " + ex.getLineNumber() + " of " + ex.getSystemId() + ':');
        System.err.println(ex.getMessage());
        this.errors.add(new ValidationError(ErrorType.FATAL_ERROR, ex.getLineNumber(), ex.getSystemId(), ex.getMessage()));
    }

    @Override
    public void warning(SAXParseException ex) {
        System.err.println("At line " + ex.getLineNumber() + " of " + ex.getSystemId() + ':');
        System.err.println(ex.getMessage());
        this.errors.add(new ValidationError(ErrorType.WARNING, ex.getLineNumber(), ex.getSystemId(), ex.getMessage()));
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }
}

