/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.dtkit.util.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.jenkinsci.lib.dtkit.util.converter.ConversionException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConversionService
implements Serializable {
    public void convert(File xslFile, File inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try (FileInputStream xsl = new FileInputStream(xslFile);){
            this.convert(new StreamSource(xsl), inputFile, outFile, params);
        }
        catch (IOException e) {
            throw this.asConversionException(e);
        }
    }

    public void convert(File xslFile, File inputFile, File outFile) throws ConversionException {
        this.convert(xslFile, inputFile, outFile, null);
    }

    public void convert(StreamSource xslSource, File inputFile, File outFile) throws ConversionException {
        this.convert(xslSource, inputFile, outFile, null);
    }

    public void convert(StreamSource xslSource, File inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try (FileInputStream input = new FileInputStream(inputFile);){
            this.convert(xslSource, new InputSource(input), outFile, params);
        }
        catch (IOException e) {
            throw this.asConversionException(e);
        }
    }

    public void convert(File xslFile, InputSource inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try (FileInputStream xsl = new FileInputStream(xslFile);){
            this.convert(new StreamSource(xsl), inputFile, outFile, params);
        }
        catch (IOException e) {
            throw this.asConversionException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertAndReturn(File xslFile, InputSource inputFile, Map<String, Object> params) throws ConversionException {
        try (FileInputStream xsl = new FileInputStream(xslFile);){
            String string = this.convertAndReturn(new StreamSource(xsl), inputFile, params);
            return string;
        }
        catch (IOException e) {
            throw this.asConversionException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public String convertAndReturn(File xslFile, File inputFile, Map<String, Object> params) throws ConversionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertAndReturn(StreamSource xslSource, File inputFile, Map<String, Object> params) throws ConversionException {
        try (FileInputStream input = new FileInputStream(inputFile);){
            String string = this.convertAndReturn(xslSource, new InputSource(input), params);
            return string;
        }
        catch (IOException e) {
            throw this.asConversionException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertAndReturn(StreamSource xslSource, InputSource inputFile, Map<String, Object> params) throws ConversionException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.convert(xslSource, inputFile, output, params);
            String string = new String(output.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception e) {
            throw this.asConversionException(e);
        }
    }

    public void convert(StreamSource xslSource, InputSource inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        try (FileOutputStream os = new FileOutputStream(outFile);){
            this.convert(xslSource, inputFile, os, params);
        }
        catch (Exception e) {
            throw this.asConversionException(e);
        }
    }

    private void convert(StreamSource xslSource, InputSource inputFile, OutputStream output, Map<String, Object> params) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Processor processor = new Processor(false);
        processor.setConfigurationProperty(Feature.ENTITY_RESOLVER_CLASS, (Object)DTKitEntityresolver.class.getName());
        processor.setConfigurationProperty(Feature.DTD_VALIDATION, (Object)false);
        processor.setConfigurationProperty(Feature.DTD_VALIDATION_RECOVERABLE, (Object)true);
        processor.getUnderlyingConfiguration().setValidation(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        XsltExecutable stylesheet = compiler.compile((Source)xslSource);
        Xslt30Transformer transformer = stylesheet.load30();
        Serializer out = processor.newSerializer(output);
        out.setOutputProperty(Serializer.Property.INDENT, "yes");
        StreamSource source = new StreamSource(inputFile.getByteStream());
        transformer.transform((Source)source, (Destination)out);
    }

    private ConversionException asConversionException(Exception e) {
        if (e instanceof FileNotFoundException) {
            return new ConversionException(e);
        }
        if (e instanceof IOException) {
            return new ConversionException("Conversion Error", e);
        }
        if (e instanceof SaxonApiException) {
            throw new ConversionException("Error to convert the input XML document", e);
        }
        if (e instanceof SAXException || e instanceof ParserConfigurationException) {
            throw new ConversionException("Error to convert - A file not found", e);
        }
        return new ConversionException(e);
    }

    public static class DTKitEntityresolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

