/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.dtkit.util.validator;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jenkinsci.lib.dtkit.util.validator.ErrorType;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.jenkinsci.lib.dtkit.util.validator.ValidationException;
import org.jenkinsci.lib.dtkit.util.validator.ValidationHandler;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidationService
implements Serializable {
    public List<ValidationError> processValidation(Source xsdSource, File inputXML) throws ValidationException {
        return this.processValidation(new Source[]{xsdSource}, inputXML);
    }

    public List<ValidationError> processValidation(File[] xsdFiles, File inputXML) throws ValidationException {
        ArrayList<FileInputStream> sources = new ArrayList<FileInputStream>(xsdFiles.length);
        try {
            for (File xsd : xsdFiles) {
                sources.add(new FileInputStream(xsd));
            }
            Source[] ss = (StreamSource[])sources.stream().map(s -> new StreamSource((InputStream)s)).toArray(StreamSource[]::new);
            List<ValidationError> list = this.processValidation(ss, inputXML);
            return list;
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
        finally {
            sources.stream().forEach(s -> ValidationService.closeQuietly(s));
        }
    }

    public List<ValidationError> processValidation(Source[] xsdSources, File inputXML) throws ValidationException {
        ValidationHandler handler = new ValidationHandler();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(handler);
            Schema schemaGrammar = schemaFactory.newSchema(xsdSources);
            Resolver resolver = new Resolver();
            Validator schemaValidator = schemaGrammar.newValidator();
            schemaValidator.setErrorHandler(handler);
            schemaValidator.setResourceResolver(resolver);
            schemaValidator.validate(new StreamSource(inputXML));
            for (int i = 0; i < xsdSources.length; ++i) {
                xsdSources[i] = null;
            }
            return handler.getErrors();
        }
        catch (SAXException sae) {
            List<ValidationError> errors = handler.getErrors();
            errors.add(new ValidationError(ErrorType.ERROR, -1, "-1", sae.getMessage()));
            return errors;
        }
        catch (IOException ioe) {
            throw new ValidationException("Validation error", ioe);
        }
    }

    public List<ValidationError> processValidation(File xsdFile, File inputXML) throws ValidationException {
        return this.processValidation(new StreamSource(xsdFile), inputXML);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static class Resolver
    implements LSResourceResolver {
        protected Resolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespace, String publicId, String systemId, String baseURI) {
            return null;
        }
    }
}

