/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.maven;

import com.thalesgroup.dtkit.maven.HudsonGenerator;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GeneratorMojo
extends AbstractMojo {
    private MavenProject project;
    private List projectClasspathList;

    public void execute() throws MojoExecutionException {
        try {
            URL[] urls;
            ArrayList<Artifact> computeClassPathList = new ArrayList<Artifact>();
            for (int i = 0; i < this.projectClasspathList.size(); ++i) {
                Artifact artifact = (Artifact)this.projectClasspathList.get(i);
                if ("org.jvnet.hudson.plugins".equals(artifact.getGroupId())) continue;
                computeClassPathList.add(artifact);
            }
            File output = new File(this.project.getBuild().getOutputDirectory());
            if (output.exists()) {
                urls = new URL[computeClassPathList.size() + 1];
                urls[urls.length - 1] = new URL("file:///" + this.project.getBuild().getOutputDirectory() + "/");
            } else {
                urls = new URL[computeClassPathList.size()];
            }
            for (int i = 0; i < computeClassPathList.size(); ++i) {
                Artifact artifact = (Artifact)computeClassPathList.get(i);
                urls[i] = new URL("file:///" + artifact.getFile().getPath());
            }
            URLClassLoader cl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            this.getLog().info((CharSequence)"Introspecting all DTKIT metrics");
            ServiceLoader<InputMetric> metricsLoader = ServiceLoader.load(InputMetric.class, cl);
            metricsLoader.reload();
            for (InputMetric metric : metricsLoader) {
                this.getLog().info((CharSequence)("Genererating the Hudson class for " + metric.getLabel() + " metric"));
                switch (metric.getToolType()) {
                    case TEST: {
                        this.generateTest("com.thalesgroup.dtkit.metrics.hudson.model", metric);
                        break;
                    }
                    case COVERAGE: {
                        this.generateCoverage("com.thalesgroup.dtkit.metrics.hudson.model", metric);
                        break;
                    }
                    case MEASURE: {
                        this.generateMeasure("com.thalesgroup.dtkit.metrics.hudson.model", metric);
                        break;
                    }
                    case VIOLATION: {
                        this.generateViolation("com.thalesgroup.dtkit.metrics.hudson.model", metric);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("A problem occured during Hudson generation " + e));
        }
    }

    private void generateHudsonClass(String packageName, InputMetric inputMetric, String hudsonType, String hudsonDescriptorType) throws IOException {
        String buildName;
        File targetDirectory = new File(this.project.getBuild().getDirectory() + "/generated-sources/groovy");
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        File packageDir = new File(targetDirectory, packageName.replace('.', '/'));
        if (inputMetric.getOutputFormatType() != null) {
            String keyFormat = inputMetric.getOutputFormatType().getKey();
            keyFormat = keyFormat.substring(0, 1).toUpperCase() + keyFormat.substring(1);
            buildName = inputMetric.getToolName() + keyFormat + "Hudson" + hudsonType;
        } else {
            buildName = inputMetric.getToolName() + "Hudson" + hudsonType;
        }
        String classname = buildName.substring(0, 1).toUpperCase() + buildName.substring(1);
        String newClassContent = new HudsonGenerator().getGeneratedClass(classname, hudsonType, hudsonDescriptorType, packageName, inputMetric);
        packageDir.mkdirs();
        FileOutputStream fos = new FileOutputStream(new File(packageDir, classname + ".java"));
        fos.write(newClassContent.getBytes());
        fos.close();
    }

    private void generateTest(String packageName, InputMetric inputMetric) throws Exception {
        this.generateHudsonClass(packageName, inputMetric, "TestType", "TestTypeDescriptor");
    }

    private void generateCoverage(String packageName, InputMetric inputMetric) throws Exception {
        this.generateHudsonClass(packageName, inputMetric, "CoverageType", "CoverageTypeDescriptor");
    }

    private void generateMeasure(String packageName, InputMetric inputMetric) throws Exception {
        this.generateHudsonClass(packageName, inputMetric, "MeasureType", "MeasureTypeDescriptor");
    }

    private void generateViolation(String packageName, InputMetric inputMetric) throws Exception {
        this.generateHudsonClass(packageName, inputMetric, "ViolationsType", "ViolationsTypeDescriptor");
    }
}

