/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.tusar.model;

import com.thalesgroup.dtkit.tusar.model.Distribution;
import com.thalesgroup.dtkit.tusar.model.DistributionClassification;
import com.thalesgroup.dtkit.tusar.model.FileMetrics;
import com.thalesgroup.dtkit.tusar.model.MethodMetric;
import com.thalesgroup.dtkit.tusar.model.SourceMetric;
import java.util.ArrayList;
import java.util.List;

public class AbstractMeterable
extends SourceMetric {
    private List<FileMetrics> files = new ArrayList<FileMetrics>();
    private Distribution filesComplexity = new Distribution(DistributionClassification.CLASS_COMPLEXITY);
    private Distribution methodsComplexity = new Distribution(DistributionClassification.METHOD_COMPLEXITY);

    public void addFile(FileMetrics file) {
        this.files.add(file);
        this.countBlankLines += file.getCountBlankLines();
        this.countAccessors += file.getCountAccessors();
        int fileComplexity = file.getComplexity();
        this.filesComplexity.addEntry(fileComplexity);
        List<MethodMetric> methods = file.getMethods();
        for (MethodMetric methodMetric : methods) {
            int methodComplexity = methodMetric.getComplexity();
            this.methodsComplexity.addEntry(methodComplexity);
        }
    }

    public List<FileMetrics> getFiles() {
        return this.files;
    }

    public String getClassComplexityDistribution() {
        return this.filesComplexity.toSonarRepresentation();
    }

    public String getMethodComplexityDistribution() {
        return this.methodsComplexity.toSonarRepresentation();
    }
}

