/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.tusar.model;

import com.thalesgroup.dtkit.tusar.model.DistributionClassification;

public class Distribution {
    private final DistributionClassification classification;
    private final int[] segments;

    public Distribution(DistributionClassification classification) {
        this.classification = classification;
        int countClasses = classification.getCountClasses();
        this.segments = new int[countClasses];
    }

    public void addEntry(int value) {
        int segmentNumber;
        int n = segmentNumber = this.classification.getSegmentNumber(value);
        this.segments[n] = this.segments[n] + 1;
    }

    public void combine(Distribution distribution) {
        if (!this.classification.equals(distribution.classification)) {
            throw new IllegalArgumentException("Impossible to combine two distribution that don't share the same distribution");
        }
        for (int idx = 0; idx < this.segments.length; ++idx) {
            int n = idx;
            this.segments[n] = this.segments[n] + distribution.segments[idx];
        }
    }

    public String toSonarRepresentation() {
        StringBuilder buffer = new StringBuilder();
        int countStops = this.segments.length - 1;
        for (int idx = 0; idx < countStops; ++idx) {
            int limit = this.classification.getStop(idx);
            buffer.append(limit);
            buffer.append("=");
            buffer.append(this.segments[idx]);
            buffer.append(";");
        }
        int lastLimit = this.classification.getStop(countStops);
        buffer.append(lastLimit);
        buffer.append("=");
        buffer.append(this.segments[countStops]);
        return buffer.toString();
    }
}

