/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.tusar;

import com.thalesgroup.dtkit.tusar.BlankLineCounter;
import com.thalesgroup.dtkit.tusar.model.FileMetrics;
import com.thalesgroup.dtkit.tusar.model.MethodMetric;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SourceMonitorResultParser {
    private XPath xpath;
    private File baseDir;
    private Map<String, XPathExpression> expressions;

    public SourceMonitorResultParser() {
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
        this.expressions = new HashMap<String, XPathExpression>();
    }

    public List<FileMetrics> parse(File directory, File reportFile) {
        this.baseDir = directory;
        ArrayList<FileMetrics> result = new ArrayList<FileMetrics>();
        try {
            URL reportURL = reportFile.toURI().toURL();
            InputSource source = new InputSource(reportURL.openStream());
            XPathExpression expression = this.xpath.compile("//file");
            NodeList nodes = (NodeList)expression.evaluate(source, XPathConstants.NODESET);
            int length = nodes.getLength();
            for (int idxNode = 0; idxNode < length; ++idxNode) {
                Element fileNode = (Element)nodes.item(idxNode);
                FileMetrics fileMetrics = this.createMetrics(fileNode);
                result.add(fileMetrics);
            }
        }
        catch (XPathExpressionException e) {
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    private FileMetrics createMetrics(Element fileNode) {
        String rawFileName = fileNode.getAttribute("file_name");
        String directoryPath = "";
        Element projectElement = (Element)fileNode.getParentNode().getParentNode().getParentNode().getParentNode();
        NodeList projectDirElements = projectElement.getElementsByTagName("project_directory");
        if (projectDirElements.getLength() > 0) {
            Element projectDirElement = (Element)projectDirElements.item(0);
            directoryPath = projectDirElement.getTextContent();
        }
        int countMethods = this.getIntMetric(fileNode, "method_metrics/@method_count");
        FileMetrics result = new FileMetrics();
        String tmpPath = this.baseDir.getPath();
        if (!directoryPath.equals("")) {
            tmpPath = StringUtils.startsWith((String)(directoryPath = FilenameUtils.separatorsToUnix((String)directoryPath)), (String)"../") ? StringUtils.substringAfter((String)directoryPath, (String)"../") : directoryPath;
        }
        File path = this.toFullPath(rawFileName, tmpPath);
        int countBlankLines = BlankLineCounter.countBlankLines(path);
        result.setSourcePath(path);
        result.setCountBlankLines(countBlankLines);
        result.setProjectDirectory(new File(directoryPath));
        List<MethodMetric> extractMethods = this.extractMethods(fileNode, path);
        for (MethodMetric methodMetric : extractMethods) {
            result.addMethod(methodMetric);
        }
        return result;
    }

    private List<MethodMetric> extractMethods(Element fileNode, File file) {
        ArrayList<MethodMetric> result = new ArrayList<MethodMetric>();
        try {
            NodeList methodNodes = (NodeList)this.xpath.evaluate("method_metrics/method", fileNode, XPathConstants.NODESET);
            int countNodes = methodNodes.getLength();
            for (int idxMethod = 0; idxMethod < countNodes; ++idxMethod) {
                Element methodNode = (Element)methodNodes.item(idxMethod);
                MethodMetric methodMetrics = this.generateMethod(methodNode, file);
                result.add(methodMetrics);
            }
        }
        catch (XPathExpressionException e) {
            // empty catch block
        }
        return result;
    }

    private MethodMetric generateMethod(Element methodNode, File file) {
        String methodName;
        String className;
        String rawName = methodNode.getAttribute("name");
        boolean isAccessor = false;
        if (rawName.endsWith(".get()") || rawName.endsWith(".set()")) {
            isAccessor = true;
            String fullPropertyName = StringUtils.substringBeforeLast((String)rawName, (String)".");
            String propertyName = StringUtils.substringAfterLast((String)fullPropertyName, (String)".");
            className = StringUtils.substringBeforeLast((String)fullPropertyName, (String)".");
            methodName = StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)rawName, (String)"."), (String)"()") + "_" + propertyName + "()";
        } else {
            methodName = StringUtils.substringAfterLast((String)rawName, (String)".");
            className = StringUtils.substringBeforeLast((String)rawName, (String)".");
        }
        int complexity = this.getIntElement(methodNode, "complexity");
        MethodMetric methodMetrics = new MethodMetric();
        methodMetrics.setClassName(className);
        methodMetrics.setFile(file);
        methodMetrics.setMethodName(methodName);
        methodMetrics.setComplexity(complexity);
        methodMetrics.setAccessor(isAccessor);
        return methodMetrics;
    }

    private int getIntAttribute(Element element, String attributeName) {
        String value = this.getElementAttribute(element, attributeName);
        int result = this.convertToInteger(value);
        return result;
    }

    private int getIntElement(Element element, String attributeName) {
        Element subElement = this.getSubElement(element, attributeName);
        if (subElement == null) {
            return 0;
        }
        String value = subElement.getTextContent();
        int result = this.convertToInteger(value);
        return result;
    }

    private int convertToInteger(String value) {
        if (value == null) {
            return 0;
        }
        int result = 0;
        try {
            if (value != null) {
                result = (int)Double.parseDouble(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private String getElementAttribute(Element element, String attributeName) {
        if (element == null) {
            return null;
        }
        String value = element.getAttribute(attributeName);
        return value;
    }

    private Element getSubElement(Element element, String elementName) {
        if (element == null) {
            return null;
        }
        NodeList subElements = element.getElementsByTagName(elementName);
        if (subElements.getLength() == 0) {
            return null;
        }
        return (Element)subElements.item(0);
    }

    private File toFullPath(String rawFileName, String path) {
        File file;
        try {
            file = new File(path, rawFileName).getCanonicalFile();
        }
        catch (IOException e) {
            file = new File(path, rawFileName);
        }
        return file;
    }

    public int getIntMetric(Node node, String path) {
        String value = this.getAttributeMetric(node, path);
        int result = 0;
        try {
            if (value != null) {
                result = (int)Double.parseDouble(value);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return result;
    }

    public double getDoubleMetric(Node node, String path) {
        String value = this.getAttributeMetric(node, path);
        double result = 0.0;
        try {
            if (value != null) {
                result = Double.parseDouble(value);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return result;
    }

    public String getAttributeMetric(Node node, String path) {
        try {
            XPathExpression expression = this.expressions.get(path);
            if (expression == null) {
                expression = this.xpath.compile(path);
                this.expressions.put(path, expression);
            }
            String result = expression.evaluate(node);
            return result;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }
}

