/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.tusar;

import com.thalesgroup.dtkit.tusar.PurifyTextParser;
import com.thalesgroup.dtkit.tusar.model.FilePurifyMetrics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jenkinsci.lib.dtkit.util.converter.ConversionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PurifyReportParser {
    private XPath xpath;
    private int numberOfErrors = 0;
    private int numberOfMemoryLeaks = 0;
    private int bytesLost = 0;
    private String str_filehead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tusar:tusar xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n             xmlns:measures=\"http://www.thalesgroup.com/tusar/measures/v7\"\n             xmlns:memory=\"http://www.thalesgroup.com/tusar/memory/v1\"\n             xmlns:tusar=\"http://www.thalesgroup.com/tusar/v11\"\n             version=\"11\">\n    <tusar:measures toolname=\"purify\">\n    \t<measures:memory>\n";
    private String str_filetail = "    </measures:memory>\n  \t</tusar:measures>\n\t</tusar:tusar>";

    public PurifyReportParser() {
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    public static void main(String[] args) {
        PurifyReportParser mrp = new PurifyReportParser();
        File inputFile = new File("C:\\Users\\GENIATIS\\.jenkins\\jobs\\helloPurify\\workspace\\PurifyPlusProject\\Purify\\my_junk.txt");
        File reportFile = new File(inputFile.getAbsolutePath().replace(".txt", "_txt") + ".xml");
        PurifyTextParser.parse(inputFile.getAbsolutePath(), reportFile.getAbsolutePath());
        HashMap map = new HashMap();
        try {
            mrp.convert(reportFile, new File("C:\\Users\\GENIATIS\\.jenkins\\jobs\\helloPurify\\workspace\\PurifyPlusProject\\Purify\\my_junk_tusar.xml"));
        }
        catch (Exception e) {
            throw new ConversionException(" parse exception :" + e.getMessage(), (Throwable)e);
        }
        System.out.println("projectBytesLost: " + mrp.getNumberOfBytesLost());
        System.out.println("projectErros: " + mrp.getNumberOfErrors());
        System.out.println("projectleaks: " + mrp.getNumberOfMemoryLeaks());
        for (String x : map.keySet()) {
            System.out.println(x + "= " + ((FilePurifyMetrics)map.get(x)).getFilename() + " * " + ((FilePurifyMetrics)map.get(x)).getNumberOfBytesLost() + " * " + ((FilePurifyMetrics)map.get(x)).getNumberOfErrors() + " * " + ((FilePurifyMetrics)map.get(x)).getNumberOfMemoryLeaks() + " * " + ((FilePurifyMetrics)map.get(x)).getSourcePath() + " ;\n");
        }
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public int getNumberOfMemoryLeaks() {
        return this.numberOfMemoryLeaks;
    }

    public int getNumberOfBytesLost() {
        return this.bytesLost;
    }

    public void parse(File reportFile, Map<String, FilePurifyMetrics> hashMap) throws XPathExpressionException, MalformedURLException, IOException {
        URL reportURL = reportFile.toURI().toURL();
        InputSource source = new InputSource(reportURL.openStream());
        XPathExpression rootExpression = this.xpath.compile("//purify");
        NodeList rootNode = (NodeList)rootExpression.evaluate(source, XPathConstants.NODESET);
        Element rootElement = (Element)rootNode.item(0);
        XPathExpression otherErrorsExpression = this.xpath.compile("//problem");
        NodeList otherErrorsNodes = (NodeList)otherErrorsExpression.evaluate(rootElement, XPathConstants.NODESET);
        this.numberOfErrors = otherErrorsNodes.getLength();
        for (int i = 0; i < this.numberOfErrors; ++i) {
            Element problemElement = (Element)otherErrorsNodes.item(i);
            this.createOtherErrorsMetrics(problemElement, hashMap);
        }
        XPathExpression memoryLeaksExpression = this.xpath.compile("//memory_leak");
        NodeList memoryLeaksNodes = (NodeList)memoryLeaksExpression.evaluate(rootElement, XPathConstants.NODESET);
        this.numberOfMemoryLeaks = memoryLeaksNodes.getLength();
        for (int i = 0; i < this.numberOfMemoryLeaks; ++i) {
            Element mlkElement = (Element)memoryLeaksNodes.item(i);
            String defaultFilename = mlkElement.getAttribute("executable");
            this.createMemoryLeakMetrics(mlkElement, hashMap, defaultFilename);
        }
        XPathExpression bytesLostExpression = this.xpath.compile("//memory_leaks");
        NodeList bytesLostNodes = (NodeList)bytesLostExpression.evaluate(rootElement, XPathConstants.NODESET);
        Element bytesLostFileNode = (Element)bytesLostNodes.item(0);
        this.bytesLost = Integer.parseInt(bytesLostFileNode.getAttribute("total_bytes"));
    }

    private void createOtherErrorsMetrics(Element fileNode, Map<String, FilePurifyMetrics> map) {
        try {
            XPathExpression stackTraceExpression = this.xpath.compile("stack_trace/function");
            NodeList stackTraceNodes = (NodeList)stackTraceExpression.evaluate(fileNode, XPathConstants.NODESET);
            Element stackTrace = (Element)stackTraceNodes.item(0);
            String filename = stackTrace.getAttribute("file");
            FilePurifyMetrics fileMetrics = map.get(filename);
            if (null == fileMetrics) {
                fileMetrics = new FilePurifyMetrics();
            }
            fileMetrics.addNumberOfErrors(1);
            fileMetrics.setFilename(filename);
            map.put(filename, fileMetrics);
        }
        catch (Exception e) {
            throw new ConversionException(" parse exception :" + e.getMessage(), (Throwable)e);
        }
    }

    private void createMemoryLeakMetrics(Element fileNode, Map<String, FilePurifyMetrics> map, String defaultFilename) {
        try {
            FilePurifyMetrics fileMetrics;
            XPathExpression stackTraceExpression = this.xpath.compile("stack_trace/function");
            NodeList stackTraceNodes = (NodeList)stackTraceExpression.evaluate(fileNode, XPathConstants.NODESET);
            String filename = defaultFilename;
            if (0 < stackTraceNodes.getLength()) {
                Element stackTrace = (Element)stackTraceNodes.item(0);
                filename = stackTrace.getAttribute("file");
            }
            if (null == (fileMetrics = map.get(filename))) {
                fileMetrics = new FilePurifyMetrics();
            }
            fileMetrics.addNumberOfMemoryLeaks(1);
            fileMetrics.addNumberOfBytesLost(Integer.parseInt(fileNode.getAttribute("bytes_lost")));
            fileMetrics.setFilename(filename);
            map.put(filename, fileMetrics);
        }
        catch (Exception e) {
            throw new ConversionException(" parse exception :" + e.getMessage(), (Throwable)e);
        }
    }

    public void convert(File InputFile, File outFile) throws ConversionException {
        PurifyReportParser parser = new PurifyReportParser();
        HashMap<String, FilePurifyMetrics> hashMap = new HashMap<String, FilePurifyMetrics>();
        try {
            parser.parse(InputFile, hashMap);
            Formatter output = new Formatter(outFile);
            output.format(this.str_filehead, new Object[0]);
            String projectContent = "<memory:resource type=\"PROJECT\" value=\"\" ><memory:measure key=\"memory_errors\" value=\"" + parser.getNumberOfErrors() + "\"/>" + "<memory:measure key=\"memory_leaks\" value=\"" + parser.getNumberOfMemoryLeaks() + "\"/>" + "<memory:measure key=\"bytes_lost\" value=\"" + parser.getNumberOfBytesLost() + "\"/>" + "</memory:resource> ";
            output.format(projectContent, new Object[0]);
            output.format(this.str_filetail, new Object[0]);
            if (output != null) {
                output.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new ConversionException("File Not Found Exception :" + e.getMessage(), (Throwable)e);
        }
        catch (Exception io) {
            throw new ConversionException(" parse exception :" + io.getMessage(), (Throwable)io);
        }
    }
}

