/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.dtkit.tusar;

import com.thalesgroup.dtkit.util.converter.ConversionException;
import com.thalesgroup.dtkit.util.validator.ValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GnatcheckParser {
    private List<String> lines;
    private List<String> section1;
    private List<String> section3;
    private List<String> rules;
    private Map<String, Map<String, List<String>>> map;
    private Map<String, String> mapRules;
    private String[] a_str_Markup = new String[]{"Applied rules:", "Disabled rules:", "Checked argument sources:", "-------- Start Section 1 ------------", "-------- End Section 1 ------------", "-------- Start Section 2 ------------", "-------- End Section 2 ------------", "-------- Start Section 3 ------------", "-------- End Section 3 ------------"};
    private String[] a_str_headpat = new String[]{"^Rule\\schecking\\sreport\\sgenerated\\s\\d{4}\\.\\d{2}\\.\\d{2}\\s\\d{2}\\:\\d{2}$", "^by\\sGNATCHECK\\s\\(built\\swith\\sASIS\\s\\d{1}\\.\\d{1}\\.R\\sfor\\sGNAT\\sPro\\s\\d{1}\\.\\d{1}\\.\\d{1}\\s\\(\\d{8}\\)\\)$"};
    private String str_filehead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tusar:tusar xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n             xmlns:violations=\"http://www.thalesgroup.com/tusar/violations/v4\"\n             xmlns:tusar=\"http://www.thalesgroup.com/tusar/v10\"\n             version=\"10.0\">\n    <tusar:violations>\n";
    private String str_filetail = "    </tusar:violations>\n</tusar:tusar>";
    private String str_violformat = "            <violations:violation  line=\"%s\"\n                       message=\"%s\"\n                       key=\"%s\"\n                       severity=\"info\"/>\n";

    public boolean validateInputFile(File InputFile) throws ValidationException {
        Scanner scanner;
        boolean isValid = false;
        boolean[] a_b_Step = new boolean[this.a_str_Markup.length];
        int lineNumber = 0;
        int i_step = 0;
        int i_step_max = this.a_str_Markup.length;
        for (int i = 0; i < this.a_str_Markup.length; ++i) {
            a_b_Step[i] = false;
        }
        try {
            scanner = new Scanner(InputFile);
        }
        catch (FileNotFoundException e) {
            throw new ValidationException("File Not Found Exception :" + e.getMessage(), (Throwable)e);
        }
        String line = new String();
        while (scanner.hasNextLine() && (isValid = this.matchHead(++lineNumber, line = scanner.nextLine())) && i_step != i_step_max) {
            if (!line.equals(this.a_str_Markup[i_step])) continue;
            a_b_Step[i_step++] = true;
        }
        scanner.close();
        for (int i = 0; i < i_step_max; ++i) {
            isValid &= a_b_Step[i];
        }
        return isValid;
    }

    public boolean validateOutputFile(File OutputFile) {
        return true;
    }

    public void convert(File InputFile, File outFile) throws ConversionException {
        try {
            String matchedfile = new String("");
            Formatter output = new Formatter(outFile);
            Pattern pat = Pattern.compile("([^\\:]*)[\\:](\\s*\\d*)[\\:](\\s*\\d*)[\\:](.*)");
            this.map = new HashMap<String, Map<String, List<String>>>();
            this.mapRules = new HashMap<String, String>();
            this.readLines(InputFile);
            this.section1 = this.readChunk(this.a_str_Markup[3], this.a_str_Markup[4]);
            this.section3 = this.readChunk(this.a_str_Markup[7], this.a_str_Markup[8]);
            this.rules = this.readChunk(this.a_str_Markup[0], this.a_str_Markup[1]);
            this.fillRuleMap();
            this.fillMap();
            Iterator<String> iterator = this.section1.iterator();
            output.format(this.str_filehead, new Object[0]);
            while (iterator.hasNext()) {
                String line = new String(iterator.next());
                Matcher m = pat.matcher(line);
                if (!m.find()) continue;
                if (!matchedfile.equals(m.group(1))) {
                    if (!matchedfile.equals("")) {
                        output.format("        </violations:file>\n", new Object[0]);
                    }
                    output.format("        <violations:file path=\"%s\">\n", m.group(1));
                    matchedfile = m.group(1);
                }
                String rule = this.findRule(m.group(1), m.group(2).trim() + ":" + m.group(3).trim());
                output.format(this.str_violformat, m.group(2).trim(), m.group(4).trim(), rule);
            }
            if (!matchedfile.equals("")) {
                output.format("        </violations:file>\n", new Object[0]);
            }
            output.format(this.str_filetail, new Object[0]);
            if (output != null) {
                output.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new ConversionException("File Not Found Exception :" + e.getMessage(), (Throwable)e);
        }
    }

    private void readLines(File InputFile) throws FileNotFoundException {
        Scanner scanner = new Scanner(InputFile);
        this.lines = new LinkedList<String>();
        while (scanner.hasNextLine()) {
            String line = new String(scanner.nextLine());
            this.lines.add(line);
        }
        scanner.close();
    }

    private List<String> readChunk(String strStart, String strEnd) {
        int start = this.lines.indexOf(strStart);
        int end = this.lines.indexOf(strEnd);
        return this.lines.subList(start, end);
    }

    private String findRule(String file, String ln) {
        String rule = new String("");
        if (this.map.containsKey(file)) {
            Map<String, List<String>> mapViols = this.map.get(file);
            for (Map.Entry<String, List<String>> entry : mapViols.entrySet()) {
                List<String> lnNums = entry.getValue();
                if (!lnNums.contains(ln)) continue;
                rule = entry.getKey();
                lnNums.remove(ln);
                if (lnNums.isEmpty()) {
                    mapViols.remove(rule);
                } else {
                    mapViols.put(rule, lnNums);
                }
                this.map.put(file, mapViols);
                break;
            }
        }
        return rule;
    }

    private void fillRuleMap() {
        String line2 = new String();
        Pattern pat = Pattern.compile("(\\([^\\)]*\\))\\s(.*)");
        for (String line2 : this.rules) {
            Matcher m = pat.matcher(line2);
            if (!m.find()) continue;
            this.mapRules.put(new String(m.group(2)), new String(m.group(1)));
        }
    }

    private void fillLnNumMap(ListIterator<String> iterator, List<String> lstLnNum) {
        Matcher m;
        String line = new String();
        Pattern pat = Pattern.compile("(\\s*\\d*)[\\:](\\d*)");
        while (iterator.hasNext() && (m = pat.matcher(line = iterator.next())).find()) {
            lstLnNum.add(m.group(1).trim() + ":" + m.group(2));
        }
    }

    private void fillViolMap(ListIterator<String> iterator, Map<String, List<String>> mapViol) {
        String line = new String();
        Pattern pat = Pattern.compile("(Matches\\sdetected\\sin\\sfile\\s)(.*)");
        while (iterator.hasNext()) {
            line = iterator.next();
            Matcher m = pat.matcher(line);
            if (m.find()) {
                iterator.previous();
                break;
            }
            if (!this.mapRules.containsKey(line.trim())) continue;
            LinkedList<String> lstLnNum = new LinkedList<String>();
            this.fillLnNumMap(iterator, lstLnNum);
            if (lstLnNum.isEmpty()) continue;
            mapViol.put(this.mapRules.get(line.trim()), lstLnNum);
        }
    }

    private void fillMap() {
        String line = new String();
        Pattern pat = Pattern.compile("(Matches\\sdetected\\sin\\sfile\\s)(.*)");
        ListIterator<String> iterator = this.section3.listIterator();
        while (iterator.hasNext()) {
            line = iterator.next();
            Matcher m = pat.matcher(line);
            if (!m.find()) continue;
            LinkedHashMap<String, List<String>> mapViol = new LinkedHashMap<String, List<String>>();
            this.fillViolMap(iterator, mapViol);
            if (mapViol.isEmpty()) continue;
            this.map.put(new String(m.group(2)), mapViol);
        }
    }

    private boolean matchHead(int lineNumber, String line) {
        boolean bMatch = false;
        bMatch = 1 == lineNumber && !line.matches(this.a_str_headpat[lineNumber - 1]) ? false : 2 != lineNumber || line.matches(this.a_str_headpat[lineNumber - 1]);
        return bMatch;
    }
}

