package com.thalesgroup.dtkit.metrics.hudson.model;

import org.kohsuke.stapler.DataBoundConstructor;
import hudson.Extension;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;

public class ValgrindJunitHudsonTestType extends TestType {

    private static TestTypeDescriptor<? extends TestType> DESCRIPTOR = new ValgrindJunitHudsonTestType.DescriptorImpl();

    @DataBoundConstructor
    public ValgrindJunitHudsonTestType(String pattern, boolean faildedIfNotNew, boolean deleteOutputFiles, boolean stopProcessingIfError) {
        super(pattern, faildedIfNotNew, deleteOutputFiles, stopProcessingIfError);
    }

    public TestTypeDescriptor<? extends TestType> getDescriptor() {
        return  DESCRIPTOR;
    }

    @Extension
    public static class DescriptorImpl  extends TestTypeDescriptor<ValgrindJunitHudsonTestType> {

        public DescriptorImpl() {
            super(ValgrindJunitHudsonTestType.class, com.thalesgroup.dtkit.junit.Valgrind.class);
        }

        public String getId() {
            return "class com.thalesgroup.dtkit.junit.Valgrind";
        }

    }

}
