package com.thalesgroup.dtkit.metrics.hudson.model;

import org.kohsuke.stapler.DataBoundConstructor;
import hudson.Extension;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;

public class UnitTestJunitHudsonTestType extends TestType {

    private static TestTypeDescriptor<? extends TestType> DESCRIPTOR = new UnitTestJunitHudsonTestType.DescriptorImpl();

    @DataBoundConstructor
    public UnitTestJunitHudsonTestType(String pattern, boolean faildedIfNotNew, boolean deleteOutputFiles, boolean stopProcessingIfError) {
        super(pattern, faildedIfNotNew, deleteOutputFiles, stopProcessingIfError);
    }

    public TestTypeDescriptor<? extends TestType> getDescriptor() {
        return  DESCRIPTOR;
    }

    @Extension
    public static class DescriptorImpl  extends TestTypeDescriptor<UnitTestJunitHudsonTestType> {

        public DescriptorImpl() {
            super(UnitTestJunitHudsonTestType.class, com.thalesgroup.dtkit.junit.UnitTest.class);
        }

        public String getId() {
            return "class com.thalesgroup.dtkit.junit.UnitTest";
        }

    }

}
