package com.thalesgroup.dtkit.metrics.hudson.model;

import org.kohsuke.stapler.DataBoundConstructor;
import hudson.Extension;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;

public class CppUnitJunitHudsonTestType extends TestType {

    private static TestTypeDescriptor<? extends TestType> DESCRIPTOR = new CppUnitJunitHudsonTestType.DescriptorImpl();

    @DataBoundConstructor
    public CppUnitJunitHudsonTestType(String pattern, boolean faildedIfNotNew, boolean deleteOutputFiles, boolean stopProcessingIfError) {
        super(pattern, faildedIfNotNew, deleteOutputFiles, stopProcessingIfError);
    }

    public TestTypeDescriptor<? extends TestType> getDescriptor() {
        return  DESCRIPTOR;
    }

    @Extension
    public static class DescriptorImpl  extends TestTypeDescriptor<CppUnitJunitHudsonTestType> {

        public DescriptorImpl() {
            super(CppUnitJunitHudsonTestType.class, com.thalesgroup.dtkit.junit.CppUnit.class);
        }

        public String getId() {
            return "class com.thalesgroup.dtkit.junit.CppUnit";
        }

    }

}
