package com.thalesgroup.dtkit.metrics.hudson.model;

import org.kohsuke.stapler.DataBoundConstructor;
import hudson.Extension;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;

public class CppTestJunitHudsonTestType extends TestType {

    private static TestTypeDescriptor<? extends TestType> DESCRIPTOR = new CppTestJunitHudsonTestType.DescriptorImpl();

    @DataBoundConstructor
    public CppTestJunitHudsonTestType(String pattern, boolean faildedIfNotNew, boolean deleteOutputFiles, boolean stopProcessingIfError) {
        super(pattern, faildedIfNotNew, deleteOutputFiles, stopProcessingIfError);
    }

    public TestTypeDescriptor<? extends TestType> getDescriptor() {
        return  DESCRIPTOR;
    }

    @Extension
    public static class DescriptorImpl  extends TestTypeDescriptor<CppTestJunitHudsonTestType> {

        public DescriptorImpl() {
            super(CppTestJunitHudsonTestType.class, com.thalesgroup.dtkit.junit.CppTestUnit.class);
        }

        public String getId() {
            return "class com.thalesgroup.dtkit.junit.CppTestUnit";
        }

    }

}
