/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.infra.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ClassicPluginStrategy;
import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.LocalPluginManager;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.init.InitMilestone;
import hudson.init.InitStrategy;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.CyclicGraphDetector;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ClassLoaderReflectionToolkit;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionFilter;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.jvnet.hudson.reactor.Executable;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TaskGraphBuilder;

public class HyperLocalPluginManager
extends LocalPluginManager {
    private static final Logger LOG = Logger.getLogger(HyperLocalPluginManager.class.getName());
    private final ModClassicPluginStrategy strategy;
    public final UberPlusClassLoader uberPlusClassLoader = new UberPlusClassLoader();
    private final boolean checkCycles;

    public HyperLocalPluginManager(boolean cycles) {
        this(".", cycles);
    }

    public HyperLocalPluginManager(String rootDir, boolean cycles) {
        super(new File(rootDir));
        this.strategy = this.createModPluginStrategy();
        this.checkCycles = cycles;
    }

    public ModClassicPluginStrategy getPluginStrategy() {
        return this.strategy;
    }

    protected ModClassicPluginStrategy createModPluginStrategy() {
        return new ModClassicPluginStrategy(this);
    }

    public TaskBuilder diagramPlugins(final InitStrategy initStrategy) {
        return new TaskGraphBuilder(){
            List<File> archives;
            {
                TaskGraphBuilder.Handle listUpPlugins = this.add("Listing up plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        archives = initStrategy.listPluginArchives((PluginManager)HyperLocalPluginManager.this);
                    }
                });
                this.requires(new Milestone[]{listUpPlugins}).attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Preparing plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        final HashMap inspectedShortNames = new HashMap();
                        for (final File arc : archives) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Inspecting plugin " + String.valueOf(arc), new Executable(){

                                public void run(Reactor session1) throws Exception {
                                    try {
                                        PluginWrapper p = HyperLocalPluginManager.this.strategy.createPluginWrapper(arc);
                                        if (this.isDuplicate(p)) {
                                            return;
                                        }
                                        HyperLocalPluginManager.this.plugins.add(p);
                                        if (p.isActive()) {
                                            HyperLocalPluginManager.this.activePlugins.add(p);
                                        }
                                    }
                                    catch (IOException e) {
                                        HyperLocalPluginManager.this.failedPlugins.add(new PluginManager.FailedPlugin(arc.getName(), (Exception)e));
                                        throw e;
                                    }
                                }

                                private boolean isDuplicate(PluginWrapper p) {
                                    String shortName = p.getShortName();
                                    if (inspectedShortNames.containsKey(shortName)) {
                                        LOG.info("Ignoring " + String.valueOf(arc) + " because " + String.valueOf(inspectedShortNames.get(shortName)) + " is already loaded");
                                        return true;
                                    }
                                    inspectedShortNames.put(shortName, arc);
                                    return false;
                                }
                            });
                        }
                        if (HyperLocalPluginManager.this.checkCycles) {
                            g.followedBy().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Checking cyclic dependencies", new Executable(){

                                public void run(Reactor reactor) throws Exception {
                                    try {
                                        CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                                            protected List<PluginWrapper> getEdges(PluginWrapper p) {
                                                ArrayList<PluginWrapper> next = new ArrayList<PluginWrapper>();
                                                this.addTo(p.getDependencies(), next);
                                                this.addTo(p.getOptionalDependencies(), next);
                                                return next;
                                            }

                                            private void addTo(List<PluginWrapper.Dependency> dependencies, List<PluginWrapper> r) {
                                                for (PluginWrapper.Dependency d : dependencies) {
                                                    PluginWrapper p = HyperLocalPluginManager.this.getPlugin(d.shortName);
                                                    if (p == null) continue;
                                                    r.add(p);
                                                }
                                            }

                                            protected void reactOnCycle(PluginWrapper q, List<PluginWrapper> cycle) {
                                                CharSequence[] csCycle = cycle.toArray(new CharSequence[cycle.size()]);
                                                LOG.severe("FATAL: found cycle in plugin dependencies: (root=" + String.valueOf(q) + ", deactivating all involved) " + String.join((CharSequence)" -> ", csCycle));
                                                for (PluginWrapper pluginWrapper : cycle) {
                                                    pluginWrapper.setHasCycleDependency(true);
                                                    HyperLocalPluginManager.this.failedPlugins.add(new PluginManager.FailedPlugin(pluginWrapper.getShortName(), (Exception)new CyclicGraphDetector.CycleDetectedException(cycle)));
                                                }
                                            }
                                        };
                                        cgd.run((Iterable)HyperLocalPluginManager.this.getPlugins());
                                        ListIterator<PluginWrapper> litr = HyperLocalPluginManager.this.getPlugins().listIterator();
                                        for (PluginWrapper p : cgd.getSorted()) {
                                            litr.next();
                                            litr.set(p);
                                            if (!p.isActive()) continue;
                                            HyperLocalPluginManager.this.activePlugins.add(p);
                                        }
                                    }
                                    catch (CyclicGraphDetector.CycleDetectedException e) {
                                        HyperLocalPluginManager.this.stop();
                                        throw e;
                                    }
                                }
                            });
                        }
                        session.addAll(g.discoverTasks(session));
                    }
                });
            }
        };
    }

    @NonNull
    protected Set<String> loadPluginsFromWar(@NonNull String p) {
        return Collections.emptySet();
    }

    @NonNull
    protected Set<String> loadPluginsFromWar(@NonNull String fromPath, @CheckForNull FilenameFilter filter) {
        return Collections.emptySet();
    }

    public String getPluginNameForDescriptor(Descriptor<?> d) {
        String className = d.getClass().getName();
        try {
            this.uberPlusClassLoader.findClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINER, "Class not found for " + d.getId());
        }
        String pluginName = this.uberPlusClassLoader.getByPlugin().get(className);
        if (pluginName == null) {
            LOG.info("No plugin found, assuming core: " + className);
            return "core";
        }
        return pluginName.trim();
    }

    public final class UberPlusClassLoader
    extends ClassLoader {
        private final ConcurrentMap<String, WeakReference<Class<?>>> generatedClasses;
        private final Map<String, Class<?>> loaded;
        private final Map<String, String> byPlugin;

        public UberPlusClassLoader() {
            super(PluginManager.class.getClassLoader());
            this.generatedClasses = new ConcurrentHashMap();
            this.loaded = new HashMap();
            this.byPlugin = new HashMap<String, String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            WeakReference wc = (WeakReference)this.generatedClasses.get(name);
            if (wc != null) {
                Class c = (Class)wc.get();
                if (c != null) {
                    return c;
                }
                this.generatedClasses.remove(name, wc);
            }
            if (name.startsWith("SimpleTemplateScript")) {
                throw new ClassNotFoundException("ignoring " + name);
            }
            Object object = this.loaded;
            synchronized (object) {
                if (this.loaded.containsKey(name)) {
                    Class<?> c = this.loaded.get(name);
                    if (c != null) {
                        return c;
                    }
                    throw new ClassNotFoundException("cached miss for " + name);
                }
            }
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper p : HyperLocalPluginManager.this.activePlugins) {
                    try {
                        Class c = ClassLoaderReflectionToolkit.loadClass((ClassLoader)p.classLoader, (String)name);
                        c = ClassLoaderReflectionToolkit.loadClass((ClassLoader)p.classLoader, (String)name);
                        Map<String, Object> map = this.loaded;
                        synchronized (map) {
                            this.loaded.put(name, c);
                        }
                        map = this.byPlugin;
                        synchronized (map) {
                            this.byPlugin.put(c.getName(), p.getShortName());
                        }
                        return c;
                    }
                    catch (ClassNotFoundException c) {
                    }
                }
            } else {
                for (PluginWrapper p : HyperLocalPluginManager.this.activePlugins) {
                    try {
                        Class<?> c = p.classLoader.loadClass(name);
                        Map<String, String> map = this.byPlugin;
                        synchronized (map) {
                            this.byPlugin.put(c.getName(), p.getShortName());
                        }
                        return c;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            object = this.loaded;
            synchronized (object) {
                this.loaded.put(name, null);
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper p : HyperLocalPluginManager.this.activePlugins) {
                    URL url = ClassLoaderReflectionToolkit._findResource((ClassLoader)p.classLoader, (String)name);
                    if (url == null) continue;
                    return url;
                }
            } else {
                for (PluginWrapper p : HyperLocalPluginManager.this.activePlugins) {
                    URL url = p.classLoader.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            ArrayList<Object> resources = new ArrayList<Object>();
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper p : HyperLocalPluginManager.this.activePlugins) {
                    resources.addAll(Collections.list(ClassLoaderReflectionToolkit._findResources((ClassLoader)p.classLoader, (String)name)));
                }
            } else {
                for (PluginWrapper p : HyperLocalPluginManager.this.activePlugins) {
                    resources.addAll(Collections.list(p.classLoader.getResources(name)));
                }
            }
            return Collections.enumeration(resources);
        }

        public Map<String, String> getByPlugin() {
            return this.byPlugin;
        }

        public String toString() {
            return "classLoader " + this.getClass().getName();
        }
    }

    public static class ModClassicPluginStrategy
    extends ClassicPluginStrategy {
        private final ClassLoader classLoader;

        public ModClassicPluginStrategy(HyperLocalPluginManager pluginManager) {
            super((PluginManager)pluginManager);
            this.classLoader = pluginManager.uberPlusClassLoader;
        }

        public <T> List<ExtensionComponent<T>> findComponents(Class<T> type, Hudson hudson) {
            List<SmallSezpoz> finders = Collections.singletonList(new SmallSezpoz());
            for (SmallSezpoz smallSezpoz : finders) {
                smallSezpoz.scout(this.classLoader);
            }
            ArrayList r = Lists.newArrayList();
            for (SmallSezpoz finder : finders) {
                try {
                    r.addAll(finder.find(type, this.classLoader));
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
            ArrayList arrayList = Lists.newArrayList();
            for (ExtensionComponent e : r) {
                if (!ExtensionFilter.isAllowed(type, (ExtensionComponent)e)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public <T> List<T> findComponents(Class<T> type) {
            List<SmallSezpoz> finders = Collections.singletonList(new SmallSezpoz());
            for (SmallSezpoz smallSezpoz : finders) {
                smallSezpoz.scout(this.classLoader);
            }
            ArrayList r = Lists.newArrayList();
            for (SmallSezpoz finder : finders) {
                try {
                    r.addAll(finder.find(type, this.classLoader));
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
            ArrayList arrayList = Lists.newArrayList();
            for (ExtensionComponent e : r) {
                if (!ExtensionFilter.isAllowed(type, (ExtensionComponent)e)) continue;
                arrayList.add(e.getInstance());
            }
            return arrayList;
        }
    }

    public static final class SmallSezpoz
    extends ExtensionFinder {
        private volatile List<IndexItem<Extension, Object>> indices;

        private List<IndexItem<Extension, Object>> getIndices(ClassLoader cl) {
            if (this.indices == null) {
                this.indices = ImmutableList.copyOf((Iterable)Index.load(Extension.class, Object.class, (ClassLoader)cl));
            }
            return this.indices;
        }

        public synchronized ExtensionComponentSet refresh() {
            return ExtensionComponentSet.EMPTY;
        }

        public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson hud) {
            return this._find(type, this.getIndices(null));
        }

        public <T> Collection<ExtensionComponent<T>> find(Class<T> type, ClassLoader cl) {
            return this._find(type, this.getIndices(cl));
        }

        private <T> Collection<ExtensionComponent<T>> _find(Class<T> type, List<IndexItem<Extension, Object>> indices) {
            ArrayList<ExtensionComponent<T>> result = new ArrayList<ExtensionComponent<T>>();
            for (IndexItem<Extension, Object> item : indices) {
                try {
                    Object instance;
                    Class<?> extType;
                    AnnotatedElement e = item.element();
                    if (e instanceof Class) {
                        extType = (Class<?>)e;
                    } else if (e instanceof Field) {
                        extType = ((Field)e).getType();
                    } else if (e instanceof Method) {
                        extType = ((Method)e).getReturnType();
                    } else {
                        throw new AssertionError();
                    }
                    if (!type.isAssignableFrom(extType) || (instance = this.safeInstance(item)) == null) continue;
                    result.add(new ExtensionComponent(type.cast(instance), (Extension)item.annotation()));
                }
                catch (Exception | LinkageError e) {
                    LOG.fine("Failed to load " + item.className() + "\n" + String.valueOf(e));
                }
            }
            return result;
        }

        private Object safeInstance(IndexItem<Extension, Object> item) {
            try {
                return item.instance();
            }
            catch (Error | Exception e) {
                LOG.log(Level.WARNING, "Cannot instantiate " + item.className(), e.getCause() != null ? e.getCause() : e);
                return null;
            }
        }

        public void scout(ClassLoader cl) {
            for (IndexItem<Extension, Object> item : this.getIndices(cl)) {
                try {
                    Class<?> extType;
                    AnnotatedElement e = item.element();
                    if (e instanceof Class) {
                        extType = (Class<?>)e;
                    } else if (e instanceof Field) {
                        extType = ((Field)e).getType();
                    } else if (e instanceof Method) {
                        extType = ((Method)e).getReturnType();
                    } else {
                        throw new AssertionError();
                    }
                    Class.forName(extType.getName(), true, extType.getClassLoader());
                }
                catch (Exception | LinkageError e) {
                    LOG.fine("Failed to scout " + item.className() + "\n" + String.valueOf(e));
                }
            }
        }
    }
}

