/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.ExtensionList;
import hudson.Lookup;
import hudson.MockExtensionLists;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.init.InitMilestone;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.io.File;
import java.lang.reflect.Field;
import javax.servlet.ServletContext;
import jenkins.install.InstallState;
import jenkins.model.Jenkins;
import org.jenkinsci.infra.tools.HyperLocalPluginManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockJenkins {
    private MockExtensionLists mockLookup = new MockExtensionLists();

    public Jenkins getMockJenkins(final HyperLocalPluginManager pm) {
        final Jenkins mockJenkins = (Jenkins)Mockito.mock(Hudson.class);
        Mockito.when((Object)mockJenkins.getPluginManager()).thenReturn((Object)pm);
        Mockito.when((Object)mockJenkins.getInitLevel()).thenReturn((Object)InitMilestone.COMPLETED);
        Mockito.when((Object)mockJenkins.getInstallState()).thenReturn((Object)InstallState.TEST);
        Mockito.when((Object)mockJenkins.getComputers()).thenReturn((Object)new Computer[0]);
        Mockito.when((Object)mockJenkins.getRootDir()).thenReturn((Object)new File(System.getProperty("java.io.tmpdir")));
        try {
            Field lookup = mockJenkins.getClass().getField("lookup");
            lookup.setAccessible(true);
            lookup.set(mockJenkins, new Lookup());
            Field servletContext = mockJenkins.getClass().getField("servletContext");
            servletContext.setAccessible(true);
            servletContext.set(mockJenkins, Mockito.mock(ServletContext.class));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        ((Jenkins)Mockito.doAnswer((Answer)new Answer<ExtensionList>(){

            public ExtensionList answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return MockJenkins.this.mockLookup.getMockExtensionList(pm, mockJenkins, (Class)args[0]);
            }
        }).when((Object)mockJenkins)).getExtensionList((Class)ArgumentMatchers.any(Class.class));
        ((Jenkins)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            for (Object _d : this.mockLookup.getMockExtensionList(pm, mockJenkins, Descriptor.class)) {
                Descriptor d = (Descriptor)_d;
                if (d.clazz != args[0]) continue;
                return d;
            }
            return null;
        }).when((Object)mockJenkins)).getDescriptor((Class)ArgumentMatchers.any(Class.class));
        ((Jenkins)Mockito.doAnswer((Answer)new Answer<Plugin>(){

            public Plugin answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                PluginWrapper p = pm.getPlugin((Class)args[0]);
                if (p == null) {
                    return null;
                }
                return p.getPlugin();
            }
        }).when((Object)mockJenkins)).getPlugin((Class)ArgumentMatchers.any(Class.class));
        return mockJenkins;
    }
}

