/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinci.plugins.mock_slave;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jenkinci.plugins.mock_slave.Throttler;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockSlaveLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(MockSlaveLauncher.class.getName());
    public final int latency;
    public final int bandwidth;

    @DataBoundConstructor
    public MockSlaveLauncher(int latency, int bandwidth) {
        this.latency = latency;
        this.bandwidth = bandwidth;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Launching");
        File portFile = File.createTempFile("jenkins-port", "");
        ProcessBuilder pb = new ProcessBuilder("java", "-jar", Which.jarFile(Which.class).getAbsolutePath(), "-tcp", portFile.getAbsolutePath());
        EnvVars cookie = EnvVars.createCookie();
        pb.environment().putAll((Map<String, String>)cookie);
        Process proc = pb.start();
        new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), proc.getErrorStream(), (OutputStream)listener.getLogger()).start();
        while (portFile.length() == 0L) {
            Thread.sleep(100L);
        }
        int port = Integer.parseInt(FileUtils.readFileToString((File)portFile));
        listener.getLogger().println("connecting to localhost:" + port);
        Socket s = new Socket(InetAddress.getLoopbackAddress(), port);
        InputStream is = s.getInputStream();
        OutputStream os = s.getOutputStream();
        if (this.latency > 0 || this.bandwidth > 0) {
            listener.getLogger().printf("throttling with latency=%dms bandwidth=%dbps%n", this.latency, this.bandwidth);
            Throttler t = new Throttler(this.latency, this.bandwidth, is, os);
            is = t.is();
            os = t.os();
        }
        computer.setChannel(is, os, (OutputStream)listener.getLogger(), (Channel.Listener)new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.log(Level.INFO, "slave agent launched for {0}", computer.getDisplayName());
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

