/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.net.BindException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.NoListenerConfiguration;
import org.jvnet.hudson.test.ThreadPoolImpl;
import org.jvnet.hudson.test.WarExploder;

public class JenkinsRuleNonLocalhost
extends JenkinsRule {
    private static final Logger LOGGER = Logger.getLogger(JenkinsRuleNonLocalhost.class.getName());
    private static final String HOST = System.getProperty("connectorHost");
    private Integer port;

    public JenkinsRuleNonLocalhost(Integer port) {
        this.port = port;
    }

    public JenkinsRuleNonLocalhost() {
    }

    protected ServletContext createWebServer() throws Exception {
        this.server = new Server((ThreadPool)new ThreadPoolImpl((ExecutorService)new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Jetty Thread Pool");
                return t;
            }
        })));
        WebAppContext context = new WebAppContext(WarExploder.getExplodedDir().getPath(), this.contextPath);
        context.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        context.addBean((Object)new NoListenerConfiguration(context));
        this.server.setHandler((Handler)context);
        context.setMimeTypes(MIME_TYPES);
        context.getSecurityHandler().setLoginService(this.configureUserRealm());
        context.setResourceBase(WarExploder.getExplodedDir().getPath());
        ServerConnector connector = new ServerConnector(this.server);
        HttpConfiguration config = ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        config.setRequestHeaderSize(12288);
        System.err.println("Listening on host address: " + HOST);
        connector.setHost(HOST);
        if (System.getProperty("port") != null) {
            LOGGER.info("Overriding port using system property: " + System.getProperty("port"));
            connector.setPort(Integer.parseInt(System.getProperty("port")));
        } else if (this.port != null) {
            connector.setPort(this.port.intValue());
        }
        this.server.addConnector((Connector)connector);
        try {
            this.server.start();
        }
        catch (BindException e) {
            throw new BindException(String.format("Error binding to %s:%d %s", connector.getHost(), connector.getPort(), e.getMessage()));
        }
        this.localPort = connector.getLocalPort();
        LOGGER.log(Level.INFO, "Running on {0}", this.getURL());
        return context.getServletContext();
    }
}

