/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pod.retention;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodStatusBuilder;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Always;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Default;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Never;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.OnFailure;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PodRetentionTest {
    private KubernetesCloud cloud;
    private Pod pod;

    @Before
    public void setUp() {
        this.cloud = new KubernetesCloud("kubernetes");
        this.pod = new Pod();
    }

    @Test
    public void testAlwaysPodRetention() {
        Always subject = new Always();
        Assert.assertFalse((boolean)subject.shouldDeletePod(this.cloud, this.pod));
    }

    @Test
    public void testNeverPodRetention() {
        Never subject = new Never();
        Assert.assertTrue((boolean)subject.shouldDeletePod(this.cloud, this.pod));
    }

    @Test
    public void testDefaultPodRetention() {
        Default subject = new Default();
        this.cloud.setPodRetention((PodRetention)new Always());
        Assert.assertFalse((boolean)subject.shouldDeletePod(this.cloud, this.pod));
        this.cloud.setPodRetention((PodRetention)new Never());
        Assert.assertTrue((boolean)subject.shouldDeletePod(this.cloud, this.pod));
        this.cloud.setPodRetention((PodRetention)new Default());
        Assert.assertTrue((boolean)subject.shouldDeletePod(this.cloud, this.pod));
        this.cloud.setPodRetention(null);
        Assert.assertTrue((boolean)subject.shouldDeletePod(this.cloud, this.pod));
    }

    @Test
    public void testOnFailurePodRetention() {
        OnFailure subject = new OnFailure();
        this.pod.setStatus(this.buildStatus("Failed"));
        Assert.assertFalse((boolean)subject.shouldDeletePod(this.cloud, this.pod));
        this.pod.setStatus(this.buildStatus("Unknown"));
        Assert.assertFalse((boolean)subject.shouldDeletePod(this.cloud, this.pod));
        this.pod.setStatus(this.buildStatus("Running"));
        Assert.assertTrue((boolean)subject.shouldDeletePod(this.cloud, this.pod));
        this.pod.setStatus(this.buildStatus("Pending"));
        Assert.assertTrue((boolean)subject.shouldDeletePod(this.cloud, this.pod));
    }

    private PodStatus buildStatus(String phase) {
        return ((PodStatusBuilder)new PodStatusBuilder().withPhase(phase)).build();
    }
}

