/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.utils.IOUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.model.KeyValueEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.model.SecretEnvVar;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.RestartableJenkinsNonLocalhostRule;

public class RestartPipelineTest {
    protected static final String CONTAINER_ENV_VAR_VALUE = "container-env-var-value";
    protected static final String POD_ENV_VAR_VALUE = "pod-env-var-value";
    protected static final String SECRET_KEY = "password";
    protected static final String CONTAINER_ENV_VAR_FROM_SECRET_VALUE = "container-pa55w0rd";
    protected static final String POD_ENV_VAR_FROM_SECRET_VALUE = "pod-pa55w0rd";
    protected KubernetesCloud cloud;
    @Rule
    public RestartableJenkinsNonLocalhostRule story = new RestartableJenkinsNonLocalhostRule(44000);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public LoggerRule logs = new LoggerRule().record(Logger.getLogger(KubernetesCloud.class.getPackage().getName()), Level.ALL);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void isKubernetesConfigured() throws Exception {
        KubernetesTestUtil.assumeKubernetes();
    }

    private static void setEnvVariables(PodTemplate podTemplate) {
        SecretEnvVar podSecretEnvVar = new SecretEnvVar("POD_ENV_VAR_FROM_SECRET", "pod-secret", SECRET_KEY);
        KeyValueEnvVar podSimpleEnvVar = new KeyValueEnvVar("POD_ENV_VAR", POD_ENV_VAR_VALUE);
        podTemplate.setEnvVars(Arrays.asList(podSecretEnvVar, podSimpleEnvVar));
        KeyValueEnvVar containerEnvVariable = new KeyValueEnvVar("CONTAINER_ENV_VAR", CONTAINER_ENV_VAR_VALUE);
        ContainerEnvVar containerEnvVariableLegacy = new ContainerEnvVar("CONTAINER_ENV_VAR_LEGACY", CONTAINER_ENV_VAR_VALUE);
        SecretEnvVar containerSecretEnvVariable = new SecretEnvVar("CONTAINER_ENV_VAR_FROM_SECRET", "container-secret", SECRET_KEY);
        ((ContainerTemplate)podTemplate.getContainers().get(0)).setEnvVars(Arrays.asList(containerEnvVariable, containerEnvVariableLegacy, containerSecretEnvVariable));
    }

    private PodTemplate buildBusyboxTemplate(String label) {
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setLabel(label);
        ContainerTemplate containerTemplate = new ContainerTemplate("busybox", "busybox", "cat", "");
        containerTemplate.setTtyEnabled(true);
        podTemplate.getContainers().add(containerTemplate);
        RestartPipelineTest.setEnvVariables(podTemplate);
        return podTemplate;
    }

    public void configureCloud() throws Exception {
        this.cloud = KubernetesTestUtil.setupCloud(this, this.name);
        KubernetesTestUtil.createSecret(this.cloud.connect(), this.cloud.getNamespace());
        this.cloud.getTemplates().clear();
        this.cloud.addTemplate(this.buildBusyboxTemplate("busybox"));
        KubernetesTestUtil.setupHost();
        this.story.j.jenkins.clouds.add((Object)this.cloud);
    }

    public void configureAgentListener() throws IOException {
        int fixedPort = this.story.j.jenkins.getTcpSlaveAgentListener().getAdvertisedPort();
        this.story.j.jenkins.setSlaveAgentPort(fixedPort);
    }

    protected String loadPipelineScript(String name) {
        try {
            return new String(IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream(name)));
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not read resource:[" + name + "].");
        }
    }

    @Test
    public void runInPodWithRestartWithMultipleContainerCalls() throws Exception {
        AtomicReference projectName = new AtomicReference();
        this.story.then(r -> {
            this.configureAgentListener();
            this.configureCloud();
            r.jenkins.addNode((Node)new DumbSlave("slave", "dummy", this.tmp.newFolder("remoteFS").getPath(), "1", Node.Mode.NORMAL, "", (ComputerLauncher)new JNLPLauncher(), RetentionStrategy.NOOP, Collections.emptyList()));
            WorkflowRun b = this.getPipelineJobThenScheduleRun(r);
            projectName.set(((WorkflowJob)b.getParent()).getFullName());
            r.waitForMessage("+ sleep 5", (Run)b);
        });
        this.story.then(r -> {
            WorkflowRun b = ((WorkflowJob)r.jenkins.getItemByFullName((String)projectName.get(), WorkflowJob.class)).getBuildByNumber(1);
            r.assertLogContains("finished the test!", r.assertBuildStatusSuccess(r.waitForCompletion((Run)b)));
        });
    }

    @Test
    public void runInPodWithRestartWithLongSleep() throws Exception {
        AtomicReference projectName = new AtomicReference();
        this.story.then(r -> {
            this.configureAgentListener();
            this.configureCloud();
            r.jenkins.addNode((Node)new DumbSlave("slave", "dummy", this.tmp.newFolder("remoteFS").getPath(), "1", Node.Mode.NORMAL, "", (ComputerLauncher)new JNLPLauncher(), RetentionStrategy.NOOP, Collections.emptyList()));
            WorkflowRun b = this.getPipelineJobThenScheduleRun(r);
            projectName.set(((WorkflowJob)b.getParent()).getFullName());
            r.waitForMessage("+ sleep 5", (Run)b);
        });
        this.story.then(r -> {
            WorkflowRun b = ((WorkflowJob)r.jenkins.getItemByFullName((String)projectName.get(), WorkflowJob.class)).getBuildByNumber(1);
            r.assertLogContains("finished the test!", r.assertBuildStatusSuccess(r.waitForCompletion((Run)b)));
        });
    }

    @Test
    public void windowsRestart() throws Exception {
        KubernetesTestUtil.assumeWindows();
        AtomicReference projectName = new AtomicReference();
        this.story.then(r -> {
            this.configureAgentListener();
            this.configureCloud();
            this.cloud.setDirectConnection(false);
            WorkflowRun b = this.getPipelineJobThenScheduleRun(r);
            projectName.set(((WorkflowJob)b.getParent()).getFullName());
            r.waitForMessage("sleeping #0", (Run)b);
        });
        this.story.then(r -> {
            WorkflowRun b = ((WorkflowJob)r.jenkins.getItemByFullName((String)projectName.get(), WorkflowJob.class)).getBuildByNumber(1);
            r.assertLogContains("sleeping #9", r.assertBuildStatusSuccess(r.waitForCompletion((Run)b)));
            r.assertLogContains("finished the test!", r.assertBuildStatusSuccess(r.waitForCompletion((Run)b)));
        });
    }

    @Test
    public void terminatedPodAfterRestart() throws Exception {
        AtomicReference projectName = new AtomicReference();
        this.story.then(r -> {
            this.configureAgentListener();
            this.configureCloud();
            WorkflowRun b = this.getPipelineJobThenScheduleRun(r);
            projectName.set(((WorkflowJob)b.getParent()).getFullName());
            r.waitForMessage("+ sleep", (Run)b);
        });
        this.story.then(r -> {
            WorkflowRun b = ((WorkflowJob)r.jenkins.getItemByFullName((String)projectName.get(), WorkflowJob.class)).getBuildByNumber(1);
            r.waitForMessage("Ready to run", (Run)b);
            KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this, this.name), false);
            r.assertBuildStatus(Result.ABORTED, r.waitForCompletion((Run)b));
            r.waitForMessage(new ExecutorStepExecution.RemovedNodeCause().getShortDescription(), (Run)b);
        });
    }

    @Test
    public void getContainerLogWithRestart() throws Exception {
        AtomicReference projectName = new AtomicReference();
        this.story.then(r -> {
            this.configureAgentListener();
            this.configureCloud();
            r.jenkins.addNode((Node)new DumbSlave("slave", "dummy", this.tmp.newFolder("remoteFS").getPath(), "1", Node.Mode.NORMAL, "", (ComputerLauncher)new JNLPLauncher(), RetentionStrategy.NOOP, Collections.emptyList()));
            WorkflowRun b = this.getPipelineJobThenScheduleRun(r);
            projectName.set(((WorkflowJob)b.getParent()).getFullName());
            r.waitForMessage("+ sleep 5", (Run)b);
        });
        this.story.then(r -> {
            WorkflowRun b = ((WorkflowJob)r.jenkins.getItemByFullName((String)projectName.get(), WorkflowJob.class)).getBuildByNumber(1);
            r.assertBuildStatusSuccess(r.waitForCompletion((Run)b));
            r.assertLogContains("[Pipeline] containerLog", (Run)b);
            r.assertLogContains("[Pipeline] End of Pipeline", (Run)b);
        });
    }

    private WorkflowRun getPipelineJobThenScheduleRun(JenkinsRule r) throws InterruptedException, ExecutionException, IOException {
        return KubernetesTestUtil.createPipelineJobThenScheduleRun(r, this.getClass(), this.name.getMethodName());
    }
}

