/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRuleNonLocalhost;

public class PodTemplateStepExecutionTest {
    @Rule
    public JenkinsRuleNonLocalhost r = new JenkinsRuleNonLocalhost();
    protected KubernetesCloud cloud;

    @Before
    public void configureCloud() throws Exception {
        this.cloud = new KubernetesCloud("kubernetes");
        this.r.jenkins.clouds.add((Object)this.cloud);
    }

    private String loadPipelineScript(String name) {
        return KubernetesTestUtil.loadPipelineScript(this.getClass(), name);
    }

    @Test
    public void testBadNameDetection() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "bad_container_name");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(this.loadPipelineScript("badcontainername.groovy"), true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        Assert.assertNotNull((Object)b);
        this.r.assertBuildStatus(Result.FAILURE, this.r.waitForCompletion((Run)b));
        this.r.waitForMessage(Messages.RFC1123_error((Object)"badcontainerName_!"), (Run)b);
    }

    @Test
    public void testBadNameYamlDetection() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "bad_container_name_yaml");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(this.loadPipelineScript("badcontainernameyaml.groovy"), true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        Assert.assertNotNull((Object)b);
        this.r.assertBuildStatus(Result.FAILURE, this.r.waitForCompletion((Run)b));
        this.r.waitForMessage(Messages.RFC1123_error((Object)"badcontainername_!, badcontainername2_!"), (Run)b);
    }

    @Test
    public void testBadLabel() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "bad_label");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(this.loadPipelineScript("badlabel.groovy"), true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
        Assert.assertNotNull((Object)b);
        this.r.assertBuildStatus(Result.FAILURE, this.r.waitForCompletion((Run)b));
        this.r.waitForMessage(Messages.label_error((Object)"mypod!123"), (Run)b);
    }
}

