/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.ExtensionList;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.AbstractKubernetesPipelineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.jvnet.hudson.test.TestExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NoDelayProvisionerStrategyTest
extends AbstractKubernetesPipelineTest {
    @Mock
    CloudProvisioningListener cloudProvisioningListener;

    @Before
    public void setUp() throws Exception {
        CloudProvisionerListenerImpl instance = (CloudProvisionerListenerImpl)((Object)ExtensionList.lookupSingleton(CloudProvisionerListenerImpl.class));
        instance.setDelegate(this.cloudProvisioningListener);
        KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this.cloud, this, this.name), false);
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
    }

    @Test
    public void noDelayProvisionerCallsListener() throws Exception {
        Mockito.when((Object)this.cloudProvisioningListener.canProvision((Cloud)ArgumentMatchers.any(Cloud.class), (Label)ArgumentMatchers.any(Label.class), ArgumentMatchers.anyInt())).thenReturn(null);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        ((CloudProvisioningListener)Mockito.verify((Object)this.cloudProvisioningListener, (VerificationMode)Mockito.atLeastOnce())).onStarted((Cloud)ArgumentMatchers.eq((Object)this.cloud), (Label)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ((CloudProvisioningListener)Mockito.verify((Object)this.cloudProvisioningListener, (VerificationMode)Mockito.atLeastOnce())).canProvision((Cloud)ArgumentMatchers.any(Cloud.class), (Label)ArgumentMatchers.any(Label.class), ArgumentMatchers.anyInt());
    }

    @TestExtension
    public static class CloudProvisionerListenerImpl
    extends CloudProvisioningListener {
        private CloudProvisioningListener delegate;

        public void setDelegate(CloudProvisioningListener delegate) {
            this.delegate = delegate;
        }

        public void onStarted(Cloud cloud, Label label, Collection<NodeProvisioner.PlannedNode> plannedNodes) {
            this.delegate.onStarted(cloud, label, plannedNodes);
        }

        public void onComplete(NodeProvisioner.PlannedNode plannedNode, Node node) {
            this.delegate.onComplete(plannedNode, node);
        }

        public void onCommit(@Nonnull NodeProvisioner.PlannedNode plannedNode, @Nonnull Node node) {
            this.delegate.onCommit(plannedNode, node);
        }

        public void onFailure(NodeProvisioner.PlannedNode plannedNode, Throwable t) {
            this.delegate.onFailure(plannedNode, t);
        }

        public void onRollback(@Nonnull NodeProvisioner.PlannedNode plannedNode, @Nonnull Node node, @Nonnull Throwable t) {
            this.delegate.onRollback(plannedNode, node, t);
        }

        public CauseOfBlockage canProvision(Cloud cloud, Label label, int numExecutors) {
            return this.delegate.canProvision(cloud, label, numExecutors);
        }
    }
}

