/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.slaves.SlaveComputer;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.AbstractKubernetesPipelineTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.JenkinsRuleNonLocalhost;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;

public class KubernetesPipelineTest
extends AbstractKubernetesPipelineTest {
    private static final Logger LOGGER = Logger.getLogger(KubernetesPipelineTest.class.getName());
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @Rule
    public LoggerRule warnings = new LoggerRule();

    @Before
    public void setUp() throws Exception {
        ((GlobalDefaultFlowDurabilityLevel.DescriptorImpl)this.r.jenkins.getDescriptorByType(GlobalDefaultFlowDurabilityLevel.DescriptorImpl.class)).setDurabilityHint(FlowDurabilityHint.PERFORMANCE_OPTIMIZED);
        KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this.cloud, this, this.name), false);
        this.warnings.record("", Level.WARNING).capture(1000);
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
    }

    @After
    public void allDead() throws Exception {
        if (this.b != null && this.b.isLogUpdated()) {
            LOGGER.warning(() -> "Had to interrupt " + this.b);
            this.b.getExecutor().interrupt();
        }
        for (int i = 0; i < 100 && this.r.isSomethingHappening(); ++i) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void runInPod() throws Exception {
        SemaphoreStep.waitForStart((String)"podTemplate/1", (Run)this.b);
        List<PodTemplate> templates = this.podTemplatesWithLabel(this.name.getMethodName(), this.cloud.getAllTemplates());
        Assert.assertThat(templates, (Matcher)Matchers.hasSize((int)1));
        SemaphoreStep.success((String)"podTemplate/1", null);
        Assert.assertTrue((String)("Build has failed early: " + this.b.getResult()), (this.b.isBuilding() || Result.SUCCESS.equals(this.b.getResult()) ? 1 : 0) != 0);
        LOGGER.log(Level.INFO, "Found templates with label runInPod: {0}", templates);
        for (Object template : this.cloud.getAllTemplates()) {
            LOGGER.log(Level.INFO, "Cloud template \"{0}\" labels: {1}", new Object[]{template.getName(), template.getLabelSet()});
        }
        Map<String, String> labels = KubernetesTestUtil.getLabels(this.cloud, this, this.name);
        SemaphoreStep.waitForStart((String)"pod/1", (Run)this.b);
        for (Computer c2 : Arrays.stream(this.r.jenkins.getComputers()).filter(c -> c instanceof SlaveComputer).collect(Collectors.toList())) {
            new Thread(() -> {
                long pos = 0L;
                try {
                    while (Jenkins.getInstanceOrNull() != null) {
                        if (c2.getLogFile().isFile()) {
                            pos = c2.getLogText().writeLogTo(pos, (OutputStream)System.out);
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }, "watching logs for " + c2.getDisplayName()).start();
            System.out.println(c2.getLog());
        }
        PodList pods = (PodList)((FilterWatchListDeletable)this.cloud.connect().pods().withLabels(labels)).list();
        Assert.assertThat((String)("Expected one pod with labels " + labels + " but got: " + pods.getItems().stream().map(pod -> pod.getMetadata()).collect(Collectors.toList())), (Object)pods.getItems(), (Matcher)Matchers.hasSize((int)1));
        SemaphoreStep.success((String)"pod/1", null);
        PodTemplate template = templates.get(0);
        List annotations = template.getAnnotations();
        Assert.assertNotNull((Object)annotations);
        boolean foundBuildUrl = false;
        for (PodAnnotation pd : annotations) {
            if (!pd.getKey().equals("buildUrl")) continue;
            Assert.assertTrue((boolean)pd.getValue().contains(this.p.getUrl()));
            foundBuildUrl = true;
        }
        Assert.assertTrue((boolean)foundBuildUrl);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)template.getInstanceCap());
        Assert.assertThat((Object)template.getLabelsMap(), (Matcher)Matchers.hasEntry((Object)"jenkins/label", (Object)this.name.getMethodName()));
        Pod pod2 = (Pod)pods.getItems().get(0);
        LOGGER.log(Level.INFO, "One pod found: {0}", pod2);
        Assert.assertThat((Object)pod2.getMetadata().getLabels(), (Matcher)Matchers.hasEntry((Object)"jenkins", (Object)"slave"));
        Assert.assertThat((String)("Pod labels are wrong: " + pod2), (Object)pod2.getMetadata().getLabels(), (Matcher)Matchers.hasEntry((Object)"jenkins/label", (Object)this.name.getMethodName()));
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("script file contents: ", (Run)this.b);
        Assert.assertFalse((String)"There are pods leftover after test execution, see previous logs", (boolean)KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this.cloud, this, this.name), true));
        Assert.assertThat((String)"routine build should not issue warnings", this.warnings.getRecords().stream().filter(lr -> lr.getLevel().intValue() >= Level.WARNING.intValue()).map(lr -> lr.getSourceClassName() + "." + lr.getSourceMethodName() + ": " + lr.getMessage()).collect(Collectors.toList()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void runIn2Pods() throws Exception {
        SemaphoreStep.waitForStart((String)"podTemplate1/1", (Run)this.b);
        String label1 = this.name.getMethodName() + "-1";
        PodTemplate template1 = this.podTemplatesWithLabel(label1, this.cloud.getAllTemplates()).get(0);
        SemaphoreStep.success((String)"podTemplate1/1", null);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)template1.getInstanceCap());
        Assert.assertThat((Object)template1.getLabelsMap(), (Matcher)Matchers.hasEntry((Object)"jenkins/label", (Object)label1));
        SemaphoreStep.waitForStart((String)"pod1/1", (Run)this.b);
        Map<String, String> labels1 = KubernetesTestUtil.getLabels(this.cloud, this, this.name);
        labels1.put("jenkins/label", label1);
        PodList pods = (PodList)((FilterWatchListDeletable)this.cloud.connect().pods().withLabels(labels1)).list();
        Assert.assertTrue((!pods.getItems().isEmpty() ? 1 : 0) != 0);
        SemaphoreStep.success((String)"pod1/1", null);
        SemaphoreStep.waitForStart((String)"podTemplate2/1", (Run)this.b);
        String label2 = this.name.getMethodName() + "-2";
        PodTemplate template2 = this.podTemplatesWithLabel(label2, this.cloud.getAllTemplates()).get(0);
        SemaphoreStep.success((String)"podTemplate2/1", null);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)template2.getInstanceCap());
        Assert.assertThat((Object)template2.getLabelsMap(), (Matcher)Matchers.hasEntry((Object)"jenkins/label", (Object)label2));
        Assert.assertNull((String)(label2 + " should not inherit from anything"), (Object)template2.getInheritFrom());
        SemaphoreStep.waitForStart((String)"pod2/1", (Run)this.b);
        Map<String, String> labels2 = KubernetesTestUtil.getLabels(this.cloud, this, this.name);
        labels1.put("jenkins/label", label2);
        PodList pods2 = (PodList)((FilterWatchListDeletable)this.cloud.connect().pods().withLabels(labels2)).list();
        Assert.assertTrue((!pods2.getItems().isEmpty() ? 1 : 0) != 0);
        SemaphoreStep.success((String)"pod2/1", null);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("script file contents: ", (Run)this.b);
        Assert.assertFalse((String)"There are pods leftover after test execution, see previous logs", (boolean)KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this.cloud, this, this.name), true));
    }

    private List<PodTemplate> podTemplatesWithLabel(String label, List<PodTemplate> templates) {
        return templates.stream().filter(t -> label.equals(t.getLabel())).collect(Collectors.toList());
    }

    @Test
    public void runInPodFromYaml() throws Exception {
        List templates = this.cloud.getTemplates();
        while (templates.isEmpty()) {
            LOGGER.log(Level.INFO, "Waiting for template to be created");
            templates = this.cloud.getTemplates();
            Thread.sleep(1000L);
        }
        Assert.assertFalse((boolean)templates.isEmpty());
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)template.getInstanceCap());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("script file contents: ", (Run)this.b);
        this.r.assertLogNotContains("container-pa55w0rd", (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_ENV_VAR_FROM_SECRET = ******** or " + "container-pa55w0rd".toUpperCase(Locale.ROOT) + "\n", (Run)this.b);
        Assert.assertFalse((String)"There are pods leftover after test execution, see previous logs", (boolean)KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this.cloud, this, this.name), true));
    }

    @Test
    public void runInPodWithDifferentShell() throws Exception {
        this.r.assertBuildStatus(Result.FAILURE, this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void bourneShellElsewhereInPath() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("/kaniko:/busybox", (Run)this.b);
    }

    @Test
    public void runInPodWithMultipleContainers() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("image: \"jenkins/jnlp-slave:3.35-5-alpine\"", (Run)this.b);
        this.r.assertLogContains("image: \"maven:3.3.9-jdk-8-alpine\"", (Run)this.b);
        this.r.assertLogContains("image: \"golang:1.6.3-alpine\"", (Run)this.b);
        this.r.assertLogContains("My Kubernetes Pipeline", (Run)this.b);
        this.r.assertLogContains("my-mount", (Run)this.b);
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
    }

    @Test
    public void runInPodNested() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("image: \"maven:3.3.9-jdk-8-alpine\"", (Run)this.b);
        this.r.assertLogContains("image: \"golang:1.6.3-alpine\"", (Run)this.b);
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogContains("go version go1.6.3", (Run)this.b);
    }

    @Test
    public void runInPodNestedExplicitInherit() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("image: \"maven:3.3.9-jdk-8-alpine\"", (Run)this.b);
        this.r.assertLogNotContains("image: \"golang:1.6.3-alpine\"", (Run)this.b);
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogNotContains("go version go1.6.3", (Run)this.b);
    }

    @Test
    public void runInPodWithExistingTemplate() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("outside container", (Run)this.b);
        this.r.assertLogContains("inside container", (Run)this.b);
        this.assertEnvVars(this.r, this.b);
    }

    @Test
    public void runWithEnvVariables() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.assertEnvVars(this.r, this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_BUILD_NUMBER = 1\n", (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_BUILD_NUMBER = 1\n", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_JOB_NAME = " + this.getProjectName() + "\n", (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_JOB_NAME = " + this.getProjectName() + "\n", (Run)this.b);
        this.r.assertLogContains("INSIDE_JAVA_HOME =\n", (Run)this.b);
        this.r.assertLogContains("JNLP_JAVA_HOME = /usr/lib/jvm/java-1.8-openjdk\n", (Run)this.b);
        this.r.assertLogContains("JAVA7_HOME = /usr/lib/jvm/java-1.7-openjdk/jre\n", (Run)this.b);
        this.r.assertLogContains("JAVA8_HOME = /usr/lib/jvm/java-1.8-openjdk/jre\n", (Run)this.b);
        this.r.assertLogContains("INSIDE_JAVA_HOME_X = java-home-x\n", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_JAVA_HOME_X = java-home-x\n", (Run)this.b);
        this.r.assertLogContains("JNLP_JAVA_HOME_X = java-home-x\n", (Run)this.b);
        this.r.assertLogContains("JAVA7_HOME_X = java-home-x\n", (Run)this.b);
        this.r.assertLogContains("JAVA8_HOME_X = java-home-x\n", (Run)this.b);
    }

    @Test
    public void runWithEnvVariablesInContext() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("The initial value of POD_ENV_VAR is pod-env-var-value", (Run)this.b);
        this.r.assertLogContains("The value of POD_ENV_VAR outside container is /bin/mvn:pod-env-var-value", (Run)this.b);
        this.r.assertLogContains("The value of FROM_ENV_DEFINITION is ABC", (Run)this.b);
        this.r.assertLogContains("The value of FROM_WITHENV_DEFINITION is DEF", (Run)this.b);
        this.r.assertLogContains("The value of WITH_QUOTE is \"WITH_QUOTE", (Run)this.b);
        this.r.assertLogContains("The value of AFTER_QUOTE is AFTER_QUOTE\"", (Run)this.b);
        this.r.assertLogContains("The value of ESCAPED_QUOTE is \\\"ESCAPED_QUOTE", (Run)this.b);
        this.r.assertLogContains("The value of AFTER_ESCAPED_QUOTE is AFTER_ESCAPED_QUOTE\\\"", (Run)this.b);
        this.r.assertLogContains("The value of SINGLE_QUOTE is BEFORE'AFTER", (Run)this.b);
        this.r.assertLogContains("The value of WITH_NEWLINE is before newline\nafter newline", (Run)this.b);
        this.r.assertLogContains("The value of POD_ENV_VAR is /bin/mvn:pod-env-var-value", (Run)this.b);
        this.r.assertLogContains("The value of WILL.NOT is ", (Run)this.b);
    }

    private void assertEnvVars(JenkinsRuleNonLocalhost r2, WorkflowRun b) throws Exception {
        this.r.assertLogNotContains("pod-pa55w0rd", (Run)b);
        this.r.assertLogNotContains("container-pa55w0rd", (Run)b);
        this.r.assertLogContains("INSIDE_CONTAINER_ENV_VAR = container-env-var-value\n", (Run)b);
        this.r.assertLogContains("INSIDE_CONTAINER_ENV_VAR_LEGACY = container-env-var-value\n", (Run)b);
        this.r.assertLogContains("INSIDE_CONTAINER_ENV_VAR_FROM_SECRET = ******** or " + "container-pa55w0rd".toUpperCase(Locale.ROOT) + "\n", (Run)b);
        this.r.assertLogContains("INSIDE_POD_ENV_VAR = pod-env-var-value\n", (Run)b);
        this.r.assertLogContains("INSIDE_POD_ENV_VAR_FROM_SECRET = ******** or " + "pod-pa55w0rd".toUpperCase(Locale.ROOT) + "\n", (Run)b);
        this.r.assertLogContains("INSIDE_EMPTY_POD_ENV_VAR_FROM_SECRET = ''", (Run)b);
        this.r.assertLogContains("INSIDE_GLOBAL = GLOBAL\n", (Run)b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR =\n", (Run)b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR_LEGACY =\n", (Run)b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR_FROM_SECRET = or\n", (Run)b);
        this.r.assertLogContains("OUTSIDE_POD_ENV_VAR = pod-env-var-value\n", (Run)b);
        this.r.assertLogContains("OUTSIDE_POD_ENV_VAR_FROM_SECRET = ******** or " + "pod-pa55w0rd".toUpperCase(Locale.ROOT) + "\n", (Run)b);
        this.r.assertLogContains("OUTSIDE_EMPTY_POD_ENV_VAR_FROM_SECRET = ''", (Run)b);
        this.r.assertLogContains("OUTSIDE_GLOBAL = GLOBAL\n", (Run)b);
    }

    @Test
    public void runWithOverriddenEnvVariables() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("OUTSIDE_CONTAINER_HOME_ENV_VAR = /home/jenkins\n", (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_HOME_ENV_VAR = /root\n", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_POD_ENV_VAR = pod-env-var-value\n", (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_POD_ENV_VAR = container-env-var-value\n", (Run)this.b);
    }

    @Test
    public void supportComputerEnvVars() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("OPENJDK_BUILD_NUMBER: 1\n", (Run)this.b);
        this.r.assertLogContains("JNLP_BUILD_NUMBER: 1\n", (Run)this.b);
        this.r.assertLogContains("DEFAULT_BUILD_NUMBER: 1\n", (Run)this.b);
    }

    @Test
    public void runDirContext() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        String workspace = "/home/jenkins/agent/workspace/" + this.getProjectName();
        this.r.assertLogContains("initpwd is -" + workspace + "-", (Run)this.b);
        this.r.assertLogContains("dirpwd is -" + workspace + "/hz-", (Run)this.b);
        this.r.assertLogContains("postpwd is -" + workspace + "-", (Run)this.b);
    }

    @Test
    public void runInPodWithLivenessProbe() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Still alive", (Run)this.b);
    }

    @Test
    public void podTemplateWithMultipleLabels() throws Exception {
        PodTemplate pt = new PodTemplate();
        pt.setName("podTemplate");
        pt.setLabel("label1 label2");
        ContainerTemplate jnlp = new ContainerTemplate("jnlp", "jenkins/jnlp-slave:3.35-5-alpine");
        pt.setContainers(Collections.singletonList(jnlp));
        this.cloud.addTemplate(pt);
        SemaphoreStep.waitForStart((String)"pod/1", (Run)this.b);
        Map<String, String> labels = KubernetesTestUtil.getLabels(this.cloud, this, this.name);
        labels.put("jenkins/label", "label1_label2");
        KubernetesSlave node = this.r.jenkins.getNodes().stream().filter(KubernetesSlave.class::isInstance).map(KubernetesSlave.class::cast).findAny().get();
        Assert.assertTrue((boolean)node.getAssignedLabels().containsAll(Label.parse((String)"label1 label2")));
        PodList pods = (PodList)((FilterWatchListDeletable)this.cloud.connect().pods().withLabels(labels)).list();
        Assert.assertThat((String)("Expected one pod with labels " + labels + " but got: " + pods.getItems().stream().map(pod -> pod.getMetadata()).collect(Collectors.toList())), (Object)pods.getItems(), (Matcher)Matchers.hasSize((int)1));
        SemaphoreStep.success((String)"pod/1", null);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void runWithActiveDeadlineSeconds() throws Exception {
        SemaphoreStep.waitForStart((String)"podTemplate/1", (Run)this.b);
        PodTemplate deadlineTemplate = this.cloud.getAllTemplates().stream().filter(x -> this.name.getMethodName().equals(x.getLabel())).findAny().orElse(null);
        Assert.assertNotNull((Object)deadlineTemplate);
        SemaphoreStep.success((String)"podTemplate/1", null);
        Assert.assertEquals((long)10L, (long)deadlineTemplate.getActiveDeadlineSeconds());
        this.b.getExecutor().interrupt();
        this.r.assertBuildStatus(Result.ABORTED, this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void runInPodWithRetention() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        Assert.assertTrue((boolean)KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this, this.name), true));
    }

    @Test
    public void terminatedPod() throws Exception {
        this.r.waitForMessage("+ sleep", (Run)this.b);
        KubernetesTestUtil.deletePods(this.cloud.connect(), KubernetesTestUtil.getLabels(this, this.name), false);
        this.r.assertBuildStatus(Result.ABORTED, this.r.waitForCompletion((Run)this.b));
        this.r.waitForMessage(new ExecutorStepExecution.RemovedNodeCause().getShortDescription(), (Run)this.b);
    }

    @Test
    public void interruptedPod() throws Exception {
        this.r.waitForMessage("starting to sleep", (Run)this.b);
        this.b.getExecutor().interrupt();
        this.r.assertBuildStatus(Result.ABORTED, this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("shut down gracefully", (Run)this.b);
    }

    @Test
    public void cascadingDelete() throws Exception {
        try {
            ((RollableScalableResource)this.cloud.connect().apps().deployments().withName("cascading-delete")).delete();
        }
        catch (KubernetesClientException x) {
            Assume.assumeNoException((String)"was not permitted to clean up any previous deployment, so presumably cannot run test either", (Throwable)x);
        }
        ((FilterWatchListDeletable)this.cloud.connect().apps().replicaSets().withLabel("app", "cascading-delete")).delete();
        ((FilterWatchListDeletable)this.cloud.connect().pods().withLabel("app", "cascading-delete")).delete();
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void computerCantBeConfigured() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"admin"}));
        SemaphoreStep.waitForStart((String)"pod/1", (Run)this.b);
        Optional<KubernetesSlave> optionalNode = this.r.jenkins.getNodes().stream().filter(KubernetesSlave.class::isInstance).map(KubernetesSlave.class::cast).findAny();
        Assert.assertTrue((boolean)optionalNode.isPresent());
        KubernetesSlave node = optionalNode.get();
        JenkinsRule.WebClient wc = this.r.createWebClient().login("admin");
        wc.getOptions().setPrintContentOnFailingStatusCode(false);
        HtmlPage nodeIndex = wc.getPage((Node)node);
        this.assertNotXPath(nodeIndex, "//*[text() = 'configure']");
        wc.assertFails(node.toComputer().getUrl() + "configure", 403);
        SemaphoreStep.success((String)"pod/1", null);
    }

    private void assertNotXPath(HtmlPage page, String xpath) {
        HtmlElement documentElement = page.getDocumentElement();
        Assert.assertNull((String)("There should not be an object that matches XPath:" + xpath), (Object)DomNodeUtil.selectSingleNode((DomNode)documentElement, (String)xpath));
    }

    @Test
    public void runInPodWithShowRawYamlFalse() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogNotContains("value: \"container-env-var-value\"", (Run)this.b);
    }

    @Test
    public void showRawYamlFalseInherited() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogNotContains("value: \"container-env-var-value\"", (Run)this.b);
    }

    @Test
    public void overrideYaml() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void mergeYaml() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void jenkinsSecretHidden() throws Exception {
        SemaphoreStep.waitForStart((String)"pod/1", (Run)this.b);
        Optional<SlaveComputer> scOptional = Arrays.stream(this.r.jenkins.getComputers()).filter(SlaveComputer.class::isInstance).map(SlaveComputer.class::cast).findAny();
        Assert.assertTrue((boolean)scOptional.isPresent());
        String jnlpMac = scOptional.get().getJnlpMac();
        SemaphoreStep.success((String)"pod/1", (Object)this.b);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogNotContains(jnlpMac, (Run)this.b);
    }

    @Test
    public void jnlpWorkingDir() throws Exception {
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
    }

    @Test
    public void runInDynamicallyCreatedContainer() throws Exception {
        List templates = this.cloud.getTemplates();
        while (templates.isEmpty()) {
            LOGGER.log(Level.INFO, "Waiting for template to be created");
            templates = this.cloud.getTemplates();
            Thread.sleep(1000L);
        }
        Assert.assertFalse((boolean)templates.isEmpty());
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)template.getInstanceCap());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("whoami", (Run)this.b);
        this.r.assertLogContains("root", (Run)this.b);
    }

    @Test
    public void basicWindows() throws Exception {
        KubernetesTestUtil.assumeWindows();
        this.cloud.setDirectConnection(false);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Directory of C:\\home\\jenkins\\agent\\workspace\\basic Windows", (Run)this.b);
        this.r.assertLogContains("C:\\Program Files (x86)", (Run)this.b);
    }

    @Test
    public void windowsContainer() throws Exception {
        KubernetesTestUtil.assumeWindows();
        this.cloud.setDirectConnection(false);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Directory of C:\\home\\jenkins\\agent\\workspace\\windows Container\\subdir", (Run)this.b);
        this.r.assertLogContains("C:\\Users\\ContainerAdministrator", (Run)this.b);
        this.r.assertLogContains("got stuff: some value", (Run)this.b);
    }

    @Ignore(value="TODO aborts, but with \u201ckill finished with exit code 9009\u201d and \u201cAfter 20s process did not stop\u201d and no graceful shutdown")
    @Test
    public void interruptedPodWindows() throws Exception {
        KubernetesTestUtil.assumeWindows();
        this.cloud.setDirectConnection(false);
        this.r.waitForMessage("starting to sleep", (Run)this.b);
        this.b.getExecutor().interrupt();
        this.r.assertBuildStatus(Result.ABORTED, this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("shut down gracefully", (Run)this.b);
    }

    @Test
    public void secretMaskingWindows() throws Exception {
        KubernetesTestUtil.assumeWindows();
        this.cloud.setDirectConnection(false);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("INSIDE_POD_ENV_VAR_FROM_SECRET = ******** or " + "pod-pa55w0rd".toUpperCase(Locale.ROOT), (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_ENV_VAR_FROM_SECRET = ******** or " + "container-pa55w0rd".toUpperCase(Locale.ROOT), (Run)this.b);
        this.r.assertLogNotContains("pod-pa55w0rd", (Run)this.b);
        this.r.assertLogNotContains("container-pa55w0rd", (Run)this.b);
    }

    @Test
    public void dynamicPVC() throws Exception {
        try {
            this.cloud.connect().persistentVolumeClaims().list();
        }
        catch (KubernetesClientException x) {
            Assume.assumeNoException((String)"was not permitted to list pvcs, so presumably cannot run test either", (Throwable)x);
        }
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
    }
}

