/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.model.Run;
import java.util.HashMap;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.AbstractKubernetesPipelineTest;
import org.junit.Assert;
import org.junit.Test;

public class KubernetesPipelineOverridenNamespaceTest
extends AbstractKubernetesPipelineTest {
    @Test
    public void runWithCloudOverriddenNamespace() throws Exception {
        String overriddenNamespace = KubernetesTestUtil.testingNamespace + "-overridden-namespace";
        this.cloud.setNamespace(overriddenNamespace);
        this.createNamespaceIfNotExist(this.cloud.connect(), overriddenNamespace);
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains(overriddenNamespace, (Run)this.b);
    }

    @Test
    public void runWithStepOverriddenNamespace() throws Exception {
        String overriddenNamespace = KubernetesTestUtil.testingNamespace + "-overridden-namespace";
        String stepNamespace = KubernetesTestUtil.testingNamespace + "-overridden-namespace2";
        this.cloud.setNamespace(overriddenNamespace);
        this.createNamespaceIfNotExist(this.cloud.connect(), stepNamespace);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("OVERRIDDEN_NAMESPACE", stepNamespace);
        Assert.assertNotNull((Object)this.createJobThenScheduleRun(env));
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains(stepNamespace, (Run)this.b);
    }
}

