/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.util.List;
import java.util.Map;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitStep;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.AbstractKubernetesPipelineTest;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.NodeStepTypePredicate;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KubernetesDeclarativeAgentTest
extends AbstractKubernetesPipelineTest {
    @Rule
    public GitSampleRepoRule repoRule = new GitSampleRepoRule();

    @Test
    public void declarative() throws Exception {
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogContains("INSIDE_CONTAINER_ENV_VAR = container-env-var-value\n", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR = container-env-var-value\n", (Run)this.b);
        FlowNode podTemplateNode = new DepthFirstScanner().findFirstMatch(this.b.getExecution(), Predicates.and((Predicate)new NodeStepTypePredicate("podTemplate"), (Predicate)FlowScanningUtils.hasActionPredicate(ArgumentsAction.class)));
        Assert.assertNotNull((String)"recorded arguments for podTemplate", (Object)podTemplateNode);
        Map arguments = ((ArgumentsAction)podTemplateNode.getAction(ArgumentsAction.class)).getArguments();
        List containers = (List)arguments.get("containers");
        Assert.assertNotNull((Object)containers);
        Assert.assertFalse((String)("no junk in arguments: " + arguments), (boolean)((UninstantiatedDescribable)containers.get(0)).getArguments().containsKey("alwaysPullImage"));
        FlowNode containerNode = new DepthFirstScanner().findFirstMatch(this.b.getExecution(), Predicates.and((Predicate)new NodeStepTypePredicate("container"), (Predicate)FlowScanningUtils.hasActionPredicate(ArgumentsAction.class)));
        Assert.assertNotNull((String)"recorded arguments for container", (Object)containerNode);
    }

    @Test
    public void declarativeFromYaml() throws Exception {
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR = jnlp\n", (Run)this.b);
        this.r.assertLogContains("MAVEN_CONTAINER_ENV_VAR = maven\n", (Run)this.b);
        this.r.assertLogContains("BUSYBOX_CONTAINER_ENV_VAR = busybox\n", (Run)this.b);
    }

    @Test
    public void declarativeWithNamespaceFromYaml() throws Exception {
        this.createNamespaceIfNotExist(this.cloud.connect(), "kubernetes-plugin-test-overridden-namespace");
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR = jnlp\n", (Run)this.b);
        this.r.assertLogContains("MAVEN_CONTAINER_ENV_VAR = maven\n", (Run)this.b);
        this.r.assertLogContains("BUSYBOX_CONTAINER_ENV_VAR = busybox\n", (Run)this.b);
    }

    @Test
    public void declarativeFromYamlFile() throws Exception {
        this.repoRule.init();
        this.repoRule.write("Jenkinsfile", this.loadPipelineDefinition());
        this.repoRule.write("declarativeYamlFile.yml", this.loadPipelineScript("declarativeYamlFile.yml"));
        this.repoRule.git(new String[]{"add", "Jenkinsfile"});
        this.repoRule.git(new String[]{"add", "declarativeYamlFile.yml"});
        this.repoRule.git(new String[]{"commit", "--message=files"});
        this.p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "job with dir");
        this.p.setDefinition((FlowDefinition)new CpsScmFlowDefinition(new GitStep(this.repoRule.toString()).createSCM(), "Jenkinsfile"));
        this.b = (WorkflowRun)this.p.scheduleBuild2(0, new Action[0]).waitForStart();
        Assert.assertNotNull((Object)this.b);
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogContains("OUTSIDE_CONTAINER_ENV_VAR = jnlp\n", (Run)this.b);
        this.r.assertLogContains("MAVEN_CONTAINER_ENV_VAR = maven\n", (Run)this.b);
        this.r.assertLogContains("BUSYBOX_CONTAINER_ENV_VAR = busybox\n", (Run)this.b);
    }

    @Test
    public void declarativeSCMVars() throws Exception {
        this.p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "job with repo");
        this.p.setDefinition((FlowDefinition)new CpsScmFlowDefinition(new GitStep("https://github.com/abayer/jenkins-52623.git").createSCM(), "Jenkinsfile"));
        this.b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)this.p);
        this.r.assertLogContains("Outside container: GIT_BRANCH is origin/master", (Run)this.b);
        this.r.assertLogContains("In container: GIT_BRANCH is origin/master", (Run)this.b);
    }

    @Test
    public void declarativeCustomWorkspace() throws Exception {
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogContains("Workspace dir is", (Run)this.b);
    }

    @Test
    public void declarativeCustomWorkingDir() throws Exception {
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("[jnlp] current dir is /home/jenkins/agent/workspace/declarative Custom Working Dir/foo", (Run)this.b);
        this.r.assertLogContains("[jnlp] WORKSPACE=/home/jenkins/agent/workspace/declarative Custom Working Dir", (Run)this.b);
        this.r.assertLogContains("[maven] current dir is /home/jenkins/wsp1/workspace/declarative Custom Working Dir/foo", (Run)this.b);
        this.r.assertLogContains("[maven] WORKSPACE=/home/jenkins/wsp1/workspace/declarative Custom Working Dir", (Run)this.b);
        this.r.assertLogContains("[default:maven] current dir is /home/jenkins/wsp1/workspace/declarative Custom Working Dir/foo", (Run)this.b);
        this.r.assertLogContains("[default:maven] WORKSPACE=/home/jenkins/wsp1/workspace/declarative Custom Working Dir", (Run)this.b);
    }

    @Test
    public void declarativeWithNestedExplicitInheritance() throws Exception {
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.assertBuildStatusSuccess(this.r.waitForCompletion((Run)this.b));
        this.r.assertLogContains("Apache Maven 3.3.9", (Run)this.b);
        this.r.assertLogNotContains("go version go1.6.3", (Run)this.b);
    }
}

