/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesClientProvider;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.jvnet.hudson.test.LoggerRule;
import org.mockito.Mockito;

public class ContainerExecDecoratorTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KubernetesCloud cloud;
    private static KubernetesClient client;
    private static final Pattern PID_PATTERN;
    private ContainerExecDecorator decorator;
    private Pod pod;
    private KubernetesSlave agent;
    @Rule
    public LoggerRule containerExecLogs = new LoggerRule().record(Logger.getLogger(ContainerExecDecorator.class.getName()), Level.ALL).record(Logger.getLogger(KubernetesClientProvider.class.getName()), Level.ALL);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void isKubernetesConfigured() throws Exception {
        KubernetesTestUtil.assumeKubernetes();
    }

    @Before
    public void configureCloud() throws Exception {
        this.cloud = KubernetesTestUtil.setupCloud(this, this.name);
        client = this.cloud.connect();
        KubernetesTestUtil.deletePods(client, KubernetesTestUtil.getLabels(this, this.name), false);
        String image = "busybox";
        Container c = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(image)).withImagePullPolicy("IfNotPresent")).withImage(image)).withCommand(new String[]{"cat"})).withTty(Boolean.valueOf(true))).build();
        Container d = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(image + "1")).withImagePullPolicy("IfNotPresent")).withImage(image)).withCommand(new String[]{"cat"})).withTty(Boolean.valueOf(true))).withWorkingDir("/home/jenkins/agent1")).build();
        String podName = "test-command-execution-" + RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        this.pod = (Pod)client.pods().create((Object[])new Pod[]{((PodBuilder)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(podName)).withLabels(KubernetesTestUtil.getLabels(this, this.name))).endMetadata()).withNewSpec().withContainers(new Container[]{c, d})).withNodeSelector(Collections.singletonMap("kubernetes.io/os", "linux"))).endSpec()).build()});
        System.out.println("Created pod: " + this.pod.getMetadata().getName());
        PodTemplate template = new PodTemplate();
        template.setName(this.pod.getMetadata().getName());
        this.agent = (KubernetesSlave)Mockito.mock(KubernetesSlave.class);
        Mockito.when((Object)this.agent.getNamespace()).thenReturn((Object)client.getNamespace());
        Mockito.when((Object)this.agent.getPodName()).thenReturn((Object)this.pod.getMetadata().getName());
        ((KubernetesSlave)Mockito.doReturn((Object)this.cloud).when((Object)this.agent)).getKubernetesCloud();
        Mockito.when((Object)this.agent.getPod()).thenReturn(Optional.of(this.pod));
        StepContext context = (StepContext)Mockito.mock(StepContext.class);
        Mockito.when((Object)context.get(Node.class)).thenReturn((Object)this.agent);
        this.decorator = new ContainerExecDecorator();
        this.decorator.setNodeContext(new KubernetesNodeContext(context));
        this.decorator.setContainerName(image);
    }

    @After
    public void after() throws Exception {
        client.pods().delete((Object[])new Pod[]{this.pod});
        KubernetesTestUtil.deletePods(client, KubernetesTestUtil.getLabels(this, this.name), true);
    }

    @Test(timeout=10000L)
    public void testCommandExecution() throws Exception {
        int i;
        Thread[] t = new Thread[10];
        List<ProcReturn> results = Collections.synchronizedList(new ArrayList(t.length));
        for (i = 0; i < t.length; ++i) {
            t[i] = this.newThread(i, results);
        }
        for (i = 0; i < t.length; ++i) {
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        Assert.assertEquals((String)"Not all threads finished successfully", (long)t.length, (long)results.size());
        for (ProcReturn r : results) {
            Assert.assertTrue((String)("Output should contain pid: " + r.output), (boolean)PID_PATTERN.matcher(r.output).find());
            Assert.assertEquals((long)0L, (long)r.exitCode);
            Assert.assertFalse((boolean)r.proc.isAlive());
        }
    }

    private Thread newThread(final int i, final List<ProcReturn> results) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ContainerExecDecoratorTest.this.command(results, i);
                }
                finally {
                    System.out.println("Thread " + i + " finished");
                }
            }
        }, "test-" + i);
    }

    private void command(List<ProcReturn> results, int i) {
        ProcReturn r;
        try {
            r = this.execCommand(false, "sh", "-c", "cd /tmp; echo [" + i + "] pid is $$$$ > test; cat /tmp/test");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        results.add(r);
    }

    @Test
    public void testCommandExecutionFailure() throws Exception {
        ProcReturn r = this.execCommand(false, "false");
        Assert.assertEquals((long)1L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void testCommandExecutionFailureHighError() throws Exception {
        ProcReturn r = this.execCommand(false, "sh", "-c", "return 127");
        Assert.assertEquals((long)127L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void testQuietCommandExecution() throws Exception {
        ProcReturn r = this.execCommand(true, "echo", "pid is 9999");
        Assert.assertFalse((String)("Output should not contain command: " + r.output), (boolean)PID_PATTERN.matcher(r.output).find());
        Assert.assertEquals((long)0L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void testCommandExecutionWithNohup() throws Exception {
        ProcReturn r = this.execCommand(false, "nohup", "sh", "-c", "sleep 5; cd /tmp; echo pid is $$$$ > test; cat /tmp/test");
        Assert.assertTrue((String)("Output should contain pid: " + r.output), (boolean)PID_PATTERN.matcher(r.output).find());
        Assert.assertEquals((long)0L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void commandsEscaping() {
        Launcher.ProcStarter procStarter = new Launcher.DummyLauncher(null).launch();
        procStarter = procStarter.cmds(new String[]{"$$$$", "$$?"});
        Object[] commands = ContainerExecDecorator.getCommands((Launcher.ProcStarter)procStarter, null);
        Assert.assertArrayEquals((Object[])new String[]{"\\$\\$", "\\$?"}, (Object[])commands);
    }

    @Test
    public void testCommandExecutionWithEscaping() throws Exception {
        ProcReturn r = this.execCommand(false, "sh", "-c", "cd /tmp; false; echo result is $$? > test; cat /tmp/test");
        Assert.assertTrue((String)("Output should contain result: " + r.output), (boolean)Pattern.compile("^(result is 1)$", 8).matcher(r.output).find());
        Assert.assertEquals((long)0L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void testCommandExecutionWithNohupAndError() throws Exception {
        ProcReturn r = this.execCommand(false, "nohup", "sh", "-c", "sleep 5; return 127");
        Assert.assertEquals((long)127L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void testContainerDoesNotExist() throws Exception {
        this.decorator.setContainerName("doesNotExist");
        this.exception.expect(IOException.class);
        this.exception.expectMessage(Matchers.containsString((String)"container [doesNotExist] does not exist in pod ["));
        this.execCommand(false, "nohup", "sh", "-c", "sleep 5; return 127");
    }

    @Test
    public void testRejectedExecutionException() throws Exception {
        Assert.assertTrue((boolean)(client instanceof HttpClientAware));
        final OkHttpClient httpClient = ((HttpClientAware)client).getHttpClient();
        System.out.println("Max requests: " + httpClient.dispatcher().getMaxRequests() + "/" + httpClient.dispatcher().getMaxRequestsPerHost());
        System.out.println("Connection count: " + httpClient.connectionPool().connectionCount() + " - " + httpClient.connectionPool().idleConnectionCount());
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 10; ++i) {
            final String name = "Thread " + i;
            Thread t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println(name + " Connection count: " + httpClient.connectionPool().connectionCount() + " - " + httpClient.connectionPool().idleConnectionCount());
                        ProcReturn procReturn = ContainerExecDecoratorTest.this.execCommand(false, new String[]{"echo", "test"});
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                        System.out.println(e.getMessage());
                    }
                }
            });
            threads.add(t2);
        }
        KubernetesClientProvider.invalidate((String)this.cloud.getDisplayName());
        this.cloud.connect();
        boolean expireClients = KubernetesClientProvider.closeExpiredClients();
        Assert.assertFalse((boolean)expireClients);
        threads.stream().forEach(t -> t.start());
        threads.stream().forEach(t -> {
            try {
                System.out.println("Waiting for " + t.getName());
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        System.out.println("Connection count: " + httpClient.connectionPool().connectionCount() + " - " + httpClient.connectionPool().idleConnectionCount());
        Assert.assertEquals((String)"Errors in threads", (long)0L, (long)errors.get());
    }

    @Test
    public void testContainerExecPerformance() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ProcReturn procReturn = this.execCommand(false, "ls");
        }
    }

    @Test
    public void testContainerExecOnCustomWorkingDir() throws Exception {
        ((Node)Mockito.doReturn(null).when((Object)this.agent)).toComputer();
        ProcReturn r = this.execCommandInContainer("busybox1", (Node)this.agent, false, "env");
        Assert.assertTrue((String)"Environment variable workingDir1 should be changed to /home/jenkins/agent1", (boolean)r.output.contains("workingDir1=/home/jenkins/agent1"));
        Assert.assertEquals((long)0L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    @Test
    public void testContainerExecOnCustomWorkingDirWithComputeEnvVars() throws Exception {
        EnvVars computeEnvVars = new EnvVars();
        computeEnvVars.put("MyDir", "dir");
        computeEnvVars.put("MyCustomDir", "/home/jenkins/agent");
        Computer computer = (Computer)Mockito.mock(Computer.class);
        ((Computer)Mockito.doReturn((Object)computeEnvVars).when((Object)computer)).getEnvironment();
        ((Node)Mockito.doReturn((Object)computer).when((Object)this.agent)).toComputer();
        ProcReturn r = this.execCommandInContainer("busybox1", (Node)this.agent, false, "env");
        Assert.assertTrue((String)"Environment variable workingDir1 should be changed to /home/jenkins/agent1", (boolean)r.output.contains("workingDir1=/home/jenkins/agent1"));
        Assert.assertTrue((String)"Environment variable MyCustomDir should be changed to /home/jenkins/agent1", (boolean)r.output.contains("MyCustomDir=/home/jenkins/agent1"));
        Assert.assertEquals((long)0L, (long)r.exitCode);
        Assert.assertFalse((boolean)r.proc.isAlive());
    }

    private ProcReturn execCommand(boolean quiet, String ... cmd) throws Exception {
        return this.execCommandInContainer(null, null, quiet, cmd);
    }

    private ProcReturn execCommandInContainer(String containerName, Node node, boolean quiet, String ... cmd) throws Exception {
        if (containerName != null && !containerName.isEmpty()) {
            this.decorator.setContainerName(containerName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Launcher launcher = this.decorator.decorate((Launcher)new Launcher.DummyLauncher((TaskListener)new StreamTaskListener((OutputStream)new TeeOutputStream((OutputStream)out, (OutputStream)System.out))), node);
        HashMap<String, String> envs = new HashMap<String, String>(100);
        for (int i = 0; i < 50; ++i) {
            envs.put("aaaaaaaa" + i, "bbbbbbbb");
        }
        envs.put("workingDir1", "/home/jenkins/agent");
        ContainerExecProc proc = (ContainerExecProc)launcher.launch(new Launcher.ProcStarter(launcher).pwd("/tmp").cmds(cmd).envs(envs).quiet(quiet));
        for (int i = 0; proc.isAlive() && i < 200; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"proc is alive", (boolean)proc.isAlive());
        int exitCode = proc.joinWithTimeout(10L, TimeUnit.SECONDS, (TaskListener)StreamTaskListener.fromStderr());
        return new ProcReturn(proc, exitCode, out.toString());
    }

    static {
        PID_PATTERN = Pattern.compile("^((?:\\[\\d+\\] )?pid is \\d+)$", 8);
    }

    class ProcReturn {
        public int exitCode;
        public String output;
        public ContainerExecProc proc;

        ProcReturn(ContainerExecProc proc, int exitCode, String output) {
            this.proc = proc;
            this.exitCode = exitCode;
            this.output = output;
        }
    }
}

