/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Run;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.utils.IOUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.AbstractKubernetesPipelineTest;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator;
import org.jenkinsci.plugins.durabletask.BourneShellScript;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.LoggerRule;

public class ContainerExecDecoratorPipelineTest
extends AbstractKubernetesPipelineTest {
    @Rule
    public LoggerRule containerExecLogs = new LoggerRule().record(Logger.getLogger(ContainerExecDecorator.class.getName()), Level.ALL).record(BourneShellScript.class, Level.ALL);

    @Test
    public void sshagent() throws Exception {
        BasicSSHUserPrivateKey.DirectEntryPrivateKeySource source = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(new String(IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("id_rsa"))));
        BasicSSHUserPrivateKey credentials = new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, "ContainerExecDecoratorPipelineTest-sshagent", "bob", (BasicSSHUserPrivateKey.PrivateKeySource)source, "secret_passphrase", "test credentials");
        SystemCredentialsProvider.getInstance().getCredentials().add(credentials);
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.waitForCompletion((Run)this.b);
        this.r.assertLogContains("Identity added:", (Run)this.b);
        this.r.assertLogContains("SSH_AGENT_PID=", (Run)this.b);
        this.r.assertLogContains("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDhvmTBXRnSbtpnkt/Ldw7ws4LFdoX9oI+5NexgpBC4Otqbn8+Ui6FGWeYflOQUcl3rgmBxsHIeFnPr9qSvgME1TWPIyHSQh2kPMd3NQgkEvioBxghnWRy7sal4KBr2P8m7Iusm8j0aCNLZ3nYjJSywWZxiqqrcpnhFuTD//FPIEhXOu2sk2FEP7YsA9TdL8mAruxy/6Ys2pRC2dQhBtmkEOyEGiBnk3ioT5iCw/Qqe+pU0yaYu69vPyAFCuazBMopPcOuRxFgKvrfCPVqcQb3HERJh5eiW5+5Vg3RwoByQUtQMK5PDBVWPo9srB0Q9Aw9DXmeJCgdtFJqhhh4SR+al /home/jenkins/agent/workspace/sshagent@tmp/private_key", (Run)this.b);
        this.r.assertLogNotContains("secret_passphrase", (Run)this.b);
    }

    @Test
    public void docker() throws Exception {
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "ContainerExecDecoratorPipelineTest-docker", "bob", "myusername", "secret_password");
        SystemCredentialsProvider.getInstance().getCredentials().add(credentials);
        this.containerExecLogs.capture(1000);
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.r.waitForCompletion((Run)this.b);
        this.r.assertLogContains("Executing command: \"docker\" \"login\" \"-u\" \"myusername\" \"-p\" ******** \"https://index.docker.io/v1/\"", (Run)this.b);
        this.r.assertLogNotContains("secret_password", (Run)this.b);
        Assert.assertFalse((String)"credential leaked to log", (boolean)this.containerExecLogs.getMessages().stream().anyMatch(msg -> msg.contains("secret_password")));
    }

    @Test
    public void websocket() throws Exception {
        Assert.assertNotNull((Object)this.createJobThenScheduleRun());
        this.containerExecLogs.capture(1000);
        this.r.waitForMessage("have started user process", (Run)this.b);
        Assert.assertTrue((String)"WebSocket was closed in a timely fashion", (boolean)this.containerExecLogs.getMessages().stream().anyMatch(m -> m.startsWith("onClose : ")));
        this.b.getExecutor().interrupt();
        this.r.waitForCompletion((Run)this.b);
    }
}

