/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.EnvVars;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.csanchez.jenkins.plugins.kubernetes.ContainerEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.model.KeyValueEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.model.SecretEnvVar;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRuleNonLocalhost;
import org.jvnet.hudson.test.LoggerRule;

public abstract class AbstractKubernetesPipelineTest {
    protected static final String CONTAINER_ENV_VAR_VALUE = "container-env-var-value";
    protected static final String POD_ENV_VAR_VALUE = "pod-env-var-value";
    protected static final String GLOBAL = "GLOBAL";
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    protected KubernetesCloud cloud;
    @Rule
    public JenkinsRuleNonLocalhost r = new JenkinsRuleNonLocalhost();
    @Rule
    public LoggerRule logs = new LoggerRule().recordPackage(KubernetesCloud.class, Level.ALL);
    @Rule
    public TestName name = new TestName();
    private String projectName;
    protected WorkflowJob p;
    protected WorkflowRun b;

    @BeforeClass
    public static void isKubernetesConfigured() throws Exception {
        KubernetesTestUtil.assumeKubernetes();
    }

    @Before
    public void defineProjectName() {
        this.projectName = KubernetesTestUtil.generateProjectName(this.name.getMethodName());
    }

    protected String getProjectName() {
        return this.projectName;
    }

    protected final WorkflowRun createJobThenScheduleRun() throws IOException, ExecutionException, InterruptedException {
        return this.createJobThenScheduleRun(null);
    }

    protected final WorkflowRun createJobThenScheduleRun(Map<String, String> env) throws IOException, ExecutionException, InterruptedException {
        this.b = KubernetesTestUtil.createPipelineJobThenScheduleRun(this.r, this.getClass(), this.name.getMethodName(), env);
        this.p = (WorkflowJob)this.b.getParent();
        return this.b;
    }

    protected final String loadPipelineDefinition() {
        return KubernetesTestUtil.loadPipelineDefinition(this.getClass(), this.name.getMethodName(), null);
    }

    @Before
    public void configureCloud() throws Exception {
        this.cloud = KubernetesTestUtil.setupCloud(this, this.name);
        KubernetesTestUtil.createSecret(this.cloud.connect(), this.cloud.getNamespace());
        this.cloud.getTemplates().clear();
        this.cloud.addTemplate(this.buildBusyboxTemplate("busybox"));
        KubernetesTestUtil.setupHost();
        this.r.jenkins.clouds.add((Object)this.cloud);
        DescribableList list = this.r.jenkins.getGlobalNodeProperties();
        EnvironmentVariablesNodeProperty newEnvVarsNodeProperty = new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[0]);
        list.add((Object)newEnvVarsNodeProperty);
        EnvVars envVars = newEnvVarsNodeProperty.getEnvVars();
        envVars.put(GLOBAL, GLOBAL);
        envVars.put("JAVA_HOME_X", "java-home-x");
        this.r.jenkins.save();
    }

    private PodTemplate buildBusyboxTemplate(String label) {
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setLabel(label);
        ContainerTemplate containerTemplate = new ContainerTemplate("busybox", "busybox", "cat", "");
        containerTemplate.setTtyEnabled(true);
        podTemplate.getContainers().add(containerTemplate);
        AbstractKubernetesPipelineTest.setEnvVariables(podTemplate);
        return podTemplate;
    }

    protected String loadPipelineScript(String name) {
        return KubernetesTestUtil.loadPipelineScript(this.getClass(), name);
    }

    private static void setEnvVariables(PodTemplate podTemplate) {
        SecretEnvVar podSecretEnvVar = new SecretEnvVar("POD_ENV_VAR_FROM_SECRET", "pod-secret", "password");
        KeyValueEnvVar podSimpleEnvVar = new KeyValueEnvVar("POD_ENV_VAR", POD_ENV_VAR_VALUE);
        podTemplate.setEnvVars(Arrays.asList(podSecretEnvVar, podSimpleEnvVar));
        KeyValueEnvVar containerEnvVariable = new KeyValueEnvVar("CONTAINER_ENV_VAR", CONTAINER_ENV_VAR_VALUE);
        ContainerEnvVar containerEnvVariableLegacy = new ContainerEnvVar("CONTAINER_ENV_VAR_LEGACY", CONTAINER_ENV_VAR_VALUE);
        SecretEnvVar containerSecretEnvVariable = new SecretEnvVar("CONTAINER_ENV_VAR_FROM_SECRET", "container-secret", "password");
        ((ContainerTemplate)podTemplate.getContainers().get(0)).setEnvVars(Arrays.asList(containerEnvVariable, containerEnvVariableLegacy, containerSecretEnvVariable));
    }

    protected void createNamespaceIfNotExist(KubernetesClient client, String namespace) {
        if (((Resource)client.namespaces().withName(namespace)).get() == null) {
            client.namespaces().createOrReplace((Object[])new Namespace[]{((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).endMetadata()).build()});
        }
    }
}

