/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.collect.ImmutableMap;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.tools.ToolLocationNodeProperty;
import io.fabric8.kubernetes.api.model.ConfigMapEnvSource;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.SecretEnvSource;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.PortMapping;
import org.csanchez.jenkins.plugins.kubernetes.model.KeyValueEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.model.SecretEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.volumes.HostPathVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PodTemplateUtilsTest {
    private static final PodImagePullSecret SECRET_1 = new PodImagePullSecret("secret1");
    private static final PodImagePullSecret SECRET_2 = new PodImagePullSecret("secret2");
    private static final PodImagePullSecret SECRET_3 = new PodImagePullSecret("secret3");
    private static final PodAnnotation ANNOTATION_1 = new PodAnnotation("key1", "value1");
    private static final PodAnnotation ANNOTATION_2 = new PodAnnotation("key2", "value2");
    private static final PodAnnotation ANNOTATION_3 = new PodAnnotation("key1", "value3");
    private static final ContainerTemplate JNLP_1 = new ContainerTemplate("jnlp", "jnlp:1");
    private static final ContainerTemplate JNLP_2 = new ContainerTemplate("jnlp", "jnlp:2");
    private static final ContainerTemplate MAVEN_1 = new ContainerTemplate("maven", "maven:1", "sh -c", "cat");
    private static final ContainerTemplate MAVEN_2 = new ContainerTemplate("maven", "maven:2");

    @Test
    public void shouldReturnContainerTemplateWhenParentIsNull() {
        ContainerTemplate result = PodTemplateUtils.combine(null, (ContainerTemplate)JNLP_2);
        Assert.assertEquals((Object)result, (Object)JNLP_2);
    }

    @Test
    public void shouldOverrideTheImageAndInheritTheRest() {
        ContainerTemplate result = PodTemplateUtils.combine((ContainerTemplate)MAVEN_1, (ContainerTemplate)MAVEN_2);
        Assert.assertEquals((Object)"maven:2", (Object)result.getImage());
        Assert.assertEquals((Object)"cat", (Object)result.getArgs());
    }

    @Test
    public void shouldReturnPodTemplateWhenParentIsNull() {
        PodTemplate template = new PodTemplate();
        template.setName("template");
        template.setServiceAccount("sa1");
        PodTemplate result = PodTemplateUtils.combine(null, (PodTemplate)template);
        Assert.assertEquals((Object)result, (Object)template);
    }

    @Test
    public void shouldOverrideServiceAccountIfSpecified() {
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setServiceAccount("sa");
        PodTemplate template1 = new PodTemplate();
        template1.setName("template1");
        template1.setServiceAccount("sa1");
        PodTemplate template2 = new PodTemplate();
        template1.setName("template2");
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template1);
        Assert.assertEquals((Object)"sa1", (Object)result.getServiceAccount());
        result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template2);
        Assert.assertEquals((Object)"sa", (Object)result.getServiceAccount());
    }

    @Test
    public void shouldOverrideNodeSelectorIfSpecified() {
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setNodeSelector("key:value");
        PodTemplate template1 = new PodTemplate();
        template1.setName("template1");
        template1.setNodeSelector("key:value1");
        PodTemplate template2 = new PodTemplate();
        template2.setName("template2");
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template1);
        Assert.assertEquals((Object)"key:value1", (Object)result.getNodeSelector());
        result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template2);
        Assert.assertEquals((Object)"key:value", (Object)result.getNodeSelector());
    }

    @Test
    public void shouldCombineAllImagePullSecrets() {
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setNodeSelector("key:value");
        parent.setImagePullSecrets(Arrays.asList(SECRET_1));
        PodTemplate template1 = new PodTemplate();
        template1.setName("template1");
        template1.setImagePullSecrets(Arrays.asList(SECRET_1, SECRET_2, SECRET_3));
        PodTemplate template2 = new PodTemplate();
        template2.setName("template2");
        template2.setImagePullSecrets(Arrays.asList(SECRET_2, SECRET_3));
        PodTemplate template3 = new PodTemplate();
        template3.setName("template3");
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template1);
        Assert.assertEquals((long)3L, (long)result.getImagePullSecrets().size());
        result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template2);
        Assert.assertEquals((long)3L, (long)result.getImagePullSecrets().size());
        result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template3);
        Assert.assertEquals((long)1L, (long)result.getImagePullSecrets().size());
    }

    @Test
    public void shouldCombineAllAnnotations() {
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setNodeSelector("key:value");
        parent.setAnnotations(Arrays.asList(ANNOTATION_1, ANNOTATION_2));
        PodTemplate template1 = new PodTemplate();
        template1.setName("template");
        template1.setAnnotations(Arrays.asList(ANNOTATION_3));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template1);
        Assert.assertEquals((long)2L, (long)result.getAnnotations().size());
        Assert.assertEquals((Object)"value3", (Object)((PodAnnotation)result.getAnnotations().get(0)).getValue().toString());
    }

    @Test
    public void shouldCombineAllLabels() {
        Pod pod1 = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withLabels((Map)ImmutableMap.of((Object)"label1", (Object)"pod1", (Object)"label2", (Object)"pod1"))).endMetadata()).withNewSpec().endSpec()).build();
        Pod pod2 = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withLabels((Map)ImmutableMap.of((Object)"label1", (Object)"pod2", (Object)"label3", (Object)"pod2"))).endMetadata()).withNewSpec().endSpec()).build();
        Map labels = PodTemplateUtils.combine((Pod)pod1, (Pod)pod2).getMetadata().getLabels();
        Assert.assertThat((Object)labels, (Matcher)Matchers.hasEntry((Object)"label1", (Object)"pod2"));
        Assert.assertThat((Object)labels, (Matcher)Matchers.hasEntry((Object)"label2", (Object)"pod1"));
        Assert.assertThat((Object)labels, (Matcher)Matchers.hasEntry((Object)"label3", (Object)"pod2"));
    }

    @Test
    public void shouldUnwrapParent() {
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setLabel("parent");
        parent.setServiceAccount("sa");
        parent.setNodeSelector("key:value");
        parent.setImagePullSecrets(Arrays.asList(SECRET_1));
        parent.setYaml("Yaml");
        PodTemplate template1 = new PodTemplate();
        template1.setName("template1");
        template1.setInheritFrom("parent");
        template1.setServiceAccount("sa1");
        template1.setImagePullSecrets(Arrays.asList(SECRET_2, SECRET_3));
        template1.setYaml("Yaml2");
        PodTemplate result = PodTemplateUtils.unwrap((PodTemplate)template1, Arrays.asList(parent, template1));
        Assert.assertEquals((long)3L, (long)result.getImagePullSecrets().size());
        Assert.assertEquals((Object)"sa1", (Object)result.getServiceAccount());
        Assert.assertEquals((Object)"key:value", (Object)result.getNodeSelector());
        Assert.assertThat((Object)result.getYamls(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)result.getYamls(), (Matcher)Matchers.contains((Object[])new String[]{"Yaml", "Yaml2"}));
    }

    @Test
    public void shouldDropNoDataWhenIdentical() {
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setName("Name");
        podTemplate.setNamespace("NameSpace");
        podTemplate.setLabel("Label");
        podTemplate.setServiceAccount("ServiceAccount");
        podTemplate.setNodeSelector("NodeSelector");
        podTemplate.setNodeUsageMode(Node.Mode.EXCLUSIVE);
        podTemplate.setImagePullSecrets(Arrays.asList(SECRET_1));
        podTemplate.setInheritFrom("Inherit");
        podTemplate.setInstanceCap(99);
        podTemplate.setSlaveConnectTimeout(99);
        podTemplate.setIdleMinutes(99);
        podTemplate.setActiveDeadlineSeconds(99);
        podTemplate.setServiceAccount("ServiceAccount");
        podTemplate.setYaml("Yaml");
        PodTemplate selfCombined = PodTemplateUtils.combine((PodTemplate)podTemplate, (PodTemplate)podTemplate);
        Assert.assertEquals((Object)"Name", (Object)selfCombined.getName());
        Assert.assertEquals((Object)"NameSpace", (Object)selfCombined.getNamespace());
        Assert.assertEquals((Object)"Label", (Object)selfCombined.getLabel());
        Assert.assertEquals((Object)"ServiceAccount", (Object)selfCombined.getServiceAccount());
        Assert.assertEquals((Object)"NodeSelector", (Object)selfCombined.getNodeSelector());
        Assert.assertEquals((Object)Node.Mode.EXCLUSIVE, (Object)selfCombined.getNodeUsageMode());
        Assert.assertEquals(Arrays.asList(SECRET_1), (Object)selfCombined.getImagePullSecrets());
        Assert.assertEquals((Object)"Inherit", (Object)selfCombined.getInheritFrom());
        Assert.assertEquals((long)99L, (long)selfCombined.getInstanceCap());
        Assert.assertEquals((long)99L, (long)selfCombined.getSlaveConnectTimeout());
        Assert.assertEquals((long)99L, (long)selfCombined.getIdleMinutes());
        Assert.assertEquals((long)99L, (long)selfCombined.getActiveDeadlineSeconds());
        Assert.assertEquals((Object)"ServiceAccount", (Object)selfCombined.getServiceAccount());
        Assert.assertThat((Object)selfCombined.getYamls(), (Matcher)Matchers.hasItems((Object[])new String[]{"Yaml", "Yaml"}));
    }

    @Test
    public void shouldUnwrapMultipleParents() {
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setLabel("parent");
        parent.setServiceAccount("sa");
        parent.setNodeSelector("key:value");
        parent.setImagePullSecrets(Arrays.asList(SECRET_1));
        parent.setContainers(Arrays.asList(JNLP_1, MAVEN_2));
        PodTemplate template1 = new PodTemplate();
        template1.setName("template1");
        template1.setLabel("template1");
        template1.setInheritFrom("parent");
        template1.setServiceAccount("sa1");
        template1.setImagePullSecrets(Arrays.asList(SECRET_2));
        template1.setContainers(Arrays.asList(JNLP_2));
        PodTemplate template2 = new PodTemplate();
        template2.setName("template2");
        template2.setLabel("template2");
        template2.setImagePullSecrets(Arrays.asList(SECRET_3));
        template2.setContainers(Arrays.asList(MAVEN_2));
        PodTemplate toUnwrap = new PodTemplate();
        toUnwrap.setName("toUnwrap");
        toUnwrap.setInheritFrom("template1 template2");
        PodTemplate result = PodTemplateUtils.unwrap((PodTemplate)toUnwrap, Arrays.asList(parent, template1, template2));
        Assert.assertEquals((long)3L, (long)result.getImagePullSecrets().size());
        Assert.assertEquals((Object)"sa1", (Object)result.getServiceAccount());
        Assert.assertEquals((Object)"key:value", (Object)result.getNodeSelector());
        Assert.assertEquals((long)2L, (long)result.getContainers().size());
        ContainerTemplate mavenTemplate = result.getContainers().stream().filter(c -> c.getName().equals("maven")).findFirst().orElse(null);
        Assert.assertNotNull((Object)mavenTemplate);
        Assert.assertEquals((Object)"maven:2", (Object)mavenTemplate.getImage());
    }

    @Test
    public void shouldCombineAllPodKeyValueEnvVars() {
        PodTemplate template1 = new PodTemplate();
        KeyValueEnvVar podEnvVar1 = new KeyValueEnvVar("key-1", "value-1");
        template1.setEnvVars(Collections.singletonList(podEnvVar1));
        PodTemplate template2 = new PodTemplate();
        KeyValueEnvVar podEnvVar2 = new KeyValueEnvVar("key-2", "value-2");
        KeyValueEnvVar podEnvVar3 = new KeyValueEnvVar("key-3", "value-3");
        template2.setEnvVars(Arrays.asList(podEnvVar2, podEnvVar3));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)template1, (PodTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.contains((Object[])new TemplateEnvVar[]{podEnvVar1, podEnvVar2, podEnvVar3}));
    }

    @Test
    public void shouldFilterOutNullOrEmptyPodKeyValueEnvVars() {
        PodTemplate template1 = new PodTemplate();
        KeyValueEnvVar podEnvVar1 = new KeyValueEnvVar("", "value-1");
        template1.setEnvVars(Collections.singletonList(podEnvVar1));
        PodTemplate template2 = new PodTemplate();
        KeyValueEnvVar podEnvVar2 = new KeyValueEnvVar(null, "value-2");
        template2.setEnvVars(Collections.singletonList(podEnvVar2));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)template1, (PodTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldCombineAllPodSecretEnvVars() {
        PodTemplate template1 = new PodTemplate();
        SecretEnvVar podSecretEnvVar1 = new SecretEnvVar("key-1", "secret-1", "secret-key-1");
        template1.setEnvVars(Collections.singletonList(podSecretEnvVar1));
        PodTemplate template2 = new PodTemplate();
        SecretEnvVar podSecretEnvVar2 = new SecretEnvVar("key-2", "secret-2", "secret-key-2");
        SecretEnvVar podSecretEnvVar3 = new SecretEnvVar("key-3", "secret-3", "secret-key-3");
        template2.setEnvVars(Arrays.asList(podSecretEnvVar2, podSecretEnvVar3));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)template1, (PodTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.contains((Object[])new TemplateEnvVar[]{podSecretEnvVar1, podSecretEnvVar2, podSecretEnvVar3}));
    }

    @Test
    public void shouldFilterOutNullOrEmptyPodSecretEnvVars() {
        PodTemplate template1 = new PodTemplate();
        SecretEnvVar podSecretEnvVar1 = new SecretEnvVar("", "secret-1", "secret-key-1");
        template1.setEnvVars(Collections.singletonList(podSecretEnvVar1));
        PodTemplate template2 = new PodTemplate();
        SecretEnvVar podSecretEnvVar2 = new SecretEnvVar(null, "secret-2", "secret-key-2");
        template2.setEnvVars(Collections.singletonList(podSecretEnvVar2));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)template1, (PodTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldCombineAllEnvVars() {
        ContainerTemplate template1 = new ContainerTemplate("name-1", "image-1");
        KeyValueEnvVar containerEnvVar1 = new KeyValueEnvVar("key-1", "value-1");
        template1.setEnvVars(Collections.singletonList(containerEnvVar1));
        ContainerTemplate template2 = new ContainerTemplate("name-2", "image-2");
        KeyValueEnvVar containerEnvVar2 = new KeyValueEnvVar("key-2", "value-2");
        KeyValueEnvVar containerEnvVar3 = new KeyValueEnvVar("key-3", "value-3");
        template2.setEnvVars(Arrays.asList(containerEnvVar2, containerEnvVar3));
        ContainerTemplate result = PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.contains((Object[])new TemplateEnvVar[]{containerEnvVar1, containerEnvVar2, containerEnvVar3}));
    }

    @Test
    public void shouldFilterOutNullOrEmptyEnvVars() {
        ContainerTemplate template1 = new ContainerTemplate("name-1", "image-1");
        KeyValueEnvVar containerEnvVar1 = new KeyValueEnvVar("", "value-1");
        template1.setEnvVars(Collections.singletonList(containerEnvVar1));
        ContainerTemplate template2 = new ContainerTemplate("name-2", "image-2");
        KeyValueEnvVar containerEnvVar2 = new KeyValueEnvVar(null, "value-2");
        template2.setEnvVars(Collections.singletonList(containerEnvVar2));
        ContainerTemplate result = PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldCombineAllSecretEnvVars() {
        ContainerTemplate template1 = new ContainerTemplate("name-1", "image-1");
        SecretEnvVar containerSecretEnvVar1 = new SecretEnvVar("key-1", "secret-1", "secret-key-1");
        template1.setEnvVars(Collections.singletonList(containerSecretEnvVar1));
        ContainerTemplate template2 = new ContainerTemplate("name-2", "image-2");
        SecretEnvVar containerSecretEnvVar2 = new SecretEnvVar("key-2", "secret-2", "secret-key-2");
        SecretEnvVar containerSecretEnvVar3 = new SecretEnvVar("key-3", "secret-3", "secret-key-3");
        template2.setEnvVars(Arrays.asList(containerSecretEnvVar2, containerSecretEnvVar3));
        ContainerTemplate result = PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.contains((Object[])new TemplateEnvVar[]{containerSecretEnvVar1, containerSecretEnvVar2, containerSecretEnvVar3}));
    }

    @Test
    public void shouldCombineAllEnvFromSourcesWithoutChangingOrder() {
        EnvFromSource configMap1 = new EnvFromSource(new ConfigMapEnvSource("config-map-1", Boolean.valueOf(false)), null, null);
        EnvFromSource secret1 = new EnvFromSource(null, null, new SecretEnvSource("secret-1", Boolean.valueOf(false)));
        EnvFromSource configMap2 = new EnvFromSource(new ConfigMapEnvSource("config-map-2", Boolean.valueOf(true)), null, null);
        EnvFromSource secret2 = new EnvFromSource(null, null, new SecretEnvSource("secret-2", Boolean.valueOf(true)));
        Container container1 = new Container();
        container1.setEnvFrom(Arrays.asList(configMap1, secret1));
        Container container2 = new Container();
        container2.setEnvFrom(Arrays.asList(configMap2, secret2));
        Container result = PodTemplateUtils.combine((Container)container1, (Container)container2);
        Assert.assertThat((Object)result.getEnvFrom(), (Matcher)Matchers.contains((Object[])new EnvFromSource[]{configMap1, secret1, configMap2, secret2}));
    }

    @Test
    public void shouldFilterOutEnvFromSourcesWithNullOrEmptyKey() {
        EnvFromSource noSource = new EnvFromSource(null, null, null);
        EnvFromSource noConfigMapKey = new EnvFromSource(new ConfigMapEnvSource(null, Boolean.valueOf(false)), null, null);
        EnvFromSource emptyConfigMapKey = new EnvFromSource(new ConfigMapEnvSource("", Boolean.valueOf(false)), null, null);
        EnvFromSource noSecretKey = new EnvFromSource(null, null, new SecretEnvSource(null, Boolean.valueOf(false)));
        EnvFromSource emptySecretKey = new EnvFromSource(null, null, new SecretEnvSource("", Boolean.valueOf(false)));
        Container container = new Container();
        container.setEnvFrom(Arrays.asList(noSource, noConfigMapKey, emptyConfigMapKey, noSecretKey, emptySecretKey));
        Container result = PodTemplateUtils.combine((Container)container, (Container)new Container());
        Assert.assertEquals((long)0L, (long)result.getEnvFrom().size());
    }

    @Test
    public void shouldCombineAllMounts() {
        PodTemplate template1 = new PodTemplate();
        HostPathVolume hostPathVolume1 = new HostPathVolume("/host/mnt1", "/container/mnt1");
        HostPathVolume hostPathVolume2 = new HostPathVolume("/host/mnt2", "/container/mnt2");
        template1.setVolumes(Arrays.asList(hostPathVolume1, hostPathVolume2));
        PodTemplate template2 = new PodTemplate();
        HostPathVolume hostPathVolume3 = new HostPathVolume("/host/mnt3", "/container/mnt3");
        HostPathVolume hostPathVolume4 = new HostPathVolume("/host/mnt1", "/container/mnt4");
        template2.setVolumes(Arrays.asList(hostPathVolume3, hostPathVolume4));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)template1, (PodTemplate)template2);
        Assert.assertThat((Object)result.getVolumes(), (Matcher)Matchers.containsInAnyOrder((Object[])new PodVolume[]{hostPathVolume1, hostPathVolume2, hostPathVolume3, hostPathVolume4}));
    }

    private PodFluent.SpecNested<PodBuilder> podBuilder() {
        return ((PodBuilder)new PodBuilder().withNewMetadata().endMetadata()).withNewSpec();
    }

    private ContainerBuilder containerBuilder() {
        return (ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)new ContainerBuilder().withNewSecurityContext().endSecurityContext()).withNewResources().withLimits((Map)ImmutableMap.of((Object)"cpu", (Object)new Quantity(), (Object)"memory", (Object)new Quantity()))).withRequests((Map)ImmutableMap.of((Object)"cpu", (Object)new Quantity(), (Object)"memory", (Object)new Quantity()))).endResources();
    }

    @Test
    public void shouldCombineAllPodMounts() {
        VolumeMount vm1 = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/host/mnt1")).withName("volume-1")).withReadOnly(Boolean.valueOf(false))).build();
        VolumeMount vm2 = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/host/mnt2")).withName("volume-2")).withReadOnly(Boolean.valueOf(false))).build();
        VolumeMount vm3 = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/host/mnt3")).withName("volume-3")).withReadOnly(Boolean.valueOf(false))).build();
        VolumeMount vm4 = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/host/mnt1")).withName("volume-4")).withReadOnly(Boolean.valueOf(false))).build();
        Container container1 = ((ContainerBuilder)((ContainerBuilder)this.containerBuilder().withName("jnlp")).withVolumeMounts(new VolumeMount[]{vm1, vm2})).build();
        Pod pod1 = ((PodBuilder)((PodFluent.SpecNested)this.podBuilder().withContainers(new Container[]{container1})).endSpec()).build();
        Container container2 = ((ContainerBuilder)((ContainerBuilder)this.containerBuilder().withName("jnlp")).withVolumeMounts(new VolumeMount[]{vm3, vm4})).build();
        Pod pod2 = ((PodBuilder)((PodFluent.SpecNested)this.podBuilder().withContainers(new Container[]{container2})).endSpec()).build();
        Pod result = PodTemplateUtils.combine((Pod)pod1, (Pod)pod2);
        List containers = result.getSpec().getContainers();
        Assert.assertEquals((long)1L, (long)containers.size());
        Assert.assertEquals((long)3L, (long)((Container)containers.get(0)).getVolumeMounts().size());
        Assert.assertThat((Object)((Container)containers.get(0)).getVolumeMounts(), (Matcher)Matchers.containsInAnyOrder((Object[])new VolumeMount[]{vm2, vm3, vm4}));
    }

    @Test
    public void shouldCombineAllTolerations() {
        PodSpec podSpec1 = new PodSpec();
        Pod pod1 = new Pod();
        Toleration toleration1 = new Toleration("effect1", "key1", "oper1", Long.valueOf(Long.parseLong("1")), "val1");
        Toleration toleration2 = new Toleration("effect2", "key2", "oper2", Long.valueOf(Long.parseLong("2")), "val2");
        podSpec1.setTolerations(Arrays.asList(toleration1, toleration2));
        pod1.setSpec(podSpec1);
        pod1.setMetadata(new ObjectMeta());
        PodSpec podSpec2 = new PodSpec();
        Pod pod2 = new Pod();
        Toleration toleration3 = new Toleration("effect3", "key3", "oper3", Long.valueOf(Long.parseLong("3")), "val3");
        Toleration toleration4 = new Toleration("effect4", "key4", "oper4", Long.valueOf(Long.parseLong("4")), "val4");
        podSpec2.setTolerations(Arrays.asList(toleration3, toleration4));
        pod2.setSpec(podSpec2);
        pod2.setMetadata(new ObjectMeta());
        Pod result = PodTemplateUtils.combine((Pod)pod1, (Pod)pod2);
        Assert.assertThat((Object)result.getSpec().getTolerations(), (Matcher)Matchers.containsInAnyOrder((Object[])new Toleration[]{toleration1, toleration2, toleration3, toleration4}));
    }

    @Test
    public void shouldCombineAllPorts() {
        ContainerTemplate template1 = new ContainerTemplate("name-1", "image-1");
        PortMapping port1 = new PortMapping("port-1", Integer.valueOf(1000), Integer.valueOf(1000));
        template1.setPorts(Arrays.asList(port1));
        ContainerTemplate template2 = new ContainerTemplate("name-2", "image-2");
        Assert.assertThat((Object)PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2).getPorts(), (Matcher)Matchers.contains((Object[])new PortMapping[]{port1}));
        PortMapping port2 = new PortMapping("port-2", Integer.valueOf(2000), Integer.valueOf(2000));
        template2.setPorts(Arrays.asList(port2));
        Assert.assertThat((Object)PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2).getPorts(), (Matcher)Matchers.containsInAnyOrder((Object[])new PortMapping[]{port1, port2}));
        port2.setName("port-1");
        Assert.assertThat((Object)PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2).getPorts(), (Matcher)Matchers.contains((Object[])new PortMapping[]{port2}));
    }

    public void shouldCombineAllResources() {
        Container container1 = new Container();
        container1.setResources(((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToLimits("cpu", new Quantity("1"))).addToLimits("memory", new Quantity("1Gi"))).addToRequests("cpu", new Quantity("100m"))).addToRequests("memory", new Quantity("156Mi"))).build());
        Container container2 = new Container();
        container2.setResources(((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToLimits("cpu", new Quantity("2"))).addToLimits("memory", new Quantity("2Gi"))).addToRequests("cpu", new Quantity("200m"))).addToRequests("memory", new Quantity("256Mi"))).build());
        Container result = PodTemplateUtils.combine((Container)container1, (Container)container2);
        Assert.assertEquals((Object)new Quantity("2"), result.getResources().getLimits().get("cpu"));
        Assert.assertEquals((Object)new Quantity("2Gi"), result.getResources().getLimits().get("memory"));
        Assert.assertEquals((Object)new Quantity("200m"), result.getResources().getRequests().get("cpu"));
        Assert.assertEquals((Object)new Quantity("256Mi"), result.getResources().getRequests().get("memory"));
    }

    @Test
    public void shouldFilterOutNullOrEmptySecretEnvVars() {
        ContainerTemplate template1 = new ContainerTemplate("name-1", "image-1");
        SecretEnvVar containerSecretEnvVar1 = new SecretEnvVar("", "secret-1", "secret-key-1");
        template1.setEnvVars(Collections.singletonList(containerSecretEnvVar1));
        ContainerTemplate template2 = new ContainerTemplate("name-2", "image-2");
        SecretEnvVar containerSecretEnvVar2 = new SecretEnvVar(null, "secret-2", "secret-key-2");
        template2.setEnvVars(Collections.singletonList(containerSecretEnvVar2));
        ContainerTemplate result = PodTemplateUtils.combine((ContainerTemplate)template1, (ContainerTemplate)template2);
        Assert.assertThat((Object)result.getEnvVars(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldIgnoreMissingProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        Assert.assertEquals((Object)"${key2}", (Object)PodTemplateUtils.substitute((String)"${key2}", properties));
    }

    @Test
    public void shouldSubstituteSingleEnvVar() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        Assert.assertEquals((Object)"value1", (Object)PodTemplateUtils.substitute((String)"${key1}", properties));
    }

    @Test
    public void shouldSubstituteMultipleEnvVars() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        Assert.assertEquals((Object)"value1 or value2", (Object)PodTemplateUtils.substitute((String)"${key1} or ${key2}", properties));
    }

    @Test
    public void shouldSubstituteMultipleEnvVarsAndIgnoreMissing() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        Assert.assertEquals((Object)"value1 or value2 or ${key3}", (Object)PodTemplateUtils.substitute((String)"${key1} or ${key2} or ${key3}", properties));
    }

    @Test
    public void shouldSubstituteMultipleEnvVarsAndNotUseDefaultsForMissing() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        Assert.assertEquals((Object)"value1 or value2 or ${key3}", (Object)PodTemplateUtils.substitute((String)"${key1} or ${key2} or ${key3}", properties, (String)"defaultValue"));
    }

    @Test
    public void testValidateLabelA() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"1"));
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"a"));
    }

    @Test
    public void testValidateLabelAb() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"12"));
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"ab"));
    }

    @Test
    public void testValidateLabelAbc() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"123"));
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"abc"));
    }

    @Test
    public void testValidateLabelAbcd() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"1234"));
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"abcd"));
    }

    @Test
    public void testValidateLabelMypod() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"mypod"));
    }

    @Test
    public void testValidateLabelMyPodNested() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"mypodNested"));
    }

    @Test
    public void testValidateLabelSpecialChars() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"x-_.z"));
        Assert.assertFalse((boolean)PodTemplateUtils.validateLabel((String)"one two"));
    }

    @Test
    public void testValidateLabelStartWithSpecialChars() {
        Assert.assertFalse((boolean)PodTemplateUtils.validateLabel((String)"-x"));
    }

    @Test
    public void testValidateLabelLong() {
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"123456789012345678901234567890123456789012345678901234567890123"));
        Assert.assertTrue((boolean)PodTemplateUtils.validateLabel((String)"abcdefghijklmnopqrstuwxyzabcdefghijklmnopqrstuwxyzabcdefghijklm"));
    }

    @Test
    public void testValidateLabelTooLong() {
        Assert.assertFalse((boolean)PodTemplateUtils.validateLabel((String)"1234567890123456789012345678901234567890123456789012345678901234"));
        Assert.assertFalse((boolean)PodTemplateUtils.validateLabel((String)"abcdefghijklmnopqrstuwxyzabcdefghijklmnopqrstuwxyzabcdefghijklmn"));
    }

    @Test
    public void shouldCombineAllToolLocations() {
        PodTemplate podTemplate1 = new PodTemplate();
        ArrayList<ToolLocationNodeProperty> nodeProperties1 = new ArrayList<ToolLocationNodeProperty>();
        nodeProperties1.add(new ToolLocationNodeProperty(new ToolLocationNodeProperty.ToolLocation[]{new ToolLocationNodeProperty.ToolLocation("toolKey1@Test", "toolHome1")}));
        podTemplate1.setNodeProperties(nodeProperties1);
        PodTemplate podTemplate2 = new PodTemplate();
        ArrayList<ToolLocationNodeProperty> nodeProperties2 = new ArrayList<ToolLocationNodeProperty>();
        nodeProperties2.add(new ToolLocationNodeProperty(new ToolLocationNodeProperty.ToolLocation[]{new ToolLocationNodeProperty.ToolLocation("toolKey2@Test", "toolHome2")}));
        podTemplate2.setNodeProperties(nodeProperties2);
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)podTemplate1, (PodTemplate)podTemplate2);
        Assert.assertThat((Object)result.getNodeProperties(), (Matcher)Matchers.hasItems((Object[])new NodeProperty[]{(NodeProperty)nodeProperties1.get(0), (NodeProperty)nodeProperties2.get(0)}));
    }

    @Test
    public void testParseYaml() {
        PodTemplateUtils.parseFromYaml((String)"{}");
        PodTemplateUtils.parseFromYaml(null);
        PodTemplateUtils.parseFromYaml((String)"");
    }
}

