/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.util.XStream2;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PodTemplateTest {
    @Test
    public void getYamlsExposesSingleYamlField() {
        PodTemplate podTemplate = new PodTemplate();
        Assert.assertThat((Object)podTemplate.getYamls(), (Matcher)Matchers.empty());
        podTemplate.setYamls(null);
        Assert.assertThat((Object)podTemplate.getYamls(), (Matcher)Matchers.empty());
        podTemplate.setYaml("yaml");
        Assert.assertThat((Object)podTemplate.getYamls(), (Matcher)Matchers.contains((Object[])new String[]{"yaml"}));
        podTemplate.setYaml(null);
        Assert.assertThat((Object)podTemplate.getYamls(), (Matcher)Matchers.empty());
    }

    @Test
    public void copyConstructor() throws Exception {
        XStream2 xs = new XStream2();
        PodTemplate pt = new PodTemplate();
        Assert.assertEquals((Object)xs.toXML((Object)pt), (Object)xs.toXML((Object)new PodTemplate(pt)));
        pt.setActiveDeadlineSeconds(99);
        Assert.assertEquals((Object)xs.toXML((Object)pt), (Object)xs.toXML((Object)new PodTemplate(pt)));
        pt.setIdleMinutes(99);
        Assert.assertEquals((Object)xs.toXML((Object)pt), (Object)xs.toXML((Object)new PodTemplate(pt)));
    }

    @Test
    public void sanitizeLabels() {
        Assert.assertEquals((Object)"label1", (Object)PodTemplate.sanitizeLabel((String)"label1"));
        Assert.assertEquals((Object)"label1_label2", (Object)PodTemplate.sanitizeLabel((String)"label1 label2"));
        Assert.assertEquals((Object)"el1_label2_verylooooooooooooooooooooooooooooonglabelover63chars", (Object)PodTemplate.sanitizeLabel((String)"label1 label2 verylooooooooooooooooooooooooooooonglabelover63chars"));
        Assert.assertEquals((Object)"xfoo_bar", (Object)PodTemplate.sanitizeLabel((String)":foo:bar"));
        Assert.assertEquals((Object)"xfoo_barx", (Object)PodTemplate.sanitizeLabel((String)":foo:bar:"));
        Assert.assertEquals((Object)"l2_verylooooooooooooooooooooooooooooonglabelendinginunderscorex", (Object)PodTemplate.sanitizeLabel((String)"label1 label2 verylooooooooooooooooooooooooooooonglabelendinginunderscore_"));
    }
}

