/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import java.io.IOException;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class PodTemplateMapTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private PodTemplateMap instance;
    private KubernetesCloud cloud;

    @Before
    public void setUp() throws IOException {
        this.instance = PodTemplateMap.get();
        this.cloud = new KubernetesCloud("kubernetes");
        this.j.jenkins.clouds.add((Object)this.cloud);
        this.j.jenkins.save();
    }

    @Test
    public void concurrentAdds() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.instance.getTemplates(this.cloud).size());
        int n = 10;
        Thread[] t = new Thread[n];
        for (i = 0; i < t.length; ++i) {
            t[i] = this.newThread(i);
        }
        for (i = 0; i < t.length; ++i) {
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        Assert.assertEquals((long)n, (long)this.instance.getTemplates(this.cloud).size());
    }

    private Thread newThread(int i) {
        String name = "test-" + i;
        return new Thread(() -> this.instance.addTemplate(this.cloud, this.buildPodTemplate(name)), name);
    }

    private PodTemplate buildPodTemplate(String label) {
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setLabel(label);
        return podTemplate;
    }
}

