/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.model.Label;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateFilter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;

public class PodTemplateFilterTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();

    @Test
    public void multipleFilters() {
        ArrayList<PodTemplate> podtemplates = new ArrayList<PodTemplate>();
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setLabel("label");
        podtemplates.add(podTemplate);
        List result = PodTemplateFilter.applyAll(null, podtemplates, (Label)Label.get((String)"label"));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertThat((Object)((PodTemplate)result.get(0)).getYamls(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"yaml1", "yaml2"}));
    }

    private static PodTemplate addYaml(@Nonnull PodTemplate podTemplate, String yaml) {
        PodTemplate result = new PodTemplate(podTemplate);
        ArrayList<String> yamls = new ArrayList<String>(result.getYamls());
        yamls.add(yaml);
        result.setYamls(yamls);
        return result;
    }

    @TestExtension
    public static class PodTemplateFilter2
    extends PodTemplateFilter {
        @CheckForNull
        protected PodTemplate transform(@Nonnull KubernetesCloud cloud, @Nonnull PodTemplate podTemplate, @CheckForNull Label label) {
            return PodTemplateFilterTest.addYaml(podTemplate, "yaml2");
        }
    }

    @TestExtension
    public static class PodTemplateFilter1
    extends PodTemplateFilter {
        @CheckForNull
        protected PodTemplate transform(@Nonnull KubernetesCloud cloud, @Nonnull PodTemplate podTemplate, @CheckForNull Label label) {
            return PodTemplateFilterTest.addYaml(podTemplate, "yaml1");
        }
    }
}

