/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import junitparams.naming.TestCaseName;
import org.apache.commons.compress.utils.IOUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateBuilder;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.model.KeyValueEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.pod.yaml.Merge;
import org.csanchez.jenkins.plugins.kubernetes.pod.yaml.YamlMergeStrategy;
import org.csanchez.jenkins.plugins.kubernetes.volumes.EmptyDirVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.HostPathVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.DynamicPVCWorkspaceVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.EmptyDirWorkspaceVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnitParamsRunner.class)
public class PodTemplateBuilderTest {
    private static final String AGENT_NAME = "jenkins-agent";
    private static final String AGENT_SECRET = "xxx";
    private static final String JENKINS_URL = "http://jenkins.example.com";
    private static final String JENKINS_PROTOCOLS = "JNLP4-connect";
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Rule
    public LoggerRule logs = new LoggerRule().record(Logger.getLogger(KubernetesCloud.class.getPackage().getName()), Level.ALL);
    @Spy
    private KubernetesCloud cloud = new KubernetesCloud("test");
    @Mock
    private KubernetesSlave slave;
    @Mock
    private KubernetesComputer computer;

    @Test
    public void testParseDockerCommand() {
        Assert.assertNull((Object)PodTemplateBuilder.parseDockerCommand((String)""));
        Assert.assertNull((Object)PodTemplateBuilder.parseDockerCommand(null));
        Assert.assertEquals((Object)ImmutableList.of((Object)"bash"), (Object)PodTemplateBuilder.parseDockerCommand((String)"bash"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"bash", (Object)"-c", (Object)"x y"), (Object)PodTemplateBuilder.parseDockerCommand((String)"bash -c \"x y\""));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)PodTemplateBuilder.parseDockerCommand((String)"a b c d"));
    }

    @Test
    public void testParseLivenessProbe() {
        Assert.assertNull((Object)PodTemplateBuilder.parseLivenessProbe((String)""));
        Assert.assertNull((Object)PodTemplateBuilder.parseLivenessProbe(null));
        Assert.assertEquals((Object)ImmutableList.of((Object)"docker", (Object)"info"), (Object)PodTemplateBuilder.parseLivenessProbe((String)"docker info"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"echo", (Object)"I said: 'I am alive'"), (Object)PodTemplateBuilder.parseLivenessProbe((String)"echo \"I said: 'I am alive'\""));
        Assert.assertEquals((Object)ImmutableList.of((Object)"docker", (Object)"--version"), (Object)PodTemplateBuilder.parseLivenessProbe((String)"docker --version"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"curl", (Object)"-k", (Object)"--silent", (Object)"--output=/dev/null", (Object)"https://localhost:8080"), (Object)PodTemplateBuilder.parseLivenessProbe((String)"curl -k --silent --output=/dev/null \"https://localhost:8080\""));
    }

    @Test
    @TestCaseName(value="{method}(directConnection={0})")
    @Parameters(value={"true", "false"})
    public void testBuildWithoutSlave(boolean directConnection) throws Exception {
        this.cloud.setDirectConnection(directConnection);
        this.slave = null;
        PodTemplate template = new PodTemplate();
        String yaml = this.loadYamlFile("pod-busybox.yaml");
        template.setYaml(yaml);
        Assert.assertEquals((Object)yaml, (Object)template.getYaml());
        template.setRunAsGroup("");
        template.setRunAsUser("");
        template.setSupplementalGroups("");
        Pod pod = new PodTemplateBuilder(template).build();
        this.validatePod(pod, directConnection);
        Assert.assertNull((Object)pod.getSpec().getSecurityContext().getRunAsUser());
        Assert.assertNull((Object)pod.getSpec().getSecurityContext().getRunAsGroup());
        Assert.assertEquals(new ArrayList(), (Object)pod.getSpec().getSecurityContext().getSupplementalGroups());
    }

    @Test
    @TestCaseName(value="{method}(directConnection={0})")
    @Parameters(value={"true", "false"})
    public void testBuildFromYaml(boolean directConnection) throws Exception {
        this.cloud.setDirectConnection(directConnection);
        PodTemplate template = new PodTemplate();
        template.setYaml(this.loadYamlFile("pod-busybox.yaml"));
        this.setupStubs();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        this.validatePod(pod, directConnection);
        Assert.assertThat((Object)pod.getMetadata().getLabels(), (Matcher)Matchers.hasEntry((Object)"jenkins", (Object)"slave"));
        Map<String, Container> containers = this.toContainerMap(pod);
        Assert.assertEquals((long)2L, (long)containers.size());
        Container container0 = containers.get("busybox");
        Assert.assertNotNull((Object)container0.getResources());
        Assert.assertNotNull((Object)container0.getResources().getRequests());
        Assert.assertNotNull((Object)container0.getResources().getLimits());
        Assert.assertThat((Object)container0.getResources().getRequests(), (Matcher)Matchers.hasEntry((Object)"example.com/dongle", (Object)new Quantity("42")));
        Assert.assertThat((Object)container0.getResources().getLimits(), (Matcher)Matchers.hasEntry((Object)"example.com/dongle", (Object)new Quantity("42")));
    }

    @Test
    public void testBuildWithCustomWorkspaceVolume() throws Exception {
        PodTemplate template = new PodTemplate();
        template.setWorkspaceVolume((WorkspaceVolume)new EmptyDirWorkspaceVolume(Boolean.valueOf(true)));
        ContainerTemplate containerTemplate = new ContainerTemplate("name", "image");
        containerTemplate.setWorkingDir("");
        template.getContainers().add(containerTemplate);
        this.setupStubs();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        List containers = pod.getSpec().getContainers();
        Assert.assertEquals((long)2L, (long)containers.size());
        Container container0 = (Container)containers.get(0);
        Container container1 = (Container)containers.get(1);
        ImmutableList volumeMounts = ImmutableList.of((Object)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/home/jenkins/agent")).withName("workspace-volume")).withReadOnly(Boolean.valueOf(false))).build());
        Assert.assertEquals((Object)volumeMounts, (Object)container0.getVolumeMounts());
        Assert.assertEquals((Object)volumeMounts, (Object)container1.getVolumeMounts());
        Assert.assertEquals((Object)"Memory", (Object)((Volume)pod.getSpec().getVolumes().get(0)).getEmptyDir().getMedium());
    }

    @Test
    public void testBuildWithDynamicPVCWorkspaceVolume() {
        PodTemplate template = new PodTemplate();
        template.setWorkspaceVolume((WorkspaceVolume)new DynamicPVCWorkspaceVolume(null, null, null));
        ContainerTemplate containerTemplate = new ContainerTemplate("name", "image");
        containerTemplate.setWorkingDir("");
        template.getContainers().add(containerTemplate);
        this.setupStubs();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        List containers = pod.getSpec().getContainers();
        Assert.assertEquals((long)2L, (long)containers.size());
        Container container0 = (Container)containers.get(0);
        Container container1 = (Container)containers.get(1);
        ImmutableList volumeMounts = ImmutableList.of((Object)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/home/jenkins/agent")).withName("workspace-volume")).withReadOnly(Boolean.valueOf(false))).build());
        Assert.assertEquals((Object)volumeMounts, (Object)container0.getVolumeMounts());
        Assert.assertEquals((Object)volumeMounts, (Object)container1.getVolumeMounts());
        Assert.assertNotNull((Object)((Volume)pod.getSpec().getVolumes().get(0)).getPersistentVolumeClaim());
    }

    @Test
    @TestCaseName(value="{method}(directConnection={0})")
    @Parameters(value={"true", "false"})
    public void testBuildFromTemplate(boolean directConnection) throws Exception {
        this.cloud.setDirectConnection(directConnection);
        PodTemplate template = new PodTemplate();
        template.setRunAsUser("1000");
        template.setRunAsGroup("1000");
        template.setSupplementalGroups("5001,5002");
        template.setHostNetwork(Boolean.valueOf(false));
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(new HostPathVolume("/host/data", "/container/data"));
        volumes.add(new EmptyDirVolume("/empty/dir", Boolean.valueOf(false)));
        template.setVolumes(volumes);
        ArrayList<ContainerTemplate> containers = new ArrayList<ContainerTemplate>();
        ContainerTemplate busyboxContainer = new ContainerTemplate("busybox", "busybox");
        busyboxContainer.setCommand("cat");
        busyboxContainer.setTtyEnabled(true);
        ArrayList<KeyValueEnvVar> envVars = new ArrayList<KeyValueEnvVar>();
        envVars.add(new KeyValueEnvVar("CONTAINER_ENV_VAR", "container-env-var-value"));
        busyboxContainer.setEnvVars(envVars);
        busyboxContainer.setRunAsUser("2000");
        busyboxContainer.setRunAsGroup("2000");
        containers.add(busyboxContainer);
        template.setContainers(containers);
        this.setupStubs();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        pod.getMetadata().setLabels((Map)ImmutableMap.of((Object)"some-label", (Object)"some-label-value"));
        this.validatePod(pod, false, directConnection);
        ArrayList<Long> supplementalGroups = new ArrayList<Long>();
        supplementalGroups.add(5001L);
        supplementalGroups.add(5002L);
        Map<String, Container> containersMap = this.toContainerMap(pod);
        PodSecurityContext securityContext = pod.getSpec().getSecurityContext();
        Assert.assertEquals((Object)1000L, (Object)securityContext.getRunAsUser());
        Assert.assertEquals((Object)1000L, (Object)securityContext.getRunAsGroup());
        Assert.assertEquals(supplementalGroups, (Object)securityContext.getSupplementalGroups());
        Assert.assertEquals((Object)2000L, (Object)containersMap.get("busybox").getSecurityContext().getRunAsUser());
        Assert.assertEquals((Object)2000L, (Object)containersMap.get("busybox").getSecurityContext().getRunAsGroup());
    }

    @Test
    public void homeIsSetOnOpenShift() {
        Mockito.when((Object)this.slave.getKubernetesCloud()).thenReturn((Object)this.cloud);
        ((KubernetesCloud)Mockito.doReturn((Object)JENKINS_URL).when((Object)this.cloud)).getJenkinsUrlOrDie();
        ((KubernetesCloud)Mockito.doReturn((Object)true).when((Object)this.cloud)).isOpenShift();
        PodTemplate template = new PodTemplate();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        Map containers = pod.getSpec().getContainers().stream().collect(Collectors.toMap(Container::getName, Function.identity()));
        Container jnlp = (Container)containers.get("jnlp");
        Assert.assertThat((Object)jnlp.getEnv(), (Matcher)Matchers.hasItems((Object[])new EnvVar[]{new EnvVar("HOME", "/home/jenkins", null)}));
    }

    private void setupStubs() {
        ((KubernetesCloud)Mockito.doReturn((Object)JENKINS_URL).when((Object)this.cloud)).getJenkinsUrlOrDie();
        Mockito.when((Object)this.computer.getName()).thenReturn((Object)AGENT_NAME);
        Mockito.when((Object)this.computer.getJnlpMac()).thenReturn((Object)AGENT_SECRET);
        Mockito.when((Object)this.slave.getComputer()).thenReturn((Object)this.computer);
        Mockito.when((Object)this.slave.getKubernetesCloud()).thenReturn((Object)this.cloud);
    }

    private void validatePod(Pod pod, boolean directConnection) {
        this.validatePod(pod, true, directConnection);
    }

    private void validatePod(Pod pod, boolean fromYaml, boolean directConnection) {
        Assert.assertThat((Object)pod.getMetadata().getLabels(), (Matcher)Matchers.hasEntry((Object)"some-label", (Object)"some-label-value"));
        Map<String, Container> containers = this.toContainerMap(pod);
        Assert.assertEquals((long)2L, (long)containers.size());
        Assert.assertEquals((Object)"busybox", (Object)containers.get("busybox").getImage());
        Assert.assertEquals((Object)PodTemplateBuilder.DEFAULT_JNLP_IMAGE, (Object)containers.get("jnlp").getImage());
        Map volumes = pod.getSpec().getVolumes().stream().collect(Collectors.toMap(Volume::getName, Function.identity()));
        Assert.assertEquals((long)3L, (long)volumes.size());
        Assert.assertNotNull(volumes.get("workspace-volume"));
        if (fromYaml) {
            Assert.assertNotNull(volumes.get("empty-volume"));
            Assert.assertNotNull(volumes.get("host-volume"));
        } else {
            Assert.assertNotNull(volumes.get("volume-0"));
            Assert.assertNotNull(volumes.get("volume-1"));
        }
        List mounts = containers.get("busybox").getVolumeMounts();
        List jnlpMounts = containers.get("jnlp").getVolumeMounts();
        VolumeMount workspaceVolume = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/home/jenkins/agent")).withName("workspace-volume")).withReadOnly(Boolean.valueOf(false))).build();
        if (fromYaml) {
            Assert.assertThat((Object)mounts, (Matcher)Matchers.containsInAnyOrder((Object[])new VolumeMount[]{workspaceVolume, ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/container/data")).withName("host-volume")).build()}));
            Assert.assertThat((Object)jnlpMounts, (Matcher)Matchers.containsInAnyOrder((Object[])new VolumeMount[]{workspaceVolume}));
        } else {
            List<Matcher> volumeMounts = Arrays.asList(Matchers.equalTo((Object)workspaceVolume), Matchers.equalTo((Object)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/container/data")).withName("volume-0")).withReadOnly(Boolean.valueOf(false))).build()), Matchers.equalTo((Object)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/empty/dir")).withName("volume-1")).withReadOnly(Boolean.valueOf(false))).build()));
            Assert.assertThat((Object)mounts, (Matcher)Matchers.containsInAnyOrder(volumeMounts));
            Assert.assertThat((Object)jnlpMounts, (Matcher)Matchers.containsInAnyOrder(volumeMounts));
        }
        this.validateContainers(pod, this.slave, directConnection);
    }

    private void validateContainers(Pod pod, KubernetesSlave slave, boolean directConnection) {
        Object[] exclusions = new String[]{"JENKINS_URL", "JENKINS_SECRET", "JENKINS_NAME", "JENKINS_AGENT_NAME", "JENKINS_AGENT_WORKDIR"};
        for (Container c : pod.getSpec().getContainers()) {
            if ("jnlp".equals(c.getName())) {
                this.validateJnlpContainer(c, slave, directConnection);
                continue;
            }
            List env = c.getEnv();
            Assert.assertThat(env.stream().map(EnvVar::getName).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.not((Matcher)Matchers.isIn((Object[])exclusions))));
        }
    }

    private void validateJnlpContainer(Container jnlp, KubernetesSlave slave, boolean directConnection) {
        Assert.assertThat((Object)jnlp.getCommand(), (Matcher)Matchers.empty());
        ArrayList envVars = Lists.newArrayList();
        if (slave != null) {
            Assert.assertThat((Object)jnlp.getArgs(), (Matcher)Matchers.empty());
            if (directConnection) {
                envVars.add(new EnvVar("JENKINS_PROTOCOLS", JENKINS_PROTOCOLS, null));
                envVars.add(new EnvVar("JENKINS_DIRECT_CONNECTION", "localhost:" + Jenkins.get().getTcpSlaveAgentListener().getAdvertisedPort(), null));
                envVars.add(new EnvVar("JENKINS_INSTANCE_IDENTITY", Jenkins.get().getTcpSlaveAgentListener().getIdentityPublicKey(), null));
            } else {
                envVars.add(new EnvVar("JENKINS_URL", JENKINS_URL, null));
            }
            envVars.add(new EnvVar("JENKINS_SECRET", AGENT_SECRET, null));
            envVars.add(new EnvVar("JENKINS_NAME", AGENT_NAME, null));
            envVars.add(new EnvVar("JENKINS_AGENT_NAME", AGENT_NAME, null));
            envVars.add(new EnvVar("JENKINS_AGENT_WORKDIR", "/home/jenkins/agent", null));
        } else {
            Assert.assertThat((Object)jnlp.getArgs(), (Matcher)Matchers.empty());
        }
        Assert.assertThat((Object)jnlp.getEnv(), (Matcher)Matchers.containsInAnyOrder((Object[])envVars.toArray(new EnvVar[envVars.size()])));
        if (jnlp.getResources() != null) {
            if (jnlp.getResources().getRequests() != null) {
                Assert.assertFalse((boolean)jnlp.getResources().getRequests().containsValue(new Quantity("")));
            }
            if (jnlp.getResources().getLimits() != null) {
                Assert.assertFalse((boolean)jnlp.getResources().getLimits().containsValue(new Quantity("")));
            }
        }
    }

    @Test
    @TestCaseName(value="{method}(directConnection={0})")
    @Parameters(value={"true", "false"})
    public void testOverridesFromYaml(boolean directConnection) throws Exception {
        this.cloud.setDirectConnection(directConnection);
        PodTemplate template = new PodTemplate();
        template.setYaml(this.loadYamlFile("pod-overrides.yaml"));
        this.setupStubs();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        Map<String, Container> containers = this.toContainerMap(pod);
        Assert.assertEquals((long)1L, (long)containers.size());
        Container jnlp = containers.get("jnlp");
        Assert.assertThat((String)("Wrong number of volume mounts: " + jnlp.getVolumeMounts()), (Object)jnlp.getVolumeMounts(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertEquals((Object)new Quantity("2"), jnlp.getResources().getLimits().get("cpu"));
        Assert.assertEquals((Object)new Quantity("2Gi"), jnlp.getResources().getLimits().get("memory"));
        Assert.assertEquals((Object)new Quantity("200m"), jnlp.getResources().getRequests().get("cpu"));
        Assert.assertEquals((Object)new Quantity("256Mi"), jnlp.getResources().getRequests().get("memory"));
        this.validateContainers(pod, this.slave, directConnection);
    }

    @Test
    @TestCaseName(value="{method}(directConnection={0})")
    @Parameters(value={"true", "false"})
    public void testInheritsFromWithYaml(boolean directConnection) throws Exception {
        this.cloud.setDirectConnection(directConnection);
        PodTemplate parent = new PodTemplate();
        ContainerTemplate container1 = new ContainerTemplate("jnlp", "image1");
        container1.setResourceLimitCpu("1");
        container1.setResourceLimitMemory("1Gi");
        container1.setResourceRequestCpu("100m");
        container1.setResourceRequestMemory("156Mi");
        container1.setRunAsUser("1000");
        container1.setRunAsGroup("2000");
        parent.setContainers(Arrays.asList(container1));
        PodTemplate template = new PodTemplate();
        template.setYaml(this.loadYamlFile("pod-overrides.yaml"));
        template.setInheritFrom("parent");
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)template);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Map<String, Container> containers = this.toContainerMap(pod);
        Assert.assertEquals((long)1L, (long)containers.size());
        Container jnlp = containers.get("jnlp");
        Assert.assertEquals((Object)new Quantity("1"), jnlp.getResources().getLimits().get("cpu"));
        Assert.assertEquals((Object)new Quantity("1Gi"), jnlp.getResources().getLimits().get("memory"));
        Assert.assertEquals((Object)new Quantity("100m"), jnlp.getResources().getRequests().get("cpu"));
        Assert.assertEquals((Object)new Quantity("156Mi"), jnlp.getResources().getRequests().get("memory"));
        Assert.assertEquals((Object)1000L, (Object)jnlp.getSecurityContext().getRunAsUser());
        Assert.assertEquals((Object)2000L, (Object)jnlp.getSecurityContext().getRunAsGroup());
        this.validateContainers(pod, this.slave, directConnection);
    }

    @Test
    public void yamlMergeContainers() throws Exception {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("apiVersion: v1\nkind: Pod\nmetadata:\n  labels:\n    some-label: some-label-value\nspec:\n  containers:\n  - name: container1\n    image: busybox\n    command:\n    - cat\n    tty: true\n");
        PodTemplate child = new PodTemplate();
        child.setYaml("spec:\n  containers:\n  - name: container2\n    image: busybox\n    command:\n    - cat\n    tty: true\n");
        child.setYamlMergeStrategy(this.merge());
        child.setInheritFrom("parent");
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Assert.assertEquals((Object)"some-label-value", pod.getMetadata().getLabels().get("some-label"));
        Assert.assertThat((Object)pod.getSpec().getContainers(), (Matcher)Matchers.hasSize((int)3));
        Optional<Container> container1 = pod.getSpec().getContainers().stream().filter(c -> "container1".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)container1.isPresent());
        Optional<Container> container2 = pod.getSpec().getContainers().stream().filter(c -> "container2".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)container2.isPresent());
    }

    @Test
    public void yamlOverrideContainer() throws Exception {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("apiVersion: v1\nkind: Pod\nmetadata:\n  labels:\n    some-label: some-label-value\nspec:\n  containers:\n  - name: container\n    image: busybox\n    command:\n    - cat\n    tty: true\n");
        PodTemplate child = new PodTemplate();
        child.setYaml("spec:\n  containers:\n  - name: container\n    image: busybox2\n    command:\n    - cat\n    tty: true\n");
        child.setInheritFrom("parent");
        child.setYamlMergeStrategy(this.merge());
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Assert.assertEquals((Object)"some-label-value", pod.getMetadata().getLabels().get("some-label"));
        Assert.assertThat((Object)pod.getSpec().getContainers(), (Matcher)Matchers.hasSize((int)2));
        Optional<Container> container = pod.getSpec().getContainers().stream().filter(c -> "container".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)container.isPresent());
        Assert.assertEquals((Object)"busybox2", (Object)container.get().getImage());
    }

    @Test
    public void yamlOverrideContainerEnvvar() throws Exception {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("kind: Pod\nspec:\n  containers:\n  - name: jnlp\n    env:\n    - name: VAR1\n      value: \"1\"\n    - name: VAR2\n      value: \"1\"\n");
        PodTemplate child = new PodTemplate();
        child.setYamlMergeStrategy(this.merge());
        child.setYaml("kind: Pod\nspec:\n  containers:\n  - name: jnlp\n    env:\n    - name: VAR1\n      value: \"2\"\n");
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Map<String, Container> containers = this.toContainerMap(pod);
        Container jnlp = containers.get("jnlp");
        Map env = PodTemplateUtils.envVarstoMap((List)jnlp.getEnv());
        Assert.assertEquals((Object)"2", (Object)((EnvVar)env.get("VAR1")).getValue());
        Assert.assertEquals((Object)"1", (Object)((EnvVar)env.get("VAR2")).getValue());
    }

    @Test
    public void yamlOverrideVolume() throws Exception {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("apiVersion: v1\nkind: Pod\nmetadata:\n  labels:\n    some-label: some-label-value\nspec:\n  volumes:\n  - name: host-volume\n    hostPath:\n      path: /host/data\n");
        PodTemplate child = new PodTemplate();
        child.setYaml("spec:\n  volumes:\n  - name: host-volume\n    hostPath:\n      path: /host/data2\n");
        child.setInheritFrom("parent");
        child.setYamlMergeStrategy(this.merge());
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Assert.assertEquals((Object)"some-label-value", pod.getMetadata().getLabels().get("some-label"));
        Assert.assertThat((Object)pod.getSpec().getVolumes(), (Matcher)Matchers.hasSize((int)2));
        Optional<Volume> hostVolume = pod.getSpec().getVolumes().stream().filter(v -> "host-volume".equals(v.getName())).findFirst();
        Assert.assertTrue((boolean)hostVolume.isPresent());
        Assert.assertThat((Object)hostVolume.get().getHostPath().getPath(), (Matcher)Matchers.equalTo((Object)"/host/data2"));
    }

    @Test
    public void yamlOverrideHostNetwork() {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("apiVersion: v1\nkind: Pod\nmetadata:\n  labels:\n    some-label: some-label-value\nspec:\n  hostNetwork: false\n  containers:\n  - name: container\n    securityContext:\n      runAsUser: 1000\n      runAsGroup: 1000\n    image: busybox\n    command:\n    - cat\n    tty: true\n");
        PodTemplate child = new PodTemplate();
        child.setYaml("spec:\n  hostNetwork: true\n  containers:\n  - name: container\n    image: busybox2\n    securityContext:\n      runAsUser: 2000\n      runAsGroup: 2000\n    command:\n    - cat\n    tty: true\n");
        child.setInheritFrom("parent");
        child.setYamlMergeStrategy(this.merge());
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).build();
        Assert.assertTrue((boolean)pod.getSpec().getHostNetwork());
    }

    @Test
    public void yamlOverrideSecurityContext() {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("apiVersion: v1\nkind: Pod\nmetadata:\n  labels:\n    some-label: some-label-value\nspec:\n  securityContext:\n    runAsUser: 2000\n    runAsGroup: 2000\n  containers:\n  - name: container\n    securityContext:\n      runAsUser: 1000\n      runAsGroup: 1000\n    image: busybox\n    command:\n    - cat\n    tty: true\n");
        PodTemplate child = new PodTemplate();
        child.setYaml("spec:\n  securityContext:\n    runAsUser: 3000\n    runAsGroup: 3000\n  containers:\n  - name: container\n    image: busybox2\n    securityContext:\n      runAsUser: 2000\n      runAsGroup: 2000\n    command:\n    - cat\n    tty: true\n");
        child.setInheritFrom("parent");
        child.setYamlMergeStrategy(this.merge());
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Assert.assertThat((Object)pod.getSpec().getContainers(), (Matcher)Matchers.hasSize((int)2));
        Optional<Container> container = pod.getSpec().getContainers().stream().filter(c -> "container".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)container.isPresent());
        Assert.assertEquals((Object)3000L, (Object)pod.getSpec().getSecurityContext().getRunAsUser());
        Assert.assertEquals((Object)3000L, (Object)pod.getSpec().getSecurityContext().getRunAsGroup());
        Assert.assertEquals((Object)2000L, (Object)container.get().getSecurityContext().getRunAsUser());
        Assert.assertEquals((Object)2000L, (Object)container.get().getSecurityContext().getRunAsGroup());
    }

    @Test
    public void yamlMergeVolumes() throws Exception {
        PodTemplate parent = new PodTemplate();
        parent.setYaml("apiVersion: v1\nkind: Pod\nmetadata:\n  labels:\n    some-label: some-label-value\nspec:\n  volumes:\n  - name: host-volume\n    hostPath:\n      path: /host/data\n");
        PodTemplate child = new PodTemplate();
        child.setYaml("spec:\n  volumes:\n  - name: host-volume2\n    hostPath:\n      path: /host/data2\n");
        child.setInheritFrom("parent");
        child.setYamlMergeStrategy(this.merge());
        this.setupStubs();
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)child);
        Pod pod = new PodTemplateBuilder(result).withSlave(this.slave).build();
        Assert.assertEquals((Object)"some-label-value", pod.getMetadata().getLabels().get("some-label"));
        Assert.assertThat((Object)pod.getSpec().getVolumes(), (Matcher)Matchers.hasSize((int)3));
        Optional<Volume> hostVolume = pod.getSpec().getVolumes().stream().filter(v -> "host-volume".equals(v.getName())).findFirst();
        Assert.assertTrue((boolean)hostVolume.isPresent());
        Assert.assertThat((Object)hostVolume.get().getHostPath().getPath(), (Matcher)Matchers.equalTo((Object)"/host/data"));
        Optional<Volume> hostVolume2 = pod.getSpec().getVolumes().stream().filter(v -> "host-volume2".equals(v.getName())).findFirst();
        Assert.assertTrue((boolean)hostVolume2.isPresent());
        Assert.assertThat((Object)hostVolume2.get().getHostPath().getPath(), (Matcher)Matchers.equalTo((Object)"/host/data2"));
    }

    @Test
    @TestCaseName(value="{method}(directConnection={0})")
    @Parameters(value={"true", "false"})
    public void testOverridesContainerSpec(boolean directConnection) throws Exception {
        this.cloud.setDirectConnection(directConnection);
        PodTemplate template = new PodTemplate();
        ContainerTemplate cT = new ContainerTemplate("jnlp", "jenkinsci/jnlp-slave:latest");
        template.setContainers((List)Lists.newArrayList((Object[])new ContainerTemplate[]{cT}));
        template.setYaml(this.loadYamlFile("pod-overrides.yaml"));
        this.setupStubs();
        Pod pod = new PodTemplateBuilder(template).withSlave(this.slave).build();
        Map<String, Container> containers = this.toContainerMap(pod);
        Assert.assertEquals((long)1L, (long)containers.size());
        Container jnlp = containers.get("jnlp");
        Assert.assertEquals((String)("Wrong number of volume mounts: " + jnlp.getVolumeMounts()), (long)1L, (long)jnlp.getVolumeMounts().size());
        this.validateContainers(pod, this.slave, directConnection);
    }

    private Map<String, Container> toContainerMap(Pod pod) {
        return pod.getSpec().getContainers().stream().collect(Collectors.toMap(Container::getName, Function.identity()));
    }

    private String loadYamlFile(String s) throws IOException {
        return new String(IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream(s)));
    }

    private YamlMergeStrategy merge() {
        return new Merge();
    }
}

