/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import hudson.Util;
import hudson.model.Action;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodLabel;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestName;
import org.jvnet.hudson.test.JenkinsRule;

public class KubernetesTestUtil {
    private static final Logger LOGGER = Logger.getLogger(KubernetesTestUtil.class.getName());
    private static final String DEFAULT_TESTING_NAMESPACE = "kubernetes-plugin-test";
    public static String testingNamespace;
    private static final String BRANCH_NAME;
    private static final String BUILD_NUMBER;
    private static Map<String, String> DEFAULT_LABELS;
    public static final String SECRET_KEY = "password";
    public static final String CONTAINER_ENV_VAR_FROM_SECRET_VALUE = "container-pa55w0rd";
    public static final String POD_ENV_VAR_FROM_SECRET_VALUE = "pod-pa55w0rd";

    public static KubernetesCloud setupCloud(Object test, TestName name) throws UnrecoverableKeyException, CertificateEncodingException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KubernetesCloud cloud = new KubernetesCloud("kubernetes");
        cloud.setPodLabels(PodLabel.fromMap(KubernetesTestUtil.getLabels(cloud, test, name)));
        KubernetesClient client = cloud.connect();
        String branch = System.getenv("BRANCH_NAME");
        if (StringUtils.isNotBlank((String)branch)) {
            String namespaceWithBranch = String.format("%s-%s", DEFAULT_TESTING_NAMESPACE, branch);
            LOGGER.log(Level.FINE, "Trying to use namespace: {0}", testingNamespace);
            try {
                if (((Resource)client.namespaces().withName(namespaceWithBranch)).get() != null) {
                    testingNamespace = namespaceWithBranch;
                }
            }
            catch (KubernetesClientException kubernetesClientException) {
                // empty catch block
            }
        }
        if (testingNamespace == null) {
            testingNamespace = DEFAULT_TESTING_NAMESPACE;
            if (((Resource)client.namespaces().withName(testingNamespace)).get() == null) {
                LOGGER.log(Level.INFO, "Creating namespace: {0}", testingNamespace);
                client.namespaces().create((Object[])new Namespace[]{((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(testingNamespace)).endMetadata()).build()});
            }
        }
        LOGGER.log(Level.INFO, "Using namespace {0} for branch {1}", new String[]{testingNamespace, branch});
        cloud.setNamespace(testingNamespace);
        client = cloud.connect();
        return cloud;
    }

    public static void setupHost() throws Exception {
        URL url = new URL(JenkinsLocationConfiguration.get().getUrl());
        String hostAddress = System.getProperty("jenkins.host.address");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hostAddress)) {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        System.err.println("Calling home to address: " + hostAddress);
        URL nonLocalhostUrl = new URL(url.getProtocol(), hostAddress, url.getPort(), url.getFile());
        JenkinsLocationConfiguration.get().setUrl(nonLocalhostUrl.toString());
        Integer slaveAgentPort = Integer.getInteger("slaveAgentPort");
        if (slaveAgentPort != null) {
            Jenkins.get().setSlaveAgentPort(slaveAgentPort.intValue());
        }
    }

    public static void assumeKubernetes() throws Exception {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(new ConfigBuilder(Config.autoConfigure(null)).build());){
            client.pods().list();
        }
        catch (Exception e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    public static void assumeWindows() {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(new ConfigBuilder(Config.autoConfigure(null)).build());){
            for (Node n : ((NodeList)client.nodes().list()).getItems()) {
                String os = (String)n.getMetadata().getLabels().get("kubernetes.io/os");
                LOGGER.info(() -> "Found node " + n.getMetadata().getName() + " running OS " + os);
                if (!"windows".equals(os)) continue;
                return;
            }
        }
        throw new AssumptionViolatedException("Cluster seems to contain no Windows nodes");
    }

    public static Map<String, String> getLabels(Object o, TestName name) {
        return KubernetesTestUtil.getLabels(null, o, name);
    }

    public static Map<String, String> getLabels(KubernetesCloud cloud, Object o, TestName name) {
        HashMap l = Maps.newHashMap(DEFAULT_LABELS);
        if (cloud != null) {
            l.putAll(cloud.getPodLabelsMap());
        }
        l.put("class", o.getClass().getSimpleName());
        l.put("test", name.getMethodName());
        return l;
    }

    public static boolean deletePods(KubernetesClient client, Map<String, String> labels, boolean wait) throws Exception {
        if (client != null) {
            FilterWatchListDeletable pods;
            if (wait) {
                LOGGER.log(Level.INFO, "Waiting for pods to terminate");
                ForkJoinPool forkJoinPool = new ForkJoinPool(1);
                try {
                    ((ForkJoinTask)forkJoinPool.submit(() -> IntStream.range(1, 1000000).anyMatch(i -> {
                        try {
                            FilterWatchListDeletable pods = (FilterWatchListDeletable)client.pods().withLabels(labels);
                            LOGGER.log(Level.INFO, "Still waiting for pods to terminate: {0}", KubernetesTestUtil.print((FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>>)pods));
                            boolean allTerminated = ((PodList)pods.list()).getItems().isEmpty();
                            if (allTerminated) {
                                LOGGER.log(Level.INFO, "All pods are terminated: {0}", KubernetesTestUtil.print((FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>>)pods));
                            } else {
                                LOGGER.log(Level.INFO, "Still waiting for pods to terminate: {0}", KubernetesTestUtil.print((FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>>)pods));
                                Thread.sleep(5000L);
                            }
                            return allTerminated;
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.INFO, "Waiting for pods to terminate - interrupted");
                            return true;
                        }
                    }))).get(90L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    LOGGER.log(Level.INFO, "Waiting for pods to terminate - timed out");
                }
            }
            if (!((PodList)(pods = (FilterWatchListDeletable)client.pods().withLabels(labels)).list()).getItems().isEmpty()) {
                LOGGER.log(Level.WARNING, "Deleting leftover pods: {0}", KubernetesTestUtil.print((FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>>)pods));
                if (Boolean.TRUE.equals(pods.delete())) {
                    return true;
                }
            }
        }
        return false;
    }

    private static List<String> print(FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> pods) {
        return ((PodList)pods.list()).getItems().stream().map(pod -> String.format("%s (%s)", pod.getMetadata().getName(), pod.getStatus().getPhase())).collect(Collectors.toList());
    }

    public static void createSecret(KubernetesClient client, String namespace) {
        Secret secret = ((SecretBuilder)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withStringData((Map)ImmutableMap.of((Object)SECRET_KEY, (Object)CONTAINER_ENV_VAR_FROM_SECRET_VALUE))).withNewMetadata().withName("container-secret")).endMetadata()).build();
        secret = (Secret)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).createOrReplace((Object[])new Secret[]{secret});
        LOGGER.log(Level.INFO, "Created container secret: {0}", secret);
        secret = ((SecretBuilder)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withStringData((Map)ImmutableMap.of((Object)SECRET_KEY, (Object)POD_ENV_VAR_FROM_SECRET_VALUE))).withNewMetadata().withName("pod-secret")).endMetadata()).build();
        secret = (Secret)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).createOrReplace((Object[])new Secret[]{secret});
        LOGGER.log(Level.INFO, "Created pod secret: {0}", secret);
        secret = ((SecretBuilder)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withStringData((Map)ImmutableMap.of((Object)SECRET_KEY, (Object)""))).withNewMetadata().withName("empty-secret")).endMetadata()).build();
        secret = (Secret)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).createOrReplace((Object[])new Secret[]{secret});
        LOGGER.log(Level.INFO, "Created pod secret: {0}", secret);
    }

    public static String generateProjectName(String name) {
        return name.replaceAll("([A-Z])", " $1");
    }

    public static WorkflowRun createPipelineJobThenScheduleRun(JenkinsRule r, Class cls, String methodName) throws InterruptedException, ExecutionException, IOException {
        return KubernetesTestUtil.createPipelineJobThenScheduleRun(r, cls, methodName, null);
    }

    public static WorkflowRun createPipelineJobThenScheduleRun(JenkinsRule r, Class cls, String methodName, Map<String, String> env) throws IOException, ExecutionException, InterruptedException {
        WorkflowJob p = (WorkflowJob)r.jenkins.createProject(WorkflowJob.class, KubernetesTestUtil.generateProjectName(methodName));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(KubernetesTestUtil.loadPipelineDefinition(cls, methodName, env), true));
        return (WorkflowRun)p.scheduleBuild2(0, new Action[0]).waitForStart();
    }

    public static String loadPipelineDefinition(Class cls, String name, Map<String, String> providedEnv) {
        HashMap<String, String> env = providedEnv == null ? new HashMap<String, String>() : new HashMap<String, String>(providedEnv);
        env.put("NAME", name);
        return Util.replaceMacro((String)KubernetesTestUtil.loadPipelineScript(cls, name + ".groovy"), env);
    }

    public static String loadPipelineScript(Class<?> clazz, String name) {
        try {
            return new String(IOUtils.toByteArray((InputStream)clazz.getResourceAsStream(name)));
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not read resource:[" + name + "].");
        }
    }

    public static void assertRegex(String name, String regex) {
        Assert.assertNotNull((Object)name);
        Assert.assertTrue((String)String.format("Name does not match regex [%s]: '%s'", regex, name), (boolean)name.matches(regex));
    }

    static {
        BRANCH_NAME = System.getenv("BRANCH_NAME");
        BUILD_NUMBER = System.getenv("BUILD_NUMBER");
        DEFAULT_LABELS = ImmutableMap.of((Object)"BRANCH_NAME", (Object)(BRANCH_NAME == null ? "undefined" : BRANCH_NAME), (Object)"BUILD_NUMBER", (Object)(BUILD_NUMBER == null ? "undefined" : BUILD_NUMBER));
    }
}

