/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Label;
import hudson.plugins.git.GitTool;
import hudson.tools.ToolLocationNodeProperty;
import hudson.util.Secret;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateToolLocation;
import org.csanchez.jenkins.plugins.kubernetes.model.KeyValueEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Default;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Never;
import org.csanchez.jenkins.plugins.kubernetes.volumes.EmptyDirVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.HostPathVolume;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.kubernetes.credentials.FileSystemServiceAccountCredential;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.recipes.LocalData;

public class KubernetesTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public LoggerRule log = new LoggerRule();
    private KubernetesCloud cloud;

    @Before
    public void before() throws Exception {
        this.cloud = (KubernetesCloud)this.r.jenkins.clouds.get(KubernetesCloud.class);
        Assert.assertNotNull((Object)this.cloud);
    }

    @Test
    @LocalData
    public void upgradeFrom_1_17_2() throws Exception {
        Map labels = this.cloud.getPodLabelsMap();
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertThat((Object)this.cloud.getPodLabelsMap(), (Matcher)Matchers.hasEntry((Object)"jenkins", (Object)"slave"));
        Assert.assertThat((Object)this.cloud.getPodLabelsMap(), (Matcher)Matchers.hasEntry((Object)"biff", (Object)"johnson"));
        PodTemplate pt = this.cloud.getTemplate(Label.get((String)"java"));
        Assert.assertNotNull((Object)pt);
        for (ContainerTemplate ct : pt.getContainers()) {
            Assert.assertEquals((Object)"/home/jenkins/agent", (Object)ct.getWorkingDir());
        }
    }

    @Test
    @LocalData
    public void upgradeFrom_1_15_9() {
        List templates = this.cloud.getTemplates();
        this.assertPodTemplates(templates);
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals((Object)"blah", (Object)template.getYaml());
        Assert.assertEquals(Collections.singletonList("blah"), (Object)template.getYamls());
        Assert.assertNull((Object)template._getYamls());
    }

    @Test
    @LocalData
    public void upgradeFrom_1_15_9_invalid() {
        this.log.record(PodTemplate.class, Level.WARNING).capture(1);
        List templates = this.cloud.getTemplates();
        this.assertPodTemplates(templates);
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals((Object)"blah", (Object)template.getYaml());
        Assert.assertEquals(Collections.singletonList("blah"), (Object)template.getYamls());
        Assert.assertNull((Object)template._getYamls());
        this.log.getMessages().stream().anyMatch(msg -> msg.contains("Found several persisted YAML fragments in pod template java"));
    }

    @Test
    @LocalData
    public void upgradeFrom_1_15_1() throws Exception {
        List templates = this.cloud.getTemplates();
        this.assertPodTemplates(templates);
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals(Collections.emptyList(), (Object)template.getYamls());
        Assert.assertNull((Object)template.getYaml());
    }

    @Test
    @LocalData
    public void upgradeFrom_1_10() throws Exception {
        List templates = this.cloud.getTemplates();
        this.assertPodTemplates(templates);
        Assert.assertEquals((Object)new Never(), (Object)this.cloud.getPodRetention());
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals((Object)new Default(), (Object)template.getPodRetention());
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_WAIT_FOR_POD_SEC, (Object)this.cloud.getWaitForPodSec());
        Assert.assertTrue((boolean)template.isShowRawYaml());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getYamls());
        Assert.assertNull((Object)template.getYaml());
    }

    @Test
    @LocalData
    public void upgradeFrom_1_1() throws Exception {
        List credentials = SystemCredentialsProvider.getInstance().getCredentials();
        Assert.assertEquals((long)3L, (long)credentials.size());
        UsernamePasswordCredentialsImpl cred0 = (UsernamePasswordCredentialsImpl)credentials.get(0);
        Assert.assertEquals((Object)"token", (Object)cred0.getId());
        Assert.assertEquals((Object)"myusername", (Object)cred0.getUsername());
        FileSystemServiceAccountCredential cred1 = (FileSystemServiceAccountCredential)credentials.get(1);
        StringCredentialsImpl cred2 = (StringCredentialsImpl)credentials.get(2);
        Assert.assertEquals((Object)"mytoken", (Object)Secret.toString((Secret)cred2.getSecret()));
        Assert.assertThat((Object)this.cloud.getLabels(), (Matcher)Matchers.hasEntry((Object)"jenkins", (Object)"slave"));
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_WAIT_FOR_POD_SEC, (Object)this.cloud.getWaitForPodSec());
    }

    @Test
    @LocalData
    public void upgradeFrom_0_12() throws Exception {
        List templates = this.cloud.getTemplates();
        this.assertPodTemplates(templates);
        PodTemplate template = (PodTemplate)templates.get(0);
        Assert.assertEquals(Arrays.asList(new KeyValueEnvVar("pod_a_key", "pod_a_value"), new KeyValueEnvVar("pod_b_key", "pod_b_value")), (Object)template.getEnvVars());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getYamls());
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_WAIT_FOR_POD_SEC, (Object)this.cloud.getWaitForPodSec());
    }

    @Test
    @LocalData
    public void upgradeFrom_0_10() throws Exception {
        List templates = this.cloud.getTemplates();
        PodTemplate template = (PodTemplate)templates.get(0);
        PodTemplateToolLocation nodeProperties = template.getNodeProperties();
        Assert.assertEquals((long)1L, (long)nodeProperties.size());
        ToolLocationNodeProperty property = (ToolLocationNodeProperty)nodeProperties.get(0);
        Assert.assertEquals((long)1L, (long)property.getLocations().size());
        ToolLocationNodeProperty.ToolLocation location = (ToolLocationNodeProperty.ToolLocation)property.getLocations().get(0);
        Assert.assertEquals((Object)"Default", (Object)location.getName());
        Assert.assertEquals((Object)"/custom/path", (Object)location.getHome());
        Assert.assertEquals(GitTool.class, (Object)location.getType().clazz);
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_WAIT_FOR_POD_SEC, (Object)this.cloud.getWaitForPodSec());
    }

    @Test
    @LocalData
    public void upgradeFrom_0_8() throws Exception {
        List templates = this.cloud.getTemplates();
        this.assertPodTemplates(templates);
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_WAIT_FOR_POD_SEC, (Object)this.cloud.getWaitForPodSec());
    }

    private void assertPodTemplates(List<PodTemplate> templates) {
        Assert.assertEquals((long)1L, (long)templates.size());
        PodTemplate podTemplate = templates.get(0);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)podTemplate.getInstanceCap());
        Assert.assertEquals((long)1L, (long)podTemplate.getContainers().size());
        ContainerTemplate containerTemplate = (ContainerTemplate)podTemplate.getContainers().get(0);
        Assert.assertEquals((Object)"jenkins/jnlp-slave", (Object)containerTemplate.getImage());
        Assert.assertEquals((Object)"jnlp", (Object)containerTemplate.getName());
        Assert.assertEquals(Arrays.asList(new KeyValueEnvVar("a", "b"), new KeyValueEnvVar("c", "d")), (Object)containerTemplate.getEnvVars());
        Assert.assertEquals((long)2L, (long)podTemplate.getVolumes().size());
        EmptyDirVolume emptyVolume = (EmptyDirVolume)podTemplate.getVolumes().get(0);
        Assert.assertEquals((Object)"/mnt", (Object)emptyVolume.getMountPath());
        Assert.assertFalse((boolean)emptyVolume.getMemory());
        Assert.assertEquals((Object)EmptyDirVolume.class.getName(), (Object)emptyVolume.getClass().getName());
        HostPathVolume hostPathVolume = (HostPathVolume)podTemplate.getVolumes().get(1);
        Assert.assertEquals((Object)"/host", (Object)hostPathVolume.getMountPath());
        Assert.assertEquals((Object)"/mnt/host", (Object)hostPathVolume.getHostPath());
        Assert.assertEquals((Object)HostPathVolume.class.getName(), (Object)hostPathVolume.getClass().getName());
        Assert.assertEquals((long)0L, (long)podTemplate.getActiveDeadlineSeconds());
    }
}

