/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.model.Descriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesTestUtil;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Always;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Default;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Never;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.OnFailure;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class KubernetesSlaveTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void testGetSlaveName() {
        List volumes = Collections.emptyList();
        List containers = Collections.emptyList();
        KubernetesTestUtil.assertRegex(KubernetesSlave.getSlaveName((PodTemplate)new PodTemplate("image", volumes)), "^jenkins-agent-[0-9a-z]{5}$");
        KubernetesTestUtil.assertRegex(KubernetesSlave.getSlaveName((PodTemplate)new PodTemplate("", volumes, containers)), "^jenkins-agent-[0-9a-z]{5}$");
        KubernetesTestUtil.assertRegex(KubernetesSlave.getSlaveName((PodTemplate)new PodTemplate("a name", volumes, containers)), "^a-name-[0-9a-z]{5}$");
        KubernetesTestUtil.assertRegex(KubernetesSlave.getSlaveName((PodTemplate)new PodTemplate("an_other_name", volumes, containers)), "^an-other-name-[0-9a-z]{5}$");
    }

    @Test
    public void testGetPodRetention() {
        try {
            List<KubernetesSlaveTestCase> cases = Arrays.asList(this.createPodRetentionTestCase((PodRetention)new Never(), (PodRetention)new Default(), (PodRetention)new Default()), this.createPodRetentionTestCase((PodRetention)new Never(), (PodRetention)new Always(), (PodRetention)new Always()), this.createPodRetentionTestCase((PodRetention)new Never(), (PodRetention)new OnFailure(), (PodRetention)new OnFailure()), this.createPodRetentionTestCase((PodRetention)new Never(), (PodRetention)new Never(), (PodRetention)new Never()), this.createPodRetentionTestCase((PodRetention)new OnFailure(), (PodRetention)new Default(), (PodRetention)new Default()), this.createPodRetentionTestCase((PodRetention)new OnFailure(), (PodRetention)new Always(), (PodRetention)new Always()), this.createPodRetentionTestCase((PodRetention)new OnFailure(), (PodRetention)new OnFailure(), (PodRetention)new OnFailure()), this.createPodRetentionTestCase((PodRetention)new OnFailure(), (PodRetention)new Never(), (PodRetention)new Never()), this.createPodRetentionTestCase((PodRetention)new Always(), (PodRetention)new Default(), (PodRetention)new Default()), this.createPodRetentionTestCase((PodRetention)new Always(), (PodRetention)new Always(), (PodRetention)new Always()), this.createPodRetentionTestCase((PodRetention)new Always(), (PodRetention)new OnFailure(), (PodRetention)new OnFailure()), this.createPodRetentionTestCase((PodRetention)new Always(), (PodRetention)new Never(), (PodRetention)new Never()));
            KubernetesCloud cloud = new KubernetesCloud("test");
            this.r.jenkins.clouds.add((Object)cloud);
            for (KubernetesSlaveTestCase testCase : cases) {
                cloud.setPodRetention(testCase.getCloudPodRetention());
                KubernetesSlave testSlave = testCase.buildSubject(cloud);
                Assert.assertEquals(testCase.getExpectedResult(), (Object)testSlave.getPodRetention(cloud));
            }
        }
        catch (Descriptor.FormException | IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private KubernetesSlaveTestCase<PodRetention> createPodRetentionTestCase(PodRetention cloudRetention, PodRetention templateRetention, PodRetention expectedResult) {
        return new KubernetesSlaveTestBuilder().withCloudPodRetention(cloudRetention).withTemplatePodRetention(templateRetention).withExpectedResult(expectedResult).build();
    }

    public static class KubernetesSlaveTestBuilder<T> {
        private PodRetention cloudPodRetention;
        private PodRetention templatePodRetention;
        private String podPhase;
        private T expectedResult;

        public KubernetesSlaveTestBuilder<T> withExpectedResult(T expectedResult) {
            this.expectedResult = expectedResult;
            return this;
        }

        public KubernetesSlaveTestBuilder<T> withCloudPodRetention(PodRetention podRetention) {
            this.cloudPodRetention = podRetention;
            return this;
        }

        public KubernetesSlaveTestBuilder<T> withTemplatePodRetention(PodRetention podRetention) {
            this.templatePodRetention = podRetention;
            return this;
        }

        public KubernetesSlaveTestBuilder<T> withPodPhase(String podPhase) {
            this.podPhase = podPhase;
            return this;
        }

        public KubernetesSlaveTestCase<T> build() {
            ContainerTemplate testContainer = new ContainerTemplate("busybox", "busybox");
            PodTemplate testTemplate = new PodTemplate();
            testTemplate.setPodRetention(this.templatePodRetention);
            testTemplate.setName("test-template");
            testTemplate.setLabel("test-template");
            testTemplate.setContainers(Arrays.asList(testContainer));
            KubernetesSlaveTestCase testCase = new KubernetesSlaveTestCase();
            testCase.cloudPodRetention = this.cloudPodRetention;
            testCase.podTemplate = testTemplate;
            testCase.expectedResult = this.expectedResult;
            testCase.podPhase = this.podPhase;
            return testCase;
        }
    }

    public static class KubernetesSlaveTestCase<T> {
        private PodRetention cloudPodRetention;
        private PodTemplate podTemplate;
        private String podPhase;
        private T expectedResult;

        public KubernetesSlave buildSubject(KubernetesCloud cloud) throws IOException, Descriptor.FormException {
            return new KubernetesSlave.Builder().cloud(cloud).podTemplate(this.podTemplate).build();
        }

        public PodRetention getCloudPodRetention() {
            return this.cloudPodRetention;
        }

        public T getExpectedResult() {
            return this.expectedResult;
        }

        public PodTemplate getPodTemplate() {
            return this.podTemplate;
        }

        public String getPodPhase() {
            return this.podPhase;
        }
    }
}

