/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KubernetesFactoryAdapterTest {
    private static final String[] SYSTEM_PROPERTY_NAMES = new String[]{"kubeconfig", "kubenamespace", "http.proxy", "https.proxy", "no.proxy", "proxy.username", "proxy.password"};
    private static final String HTTP_PROXY = "http://example.com:123";
    private static final String HTTPS_PROXY = "https://example.com:123";
    private static final String NO_PROXY = "noproxy";
    private static final String PROXY_USERNAME = "proxy_username";
    private static final String PROXY_PASSWORD = "proxy_password";
    private Map<String, String> systemProperties = new HashMap<String, String>();

    @Before
    public void saveSystemProperties() {
        for (String key : SYSTEM_PROPERTY_NAMES) {
            this.systemProperties.put(key, System.getProperty(key));
            System.setProperty(key, "src/test/resources/void");
        }
        System.setProperty("http.proxy", HTTP_PROXY);
        System.setProperty("https.proxy", HTTPS_PROXY);
        System.setProperty("no.proxy", NO_PROXY);
        System.setProperty("proxy.username", PROXY_USERNAME);
        System.setProperty("proxy.password", PROXY_PASSWORD);
    }

    @After
    public void restoreSystemProperties() {
        for (String key : this.systemProperties.keySet()) {
            String s = this.systemProperties.get(key);
            if (s != null) {
                System.setProperty(key, this.systemProperties.get(key));
                continue;
            }
            System.clearProperty(key);
        }
    }

    @Test
    public void defaultNamespace() throws Exception {
        KubernetesFactoryAdapter factory = new KubernetesFactoryAdapter(null, null, null, false);
        KubernetesClient client = factory.createClient();
        Assert.assertEquals((Object)"default", (Object)client.getNamespace());
    }

    @Test
    public void autoConfig() throws Exception {
        System.setProperty("kubenamespace", "src/test/resources/kubenamespace");
        KubernetesFactoryAdapter factory = new KubernetesFactoryAdapter(null, null, null, false);
        KubernetesClient client = factory.createClient();
        Assert.assertEquals((Object)"test-namespace", (Object)client.getNamespace());
        Assert.assertEquals((Object)HTTP_PROXY, (Object)client.getConfiguration().getHttpProxy());
        Assert.assertEquals((Object)HTTPS_PROXY, (Object)client.getConfiguration().getHttpsProxy());
        Assert.assertArrayEquals((Object[])new String[]{NO_PROXY}, (Object[])client.getConfiguration().getNoProxy());
        Assert.assertEquals((Object)PROXY_USERNAME, (Object)client.getConfiguration().getProxyUsername());
        Assert.assertEquals((Object)PROXY_PASSWORD, (Object)client.getConfiguration().getProxyPassword());
    }

    @Test
    public void autoConfigWithMasterUrl() throws Exception {
        KubernetesFactoryAdapter factory = new KubernetesFactoryAdapter("http://example.com", null, null, false);
        KubernetesClient client = factory.createClient();
        Assert.assertEquals((Object)HTTP_PROXY, (Object)client.getConfiguration().getHttpProxy());
        Assert.assertEquals((Object)HTTPS_PROXY, (Object)client.getConfiguration().getHttpsProxy());
        Assert.assertArrayEquals((Object[])new String[]{NO_PROXY}, (Object[])client.getConfiguration().getNoProxy());
        Assert.assertEquals((Object)PROXY_USERNAME, (Object)client.getConfiguration().getProxyUsername());
        Assert.assertEquals((Object)PROXY_PASSWORD, (Object)client.getConfiguration().getProxyPassword());
    }
}

