/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import hudson.model.Label;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodLabel;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Always;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.csanchez.jenkins.plugins.kubernetes.volumes.EmptyDirVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.recipes.LocalData;
import org.mockito.Mockito;

public class KubernetesCloudTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public LoggerRule logs = new LoggerRule().record(Logger.getLogger(KubernetesCloud.class.getPackage().getName()), Level.ALL);

    @After
    public void tearDown() {
        System.getProperties().remove("KUBERNETES_JENKINS_URL");
    }

    @Test
    public void testInheritance() {
        ContainerTemplate jnlp = new ContainerTemplate("jnlp", "jnlp:1");
        ContainerTemplate maven = new ContainerTemplate("maven", "maven:1");
        maven.setTtyEnabled(true);
        maven.setCommand("cat");
        EmptyDirVolume podVolume = new EmptyDirVolume("/some/path", Boolean.valueOf(true));
        PodTemplate parent = new PodTemplate();
        parent.setName("parent");
        parent.setLabel("parent");
        parent.setContainers(Arrays.asList(jnlp));
        parent.setVolumes(Arrays.asList(podVolume));
        ContainerTemplate maven2 = new ContainerTemplate("maven", "maven:2");
        PodTemplate withNewMavenVersion = new PodTemplate();
        withNewMavenVersion.setContainers(Arrays.asList(maven2));
        PodTemplate result = PodTemplateUtils.combine((PodTemplate)parent, (PodTemplate)withNewMavenVersion);
    }

    @Test(expected=IllegalStateException.class)
    public void getJenkinsUrlOrDie_NoJenkinsUrl() {
        JenkinsLocationConfiguration.get().setUrl(null);
        KubernetesCloud cloud = new KubernetesCloud("name");
        String url = cloud.getJenkinsUrlOrDie();
        Assert.fail((String)("Should have thrown IllegalStateException at this point but got " + url + " instead."));
    }

    @Test
    public void getJenkinsUrlOrDie_UrlInCloud() {
        System.setProperty("KUBERNETES_JENKINS_URL", "http://mylocationinsysprop");
        KubernetesCloud cloud = new KubernetesCloud("name");
        cloud.setJenkinsUrl("http://mylocation");
        Assert.assertEquals((Object)"http://mylocation/", (Object)cloud.getJenkinsUrlOrDie());
    }

    @Test
    public void getJenkinsUrlOrDie_UrlInSysprop() {
        System.setProperty("KUBERNETES_JENKINS_URL", "http://mylocation");
        KubernetesCloud cloud = new KubernetesCloud("name");
        Assert.assertEquals((Object)"http://mylocation/", (Object)cloud.getJenkinsUrlOrDie());
    }

    @Test
    public void getJenkinsUrlOrDie_UrlInLocation() {
        JenkinsLocationConfiguration.get().setUrl("http://mylocation");
        KubernetesCloud cloud = new KubernetesCloud("name");
        Assert.assertEquals((Object)"http://mylocation/", (Object)cloud.getJenkinsUrlOrDie());
    }

    @Test
    public void getJenkinsUrlOrNull_NoJenkinsUrl() {
        JenkinsLocationConfiguration.get().setUrl(null);
        KubernetesCloud cloud = new KubernetesCloud("name");
        String url = cloud.getJenkinsUrlOrNull();
        Assert.assertNull((Object)url);
    }

    @Test
    public void getJenkinsUrlOrNull_UrlInCloud() {
        System.setProperty("KUBERNETES_JENKINS_URL", "http://mylocationinsysprop");
        KubernetesCloud cloud = new KubernetesCloud("name");
        cloud.setJenkinsUrl("http://mylocation");
        Assert.assertEquals((Object)"http://mylocation/", (Object)cloud.getJenkinsUrlOrNull());
    }

    @Test
    public void getJenkinsUrlOrNull_UrlInSysprop() {
        System.setProperty("KUBERNETES_JENKINS_URL", "http://mylocation");
        KubernetesCloud cloud = new KubernetesCloud("name");
        Assert.assertEquals((Object)"http://mylocation/", (Object)cloud.getJenkinsUrlOrNull());
    }

    @Test
    public void getJenkinsUrlOrNull_UrlInLocation() {
        JenkinsLocationConfiguration.get().setUrl("http://mylocation");
        KubernetesCloud cloud = new KubernetesCloud("name");
        Assert.assertEquals((Object)"http://mylocation/", (Object)cloud.getJenkinsUrlOrNull());
    }

    @Test
    public void testKubernetesCloudDefaults() {
        KubernetesCloud cloud = new KubernetesCloud("name");
        Assert.assertEquals((Object)PodRetention.getKubernetesCloudDefault(), (Object)cloud.getPodRetention());
    }

    @Test
    public void testInstanceCap() {
        KubernetesCloud cloud = new KubernetesCloud("name"){

            public KubernetesClient connect() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, CertificateEncodingException {
                KubernetesClient mockClient = (KubernetesClient)Mockito.mock(KubernetesClient.class);
                Mockito.when((Object)mockClient.getNamespace()).thenReturn((Object)"default");
                MixedOperation operation = (MixedOperation)Mockito.mock(MixedOperation.class);
                Mockito.when((Object)operation.inNamespace(Mockito.anyString())).thenReturn((Object)operation);
                Mockito.when((Object)operation.withLabels(Mockito.anyMap())).thenReturn((Object)operation);
                PodList podList = (PodList)Mockito.mock(PodList.class);
                Mockito.when((Object)podList.getItems()).thenReturn(new ArrayList());
                Mockito.when((Object)operation.list()).thenReturn((Object)podList);
                Mockito.when((Object)mockClient.pods()).thenReturn((Object)operation);
                return mockClient;
            }
        };
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setName("test");
        podTemplate.setLabel("test");
        cloud.addTemplate(podTemplate);
        Label test = Label.get((String)"test");
        Assert.assertTrue((boolean)cloud.canProvision(test));
        Collection plannedNodes = cloud.provision(test, 200);
        Assert.assertEquals((long)200L, (long)plannedNodes.size());
        podTemplate.setInstanceCap(5);
        plannedNodes = cloud.provision(test, 200);
        Assert.assertEquals((long)5L, (long)plannedNodes.size());
    }

    @Test
    public void testContainerCap() {
        KubernetesCloud cloud = new KubernetesCloud("name"){

            public KubernetesClient connect() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, CertificateEncodingException {
                KubernetesClient mockClient = (KubernetesClient)Mockito.mock(KubernetesClient.class);
                Mockito.when((Object)mockClient.getNamespace()).thenReturn((Object)"default");
                MixedOperation operation = (MixedOperation)Mockito.mock(MixedOperation.class);
                Mockito.when((Object)operation.inNamespace(Mockito.anyString())).thenReturn((Object)operation);
                Mockito.when((Object)operation.withLabels(Mockito.anyMap())).thenReturn((Object)operation);
                PodList podList = (PodList)Mockito.mock(PodList.class);
                Mockito.when((Object)podList.getItems()).thenReturn(new ArrayList());
                Mockito.when((Object)operation.list()).thenReturn((Object)podList);
                Mockito.when((Object)mockClient.pods()).thenReturn((Object)operation);
                return mockClient;
            }
        };
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setName("test");
        podTemplate.setLabel("test");
        cloud.addTemplate(podTemplate);
        Label test = Label.get((String)"test");
        Assert.assertTrue((boolean)cloud.canProvision(test));
        Collection plannedNodes = cloud.provision(test, 200);
        Assert.assertEquals((long)200L, (long)plannedNodes.size());
        cloud.setContainerCapStr("10");
        podTemplate.setInstanceCap(20);
        plannedNodes = cloud.provision(test, 200);
        Assert.assertEquals((long)10L, (long)plannedNodes.size());
    }

    @Test
    public void testPodLabels() {
        List defaultPodLabelsList = PodLabel.fromMap((Map)KubernetesCloud.DEFAULT_POD_LABELS);
        KubernetesCloud cloud = new KubernetesCloud("name");
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_POD_LABELS, (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)defaultPodLabelsList, (Object)cloud.getPodLabels());
        Assert.assertEquals((Object)cloud.getPodLabelsMap(), (Object)cloud.getLabels());
        List labels = PodLabel.listOf((String[])new String[]{"foo", "bar", "cat", "dog"});
        cloud.setPodLabels(labels);
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("foo", "bar");
        expected.put("cat", "dog");
        Assert.assertEquals(expected, (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)cloud.getPodLabelsMap(), (Object)cloud.getLabels());
        Assert.assertEquals(new ArrayList(labels), (Object)cloud.getPodLabels());
        cloud.setPodLabels(null);
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_POD_LABELS, (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)defaultPodLabelsList, (Object)cloud.getPodLabels());
        cloud.setPodLabels(new ArrayList());
        Assert.assertEquals((Object)KubernetesCloud.DEFAULT_POD_LABELS, (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)cloud.getPodLabelsMap(), (Object)cloud.getLabels());
        Assert.assertEquals((Object)defaultPodLabelsList, (Object)cloud.getPodLabels());
    }

    @Test
    public void testLabels() {
        KubernetesCloud cloud = new KubernetesCloud("name");
        List labels = PodLabel.listOf((String[])new String[]{"foo", "bar", "cat", "dog"});
        cloud.setPodLabels(labels);
        LinkedHashMap<String, String> labelsMap = new LinkedHashMap<String, String>();
        for (PodLabel l : labels) {
            labelsMap.put(l.getKey(), l.getValue());
        }
        cloud.setLabels(labelsMap);
        Assert.assertEquals(new LinkedHashMap(labelsMap), (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)labels, (Object)cloud.getPodLabels());
        cloud.setLabels(null);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"jenkins", (Object)"slave"), (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"jenkins", (Object)"slave"), (Object)cloud.getLabels());
        cloud.setLabels(new LinkedHashMap());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"jenkins", (Object)"slave"), (Object)cloud.getPodLabelsMap());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"jenkins", (Object)"slave"), (Object)cloud.getLabels());
    }

    @Test
    public void copyConstructor() throws Exception {
        PodTemplate pt = new PodTemplate();
        pt.setName("podTemplate");
        KubernetesCloud cloud = new KubernetesCloud("name");
        ArrayList objectProperties = Lists.newArrayList((Object[])new String[]{"templates", "podRetention", "podLabels", "labels", "serverCertificate"});
        for (String property : PropertyUtils.describe((Object)cloud).keySet()) {
            if (!PropertyUtils.isWriteable((Object)cloud, (String)property)) continue;
            Class propertyType = PropertyUtils.getPropertyType((Object)cloud, (String)property);
            if (propertyType == String.class) {
                if (property.endsWith("Str")) {
                    PropertyUtils.setProperty((Object)cloud, (String)property, (Object)RandomStringUtils.randomNumeric((int)3));
                    continue;
                }
                PropertyUtils.setProperty((Object)cloud, (String)property, (Object)RandomStringUtils.randomAlphabetic((int)10));
                continue;
            }
            if (propertyType == Integer.TYPE) {
                PropertyUtils.setProperty((Object)cloud, (String)property, (Object)RandomUtils.nextInt());
                continue;
            }
            if (propertyType == Integer.class) {
                PropertyUtils.setProperty((Object)cloud, (String)property, (Object)RandomUtils.nextInt());
                continue;
            }
            if (propertyType == Boolean.TYPE) {
                PropertyUtils.setProperty((Object)cloud, (String)property, (Object)RandomUtils.nextBoolean());
                continue;
            }
            if (objectProperties.contains(property)) continue;
            Assert.fail((String)("Unhandled field in copy constructor: " + property));
        }
        cloud.setServerCertificate("-----BEGIN CERTIFICATE-----");
        cloud.setTemplates(Collections.singletonList(pt));
        cloud.setPodRetention((PodRetention)new Always());
        cloud.setPodLabels(PodLabel.listOf((String[])new String[]{"foo", "bar", "cat", "dog"}));
        cloud.setLabels((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        KubernetesCloud copy = new KubernetesCloud("copy", cloud);
        Assert.assertEquals((Object)"copy", (Object)copy.name);
        Assert.assertEquals((String)"Expected cloud from copy constructor to be equal to the source except for name", (Object)cloud, (Object)copy);
    }

    @Test
    public void defaultWorkspaceVolume() throws Exception {
        KubernetesCloud cloud = new KubernetesCloud("kubernetes");
        this.j.jenkins.clouds.add((Object)cloud);
        this.j.jenkins.save();
        JenkinsRule.WebClient wc = this.j.createWebClient();
        HtmlPage p = wc.goTo("configure");
        HtmlForm f = p.getFormByName("config");
        HtmlButton button = HtmlFormUtil.getButtonByCaption((HtmlForm)f, (String)"Add Pod Template");
        button.click();
        DomElement templates = p.getElementByName("templates");
        HtmlInput templateName = this.getInputByName(templates, "_.name");
        templateName.setValueAttribute("default-workspace-volume");
        this.j.submit(f);
        cloud = (KubernetesCloud)this.j.jenkins.clouds.get(KubernetesCloud.class);
        PodTemplate podTemplate = (PodTemplate)cloud.getTemplates().get(0);
        Assert.assertEquals((Object)"default-workspace-volume", (Object)podTemplate.getName());
        Assert.assertEquals((Object)WorkspaceVolume.getDefault(), (Object)podTemplate.getWorkspaceVolume());
    }

    @Test
    public void minRetentionTimeout() {
        KubernetesCloud cloud = new KubernetesCloud("kubernetes");
        Assert.assertEquals((long)5L, (long)cloud.getRetentionTimeout());
        cloud.setRetentionTimeout(0);
        Assert.assertEquals((long)5L, (long)cloud.getRetentionTimeout());
    }

    @Test
    @LocalData
    public void minRetentionTimeoutReadResolve() {
        KubernetesCloud cloud = (KubernetesCloud)this.j.jenkins.clouds.get(KubernetesCloud.class);
        Assert.assertEquals((long)5L, (long)cloud.getRetentionTimeout());
    }

    public HtmlInput getInputByName(DomElement root, String name) {
        DomNodeList inputs = root.getElementsByTagName("input");
        for (HtmlElement input : inputs) {
            if (!name.equals(input.getAttribute("name"))) continue;
            return (HtmlInput)input;
        }
        return null;
    }
}

