/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import java.util.Collections;
import org.csanchez.jenkins.plugins.kubernetes.ContainerLivenessProbe;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.junit.Assert;
import org.junit.Test;

public class ContainerTemplateTest {
    @Test
    public void testCopyConstructorCreatesEqualInstance() {
        ContainerTemplate originalTemplate = new ContainerTemplate("myname", "myimage");
        originalTemplate.setPrivileged(true);
        originalTemplate.setAlwaysPullImage(true);
        originalTemplate.setWorkingDir("some/bogus/dir");
        originalTemplate.setCommand("run this");
        originalTemplate.setArgs("args");
        originalTemplate.setTtyEnabled(true);
        originalTemplate.setResourceRequestCpu("200m");
        originalTemplate.setResourceRequestMemory("2GiB");
        originalTemplate.setResourceLimitCpu("1000m");
        originalTemplate.setResourceLimitMemory("4GiB");
        originalTemplate.setShell("zsh");
        originalTemplate.setEnvVars(Collections.emptyList());
        originalTemplate.setPorts(Collections.emptyList());
        originalTemplate.setLivenessProbe(new ContainerLivenessProbe("test", 1, 2, 3, 4, 5));
        ContainerTemplate clonedTemplate = new ContainerTemplate(originalTemplate);
        Assert.assertEquals((String)"Cloned ContainerTemplate is not equal to the original one!", (Object)originalTemplate, (Object)clonedTemplate);
        Assert.assertEquals((String)"String representation (toString()) of the cloned and original ContainerTemplate is not equal!", (Object)originalTemplate.toString(), (Object)clonedTemplate.toString());
    }
}

