/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretCredentialsBinding
extends MultiBinding<ConjurSecretCredentials> {
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretCredentialsBinding.class.getName());
    private String variable;
    private String credentialsId;

    @DataBoundConstructor
    public ConjurSecretCredentialsBinding(String credentialsId) {
        super(credentialsId);
        this.credentialsId = credentialsId;
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workSpace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        MultiBinding.MultiEnvironment multiEnv;
        long start = System.nanoTime();
        try {
            LOGGER.log(Level.FINEST, String.format("bind to context %s", build.getDisplayName()));
            ConjurSecretCredentials conjurSecretCredential = (ConjurSecretCredentials)this.getCredentialsFor(build);
            conjurSecretCredential.setContext((ModelObject)build);
            multiEnv = new MultiBinding.MultiEnvironment(Collections.singletonMap(this.variable, conjurSecretCredential.getSecret().getPlainText()));
        }
        catch (CredentialNotFoundException e) {
            LOGGER.log(Level.SEVERE, String.format("No credentials found for: %s", build.getFullDisplayName()));
            multiEnv = new MultiBinding.MultiEnvironment(new HashMap());
        }
        long end = System.nanoTime();
        long execution = end - start;
        LOGGER.log(Level.FINEST, String.format("Execution of Class ConjurSecretCredentialsBinding. Method bind() time: %d miliseconds", (int)((double)execution / 1000000.0)));
        return multiEnv;
    }

    @NonNull
    private final <C> C getCredentialsFor(@NonNull Run<?, ?> build) throws IOException {
        long start = System.nanoTime();
        LOGGER.log(Level.FINEST, String.format("getCredentialsFor context %s credentialid %s", build.getFullDisplayName(), this.credentialsId));
        String newCredentialId = this.credentialsId.replaceAll("([${}])", "");
        IdCredentials cred = CredentialsProvider.findCredentialById((String)newCredentialId, ConjurSecretCredentials.class, build);
        if (cred == null) {
            throw new CredentialNotFoundException("Could not find credentials entry with ID '" + this.credentialsId + "'");
        }
        if (!this.type().isInstance(cred)) {
            Descriptor expected = Jenkins.getActiveInstance().getDescriptor(this.type());
            long end = System.nanoTime();
            long execution = end - start;
            LOGGER.log(Level.OFF, String.format("Execution of Class ConjurSecretCredentialsBinding -->Method getCredentialsFor() time: %d milliseconds", (int)((double)execution / 1000000.0)));
            throw new CredentialNotFoundException("Credentials '" + this.credentialsId + "' not found '" + String.valueOf(cred) + "' where '" + (expected != null ? expected.getDisplayName() : this.type().getName()) + "' was expected");
        }
        CredentialsProvider.track(build, (Credentials)cred);
        return (C)this.type().cast(cred);
    }

    public String getVariable() {
        return this.variable;
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        LOGGER.log(Level.FINEST, "Setting variable to {0}", variable);
        this.variable = variable;
    }

    protected Class<ConjurSecretCredentials> type() {
        return ConjurSecretCredentials.class;
    }

    public Set<String> variables() {
        return Collections.singleton(this.variable);
    }

    @Symbol(value={"conjurSecretCredential"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretCredentials> {
        private static final String DISPLAY_NAME = "Conjur Secret credentials";

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public boolean requiresWorkspace() {
            return false;
        }

        protected Class<ConjurSecretCredentials> type() {
            return ConjurSecretCredentials.class;
        }
    }
}

